/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.network;

import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.network.EmbraceEndpoint;
import io.embrace.android.gradle.swazzler.network.HttpCallResult;
import io.embrace.android.gradle.swazzler.network.NetworkService;
import io.embrace.android.gradle.swazzler.network.PostJsonParams;
import io.embrace.android.gradle.swazzler.network.UploadFileParams;
import io.embrace.android.gradle.swazzler.plugin.PluginErrorMessages;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u0002J\f\u0010\u001d\u001a\u00020\u001e*\u00020\u0019H\u0002J\f\u0010\u001f\u001a\u00020\u0005*\u00020 H\u0002J \u0010!\u001a\u00020\u0014*\u00020\u001e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00052\b\u0010\"\u001a\u0004\u0018\u00010\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\t\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00000\u0000 \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/embrace/android/gradle/swazzler/network/OkHttpNetworkService;", "Lio/embrace/android/gradle/swazzler/network/NetworkService;", "okHttpClient", "Lokhttp3/OkHttpClient;", "baseUrl", "", "muteLogs", "", "(Lokhttp3/OkHttpClient;Ljava/lang/String;Z)V", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "mediaTypeJson", "Lokhttp3/MediaType;", "mediaTypeText", "buildMultipartBody", "Lokhttp3/MultipartBody;", "uploadFileParams", "Lio/embrace/android/gradle/swazzler/network/UploadFileParams;", "postJson", "Lio/embrace/android/gradle/swazzler/network/HttpCallResult;", "postJsonParams", "Lio/embrace/android/gradle/swazzler/network/PostJsonParams;", "uploadFile", "createRequest", "Lokhttp3/Request;", "Lokhttp3/RequestBody;", "url", "appId", "execute", "Lokhttp3/Response;", "getFullUrl", "Lio/embrace/android/gradle/swazzler/network/EmbraceEndpoint;", "toResult", "apiToken", "embrace-bug-shake-gradle-plugin"})
public final class OkHttpNetworkService
implements NetworkService {
    private final MediaType mediaTypeJson;
    private final MediaType mediaTypeText;
    private final Logger<OkHttpNetworkService> logger;
    private final OkHttpClient okHttpClient;
    private final String baseUrl;
    private final boolean muteLogs;

    @Override
    @NotNull
    public HttpCallResult postJson(@NotNull PostJsonParams postJsonParams) {
        Intrinsics.checkNotNullParameter((Object)postJsonParams, (String)"postJsonParams");
        try {
            RequestBody jsonRequestBody = RequestBody.Companion.create(postJsonParams.getBody(), this.mediaTypeJson);
            String url = this.getFullUrl(postJsonParams.getEndpoint());
            Request request = this.createRequest(jsonRequestBody, url, postJsonParams.getAppId());
            Response response = this.execute(request);
            return this.toResult(response, postJsonParams.getAppId(), postJsonParams.getApiToken());
        }
        catch (Exception e) {
            if (!this.muteLogs) {
                this.logger.error("Exception: " + e.getMessage());
            }
            HttpCallResult httpCallResult = new HttpCallResult.Error(e);
            return httpCallResult;
        }
    }

    @Override
    @NotNull
    public HttpCallResult uploadFile(@NotNull UploadFileParams uploadFileParams) {
        HttpCallResult httpCallResult;
        Intrinsics.checkNotNullParameter((Object)uploadFileParams, (String)"uploadFileParams");
        try {
            MultipartBody requestBody = this.buildMultipartBody(uploadFileParams);
            String url = this.getFullUrl(uploadFileParams.getEndpoint());
            Request request = this.createRequest((RequestBody)requestBody, url, uploadFileParams.getAppId());
            Response response = this.execute(request);
            httpCallResult = this.toResult(response, uploadFileParams.getAppId(), uploadFileParams.getApiToken());
        }
        catch (Exception e) {
            if (!this.muteLogs) {
                this.logger.error("Exception: " + e.getMessage());
            }
            httpCallResult = new HttpCallResult.Error(e);
        }
        return httpCallResult;
    }

    private final Request createRequest(RequestBody $this$createRequest, String url, String appId) {
        Request.Builder builder = new Request.Builder().url(url);
        boolean bl = false;
        boolean bl2 = false;
        Request.Builder $this$apply = builder;
        boolean bl3 = false;
        CharSequence charSequence = appId;
        boolean bl4 = false;
        boolean bl5 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            $this$apply.addHeader("X-EM-AID", appId);
        }
        return builder.post($this$createRequest).build();
    }

    private final Response execute(Request $this$execute) {
        return this.okHttpClient.newCall($this$execute).execute();
    }

    private final HttpCallResult toResult(Response $this$toResult, String appId, String apiToken) {
        HttpCallResult httpCallResult;
        if ($this$toResult.isSuccessful()) {
            String responseBody;
            ResponseBody responseBody2 = $this$toResult.body();
            String string = responseBody = responseBody2 != null ? responseBody2.string() : null;
            if (!this.muteLogs) {
                this.logger.debug("Response: " + responseBody);
            }
            httpCallResult = new HttpCallResult.Success(responseBody);
        } else {
            String errorMessage;
            int statusCode = $this$toResult.code();
            switch (statusCode) {
                case 403: {
                    String string = PluginErrorMessages.getInvalidApiTokenError(appId, apiToken);
                    break;
                }
                default: {
                    ResponseBody responseBody = $this$toResult.body();
                    String string = errorMessage = responseBody != null ? responseBody.string() : null;
                }
            }
            if (!this.muteLogs) {
                this.logger.error("Error code: " + statusCode + " | message: " + errorMessage);
            }
            httpCallResult = new HttpCallResult.Failure(errorMessage, statusCode);
        }
        HttpCallResult result = httpCallResult;
        $this$toResult.close();
        return result;
    }

    private final String getFullUrl(EmbraceEndpoint $this$getFullUrl) {
        return this.baseUrl + $this$getFullUrl.getUrl();
    }

    private final MultipartBody buildMultipartBody(UploadFileParams uploadFileParams) {
        MultipartBody.Builder builder = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM).addFormDataPart("app", uploadFileParams.getAppId()).addFormDataPart("token", uploadFileParams.getApiToken());
        boolean bl = false;
        boolean bl2 = false;
        MultipartBody.Builder $this$apply = builder;
        boolean bl3 = false;
        CharSequence charSequence = uploadFileParams.getBuildId();
        boolean bl4 = false;
        boolean bl5 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            $this$apply.addFormDataPart("id", uploadFileParams.getBuildId());
        }
        return builder.addFormDataPart("file", uploadFileParams.getFileName(), RequestBody.Companion.create(uploadFileParams.getFileToUpload(), this.mediaTypeText)).build();
    }

    public OkHttpNetworkService(@NotNull OkHttpClient okHttpClient, @NotNull String baseUrl, boolean muteLogs) {
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        this.okHttpClient = okHttpClient;
        this.baseUrl = baseUrl;
        this.muteLogs = muteLogs;
        this.mediaTypeJson = MediaType.Companion.get("application/json");
        this.mediaTypeText = MediaType.Companion.get("text/plain");
        this.logger = Logger.newLogger(OkHttpNetworkService.class);
    }

    public /* synthetic */ OkHttpNetworkService(OkHttpClient okHttpClient, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(okHttpClient, string, bl);
    }
}

