/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.ApplicationVariant;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.config.Config;
import io.embrace.android.gradle.swazzler.config.VariantConfiguration;
import io.embrace.android.gradle.swazzler.config.variant.VariantConfigurationBuilderForValueSource;
import io.embrace.android.gradle.swazzler.di.DependencyInjectionProvider;
import io.embrace.android.gradle.swazzler.di.SetupDependencyInjectionProvider;
import io.embrace.android.gradle.swazzler.instrumentation.AsmCompatibilityHelper;
import io.embrace.android.gradle.swazzler.instrumentation.AsmTasks;
import io.embrace.android.gradle.swazzler.plugin.ProjectPropertiesKt;
import io.embrace.android.gradle.swazzler.plugin.SwazzlerException;
import io.embrace.android.gradle.swazzler.plugin.SwazzlerPlugin;
import io.embrace.android.gradle.swazzler.plugin.TaskRegistrationAction;
import io.embrace.android.gradle.swazzler.plugin.buildid.BuildIdProvider;
import io.embrace.android.gradle.swazzler.plugin.buildid.DefaultBuildIdProviderKt;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildReporter;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.SetupExecutionPhaseBuildReporter;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.configphase.GradlePhaseInfo;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.configphase.SetupGradlePhaseInfo;
import io.embrace.android.gradle.swazzler.plugin.dependency.DependenciesInstallerKt;
import io.embrace.android.gradle.swazzler.plugin.extension.EmbraceExtensionInternal;
import io.embrace.android.gradle.swazzler.plugin.extension.SwazzlerExtension;
import io.embrace.android.gradle.swazzler.plugin.extension.utils.BuildIdToEmbraceExtensionInternal;
import io.embrace.android.gradle.swazzler.plugin.extension.utils.ConfigToEmbraceExtensionInternal;
import io.embrace.android.gradle.swazzler.plugin.extension.utils.ProjectNotSmartConfigurationToEmbraceExtensionInternal;
import io.embrace.android.gradle.swazzler.plugin.extension.utils.ProjectSmartConfigurationToEmbraceExtensionInternal;
import io.embrace.android.gradle.swazzler.plugin.extension.utils.VariantConfigurationToEmbraceExtensionInternal;
import io.embrace.android.gradle.swazzler.plugin.extension.utils.VariantDataToEmbraceExtensionInternal;
import io.embrace.android.gradle.swazzler.plugin.extension.utils.VariantSmartConfigurationToEmbraceExtensionInternal;
import io.embrace.android.gradle.swazzler.plugin.model.AndroidCompactedVariantData;
import io.embrace.android.gradle.swazzler.plugin.oldtransform.OldTransformTasksKt;
import io.embrace.android.gradle.swazzler.service.sentry.SentryLogger;
import io.embrace.android.gradle.swazzler.service.sentry.SetupExecutionPhaseSentryLogger;
import io.embrace.android.gradle.swazzler.testcheckpoints.SetupTestCheckpoints;
import io.embrace.android.gradle.swazzler.testcheckpoints.SwazzlerTestCheckPoints;
import io.embrace.android.gradle.swazzler.util.DeprecationsVerificator;
import io.embrace.android.gradle.swazzler.util.GradleCompatibilityHelper;
import io.embrace.android.gradle.swazzler.util.SystemWrapper;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.HasMultipleValues;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0002JL\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00192\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010 \u001a\u00020\u000e2\n\u0010!\u001a\u00060\"j\u0002`#H\u0002J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00192\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u0002H\u0002J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J(\u0010(\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0011H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u0006\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00000\u0000 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/SwazzlerPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "buildReporter", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildReporter;", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "sentryLogger", "Lio/embrace/android/gradle/swazzler/service/sentry/SentryLogger;", "testCheckpoints", "Lio/embrace/android/gradle/swazzler/testcheckpoints/SwazzlerTestCheckPoints;", "apply", "", "project", "buildConfig", "Lio/embrace/android/gradle/swazzler/config/Config;", "configureEmbraceExtensionInternalForProject", "swazzlerExtension", "Lio/embrace/android/gradle/swazzler/plugin/extension/SwazzlerExtension;", "configureEmbraceExtensionInternalForVariant", "variant", "Lcom/android/build/gradle/api/ApplicationVariant;", "variantConfigurationProvider", "Lorg/gradle/api/provider/Provider;", "Lio/embrace/android/gradle/swazzler/config/VariantConfiguration;", "buildIdProvider", "Lio/embrace/android/gradle/swazzler/plugin/buildid/BuildIdProvider;", "config", "androidExtension", "Lcom/android/build/gradle/AppExtension;", "handlePluginException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "initializeBuildIdProvider", "onProjectEvaluated", "evaluatedProject", "registerDependencyManager", "registerSwazzling", "embrace-bug-shake-gradle-plugin"})
public final class SwazzlerPlugin
implements Plugin<Project> {
    private final Logger<SwazzlerPlugin> logger = Logger.newLogger(SwazzlerPlugin.class);
    private SentryLogger sentryLogger;
    private BuildReporter buildReporter;
    private SwazzlerTestCheckPoints testCheckpoints;

    public void apply(@NotNull Project project) throws SwazzlerException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectLayout projectLayout = project.getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"project.layout");
        Directory directory = projectLayout.getProjectDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"project.layout.projectDirectory");
        DeprecationsVerificator.INSTANCE.verifySwazzlerJsonConfiguration(directory);
        Provider<? extends GradlePhaseInfo> provider2 = SetupGradlePhaseInfo.INSTANCE.build(project);
        boolean bl = false;
        boolean bl2 = false;
        Provider<? extends GradlePhaseInfo> it = provider2;
        boolean bl3 = false;
        this.logger.info("Gradle configuration phase running");
        ((GradlePhaseInfo)it.get()).onConfigurationPhaseRan();
        Provider<? extends GradlePhaseInfo> gradlePhaseInfo = provider2;
        SystemWrapper systemWrapper = new SystemWrapper();
        SwazzlerExtension swazzlerExtension = (SwazzlerExtension)project.getExtensions().create("swazzler", SwazzlerExtension.class, new Object[]{project});
        this.logger.debug("Swazzler extension successfully created");
        ListProperty variantConfigurationsListProperty = project.getObjects().listProperty(VariantConfiguration.class).convention((Iterable)CollectionsKt.emptyList());
        Provider<BuildIdProvider> buildIdProvider = this.initializeBuildIdProvider(project);
        SetupExecutionPhaseSentryLogger setupExecutionPhaseSentryLogger = new SetupExecutionPhaseSentryLogger();
        ListProperty listProperty = variantConfigurationsListProperty;
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"variantConfigurationsListProperty");
        this.sentryLogger = setupExecutionPhaseSentryLogger.invoke(project, systemWrapper, (ListProperty<VariantConfiguration>)listProperty, buildIdProvider);
        SetupTestCheckpoints setupTestCheckpoints = new SetupTestCheckpoints();
        Project project2 = project.getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project.rootProject");
        ProjectLayout projectLayout2 = project2.getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)projectLayout2, (String)"project.rootProject.layout");
        Directory directory2 = projectLayout2.getProjectDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)directory2, (String)"project.rootProject.layout.projectDirectory");
        SwazzlerTestCheckPoints swazzlerTestCheckPoints = this.testCheckpoints = setupTestCheckpoints.invoke(project, directory2, ProjectPropertiesKt.isTestCheckpointsEnabled(project));
        if (swazzlerTestCheckPoints == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testCheckpoints");
        }
        swazzlerTestCheckPoints.started();
        Logger.setEmbraceLogLevel(ProjectPropertiesKt.getLogLevel(project));
        this.logger.info("Embrace plugin entry point for project=" + project.getName() + ". Will not configure until " + "android application plugin has been applied.");
        project.getPluginManager().withPlugin("com.android.application", (Action)new Action<AppliedPlugin>(this, project, variantConfigurationsListProperty, systemWrapper, buildIdProvider, gradlePhaseInfo, swazzlerExtension){
            final /* synthetic */ SwazzlerPlugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ ListProperty $variantConfigurationsListProperty;
            final /* synthetic */ SystemWrapper $systemWrapper;
            final /* synthetic */ Provider $buildIdProvider;
            final /* synthetic */ Provider $gradlePhaseInfo;
            final /* synthetic */ SwazzlerExtension $swazzlerExtension;

            public final void execute(AppliedPlugin it) {
                SwazzlerPlugin.access$getLogger$p(this.this$0).info("Android Application plugin has been applied for project=" + this.$project.getName() + ". Starting to configure " + "embrace plugin.");
                try {
                    Config config = SwazzlerPlugin.access$buildConfig(this.this$0, this.$project);
                    V v = this.$project.getProperties().get("android");
                    if (v == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.android.build.gradle.AppExtension");
                    }
                    AppExtension androidExtension = (AppExtension)v;
                    SwazzlerPlugin.access$getLogger$p(this.this$0).debug("Android extension obtained.");
                    EmbraceExtensionInternal extension = (EmbraceExtensionInternal)this.$project.getExtensions().create("embrace-internal", EmbraceExtensionInternal.class, new Object[]{this.$project.getObjects()});
                    NamedDomainObjectContainer namedDomainObjectContainer = this.$project.getObjects().domainObjectContainer(EmbraceExtensionInternal.VariantExtension.class);
                    Intrinsics.checkNotNullExpressionValue((Object)namedDomainObjectContainer, (String)"project.objects.domainOb\u2026ava\n                    )");
                    extension.setVariants((NamedDomainObjectContainer<EmbraceExtensionInternal.VariantExtension>)namedDomainObjectContainer);
                    SwazzlerPlugin.access$getLogger$p(this.this$0).debug("Embrace extension successfully created");
                    SetupDependencyInjectionProvider setupDependencyInjectionProvider = new SetupDependencyInjectionProvider(null, 1, null);
                    Provider<? extends DependencyInjectionProvider> dependencyInjectionProvider = setupDependencyInjectionProvider.invoke(this.$project, config);
                    this.$variantConfigurationsListProperty.finalizeValueOnRead();
                    SetupExecutionPhaseBuildReporter setupExecutionPhaseBuildReporter = new SetupExecutionPhaseBuildReporter();
                    ListProperty listProperty = this.$variantConfigurationsListProperty;
                    Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"variantConfigurationsListProperty");
                    SwazzlerPlugin.access$setBuildReporter$p(this.this$0, setupExecutionPhaseBuildReporter.invoke(this.$project, this.$systemWrapper, dependencyInjectionProvider, (ListProperty<VariantConfiguration>)listProperty, (Provider<BuildIdProvider>)this.$buildIdProvider, (Provider<? extends GradlePhaseInfo>)this.$gradlePhaseInfo));
                    SwazzlerPlugin.access$getLogger$p(this.this$0).debug("About to register swazzling.");
                    SwazzlerExtension swazzlerExtension = this.$swazzlerExtension;
                    Intrinsics.checkNotNullExpressionValue((Object)swazzlerExtension, (String)"swazzlerExtension");
                    SwazzlerPlugin.access$registerSwazzling(this.this$0, androidExtension, swazzlerExtension, this.$project, config);
                    ProjectLayout projectLayout = this.$project.getLayout();
                    Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"project.layout");
                    Directory directory = projectLayout.getProjectDirectory();
                    Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"project.layout.projectDirectory");
                    ProviderFactory providerFactory = this.$project.getProviders();
                    Intrinsics.checkNotNullExpressionValue((Object)providerFactory, (String)"project.providers");
                    VariantConfigurationBuilderForValueSource variantConfigurationBuilder = new VariantConfigurationBuilderForValueSource(directory, providerFactory);
                    SwazzlerPlugin.access$getLogger$p(this.this$0).info("About to configure each variant");
                    SwazzlerExtension swazzlerExtension2 = this.$swazzlerExtension;
                    Intrinsics.checkNotNullExpressionValue((Object)swazzlerExtension2, (String)"swazzlerExtension");
                    SwazzlerPlugin.access$configureEmbraceExtensionInternalForProject(this.this$0, this.$project, swazzlerExtension2);
                    TaskRegistrationAction tasksRegistrationAction = new TaskRegistrationAction(this.$project);
                    androidExtension.getApplicationVariants().configureEach((Action)new Action<ApplicationVariant>(this, variantConfigurationBuilder, config, androidExtension, tasksRegistrationAction){
                        final /* synthetic */ apply.1 this$0;
                        final /* synthetic */ VariantConfigurationBuilderForValueSource $variantConfigurationBuilder;
                        final /* synthetic */ Config $config;
                        final /* synthetic */ AppExtension $androidExtension;
                        final /* synthetic */ TaskRegistrationAction $tasksRegistrationAction;

                        public final void execute(@NotNull ApplicationVariant variant) {
                            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                            try {
                                SwazzlerPlugin.access$getLogger$p(this.this$0.this$0).info("Configuring variant=" + variant.getName());
                                SwazzlerPlugin.access$getLogger$p(this.this$0.this$0).debug("Adding buildId for variant=" + variant.getName());
                                BuildIdProvider buildIdProvider = (BuildIdProvider)this.this$0.$buildIdProvider.get();
                                String string = variant.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.name");
                                buildIdProvider.addBuildIdFor(string);
                                Provider<VariantConfiguration> variantConfiguration = this.$variantConfigurationBuilder.buildVariantConfiguration(variant);
                                SwazzlerPlugin swazzlerPlugin = this.this$0.this$0;
                                Provider provider2 = this.this$0.$buildIdProvider;
                                Project project = this.this$0.$project;
                                SwazzlerExtension swazzlerExtension = this.this$0.$swazzlerExtension;
                                Intrinsics.checkNotNullExpressionValue((Object)swazzlerExtension, (String)"swazzlerExtension");
                                SwazzlerPlugin.access$configureEmbraceExtensionInternalForVariant(swazzlerPlugin, variant, variantConfiguration, provider2, this.$config, this.$androidExtension, project, swazzlerExtension);
                                ListProperty listProperty = this.this$0.$variantConfigurationsListProperty;
                                Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"variantConfigurationsListProperty");
                                GradleCompatibilityHelper.INSTANCE.add((HasMultipleValues)listProperty, variantConfiguration);
                                SwazzlerPlugin.access$getLogger$p(this.this$0.this$0).debug("About to execute TaskRegistrationAction for variant=" + variant.getName());
                                this.$tasksRegistrationAction.execute(variant);
                                SwazzlerPlugin.access$getLogger$p(this.this$0.this$0).debug("Successfully executed TaskRegistrationAction for variant=" + variant.getName());
                                SwazzlerPlugin.access$getLogger$p(this.this$0.this$0).info("Successfully configured variant=" + variant.getName());
                            }
                            catch (Exception e) {
                                SwazzlerPlugin.access$handlePluginException(this.this$0.this$0, e);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$variantConfigurationBuilder = variantConfigurationBuilderForValueSource;
                            this.$config = config;
                            this.$androidExtension = appExtension;
                            this.$tasksRegistrationAction = taskRegistrationAction;
                        }
                    });
                    SwazzlerPlugin.access$getLogger$p(this.this$0).info("Registering Project's after evaluation listener.");
                    this.$project.afterEvaluate((Action)new Action<Project>(this){
                        final /* synthetic */ apply.1 this$0;

                        public final void execute(Project evaluatedProject) {
                            SwazzlerPlugin swazzlerPlugin = this.this$0.this$0;
                            Project project = evaluatedProject;
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"evaluatedProject");
                            SwazzlerPlugin.access$onProjectEvaluated(swazzlerPlugin, project);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                    SwazzlerPlugin.access$getTestCheckpoints$p(this.this$0).finished();
                }
                catch (Exception e) {
                    SwazzlerPlugin.access$handlePluginException(this.this$0, e);
                }
            }
            {
                this.this$0 = swazzlerPlugin;
                this.$project = project;
                this.$variantConfigurationsListProperty = listProperty;
                this.$systemWrapper = systemWrapper;
                this.$buildIdProvider = provider2;
                this.$gradlePhaseInfo = provider3;
                this.$swazzlerExtension = swazzlerExtension;
            }
        });
    }

    private final void onProjectEvaluated(Project evaluatedProject) {
        try {
            this.logger.info("Project=" + evaluatedProject.getName() + " has been evaluated, Embrace.io tasks will try to get registered.");
            this.registerDependencyManager(evaluatedProject);
            this.logger.info("Successfully configured Embrace.io swazzler plugin.");
        }
        catch (Exception e) {
            this.handlePluginException(e);
        }
    }

    private final void configureEmbraceExtensionInternalForProject(Project project, SwazzlerExtension swazzlerExtension) {
        ExtensionContainer extensionContainer = project.getExtensions();
        boolean bl = false;
        boolean bl2 = false;
        ExtensionContainer $this$with = extensionContainer;
        boolean bl3 = false;
        $this$with.configure(EmbraceExtensionInternal.class, (Action)new ProjectSmartConfigurationToEmbraceExtensionInternal(project, swazzlerExtension));
        $this$with.configure(EmbraceExtensionInternal.class, (Action)new ProjectNotSmartConfigurationToEmbraceExtensionInternal(swazzlerExtension));
    }

    private final void configureEmbraceExtensionInternalForVariant(ApplicationVariant variant, Provider<VariantConfiguration> variantConfigurationProvider, Provider<BuildIdProvider> buildIdProvider, Config config, AppExtension androidExtension, Project project, SwazzlerExtension swazzlerExtension) {
        AndroidCompactedVariantData variantInfo = AndroidCompactedVariantData.Companion.from(variant);
        ExtensionContainer extensionContainer = project.getExtensions();
        boolean bl = false;
        boolean bl2 = false;
        ExtensionContainer $this$with = extensionContainer;
        boolean bl3 = false;
        String string = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.name");
        ObjectFactory objectFactory = project.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.objects");
        ProviderFactory providerFactory = project.getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)providerFactory, (String)"project.providers");
        $this$with.configure(EmbraceExtensionInternal.class, (Action)new VariantConfigurationToEmbraceExtensionInternal(string, variantConfigurationProvider, objectFactory, providerFactory));
        String string2 = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"variant.name");
        ProjectLayout projectLayout = project.getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"project.layout");
        DirectoryProperty directoryProperty = projectLayout.getBuildDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"project.layout.buildDirectory");
        Provider provider2 = (Provider)directoryProperty;
        ObjectFactory objectFactory2 = project.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory2, (String)"project.objects");
        $this$with.configure(EmbraceExtensionInternal.class, (Action)new VariantDataToEmbraceExtensionInternal(string2, variantInfo, (Provider<Directory>)provider2, objectFactory2));
        String string3 = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"variant.name");
        ObjectFactory objectFactory3 = project.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory3, (String)"project.objects");
        ProviderFactory providerFactory2 = project.getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)providerFactory2, (String)"project.providers");
        $this$with.configure(EmbraceExtensionInternal.class, (Action)new BuildIdToEmbraceExtensionInternal(string3, buildIdProvider, objectFactory3, providerFactory2));
        $this$with.configure(EmbraceExtensionInternal.class, (Action)new ConfigToEmbraceExtensionInternal(config));
        SentryLogger sentryLogger = this.sentryLogger;
        if (sentryLogger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sentryLogger");
        }
        $this$with.configure(EmbraceExtensionInternal.class, (Action)new VariantSmartConfigurationToEmbraceExtensionInternal(variantConfigurationProvider, variantInfo, androidExtension, project, sentryLogger, swazzlerExtension));
    }

    private final void registerSwazzling(AppExtension androidExtension, SwazzlerExtension swazzlerExtension, Project project, Config config) {
        if (AsmCompatibilityHelper.INSTANCE.shouldUseASM(project)) {
            this.logger.info("Using WebObject ASM API for Swazzling");
            AsmTasks.registerAsmTasks(project, swazzlerExtension);
            this.logger.debug("Successfully registered WebOjbect ASM API");
        } else {
            this.logger.info("Using Transform API for Swazzling");
            OldTransformTasksKt.registerOldTransformTasks(project, androidExtension, swazzlerExtension, config);
            this.logger.debug("Successfully registered Old Transform API");
        }
    }

    private final Provider<BuildIdProvider> initializeBuildIdProvider(Project project) {
        this.logger.debug("Creating build id provider that will be used for all tasks");
        Provider<BuildIdProvider> buildIdProvider = DefaultBuildIdProviderKt.buildBuildIdProvider(project);
        this.logger.debug("Successfully created build id provider");
        return buildIdProvider;
    }

    private final void handlePluginException(Exception e) {
        SwazzlerException exception;
        block2: {
            exception = new SwazzlerException("An exception was thrown while configuring SwazzlerPlugin.", e);
            SwazzlerTestCheckPoints swazzlerTestCheckPoints = this.testCheckpoints;
            if (swazzlerTestCheckPoints == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"testCheckpoints");
            }
            swazzlerTestCheckPoints.exception(e);
            SentryLogger sentryLogger = this.sentryLogger;
            if (sentryLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sentryLogger");
            }
            sentryLogger.sendException(exception);
            BuildReporter buildReporter = this.buildReporter;
            if (buildReporter == null) break block2;
            buildReporter.onException(e);
        }
        throw (Throwable)exception;
    }

    private final Config buildConfig(Project project) {
        Config config;
        this.logger.debug("Initializing config");
        String baseUrl = ProjectPropertiesKt.getBaseUrl(project);
        CharSequence charSequence = baseUrl;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this.logger.debug("Replacing host with:" + baseUrl);
            config = new Config(baseUrl, null, 2, null);
        } else {
            config = new Config(null, null, 3, null);
        }
        return config;
    }

    private final void registerDependencyManager(Project project) {
        this.logger.info("Will use new dependencies installer");
        DependenciesInstallerKt.installDependencies(project, DependenciesInstallerKt.getInstallStrategies());
    }

    public static final /* synthetic */ Logger access$getLogger$p(SwazzlerPlugin $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Config access$buildConfig(SwazzlerPlugin $this, Project project) {
        return $this.buildConfig(project);
    }

    public static final /* synthetic */ BuildReporter access$getBuildReporter$p(SwazzlerPlugin $this) {
        return $this.buildReporter;
    }

    public static final /* synthetic */ void access$setBuildReporter$p(SwazzlerPlugin $this, BuildReporter buildReporter) {
        $this.buildReporter = buildReporter;
    }

    public static final /* synthetic */ void access$registerSwazzling(SwazzlerPlugin $this, AppExtension androidExtension, SwazzlerExtension swazzlerExtension, Project project, Config config) {
        $this.registerSwazzling(androidExtension, swazzlerExtension, project, config);
    }

    public static final /* synthetic */ void access$configureEmbraceExtensionInternalForProject(SwazzlerPlugin $this, Project project, SwazzlerExtension swazzlerExtension) {
        $this.configureEmbraceExtensionInternalForProject(project, swazzlerExtension);
    }

    public static final /* synthetic */ void access$configureEmbraceExtensionInternalForVariant(SwazzlerPlugin $this, ApplicationVariant variant, Provider variantConfigurationProvider, Provider buildIdProvider, Config config, AppExtension androidExtension, Project project, SwazzlerExtension swazzlerExtension) {
        $this.configureEmbraceExtensionInternalForVariant(variant, (Provider<VariantConfiguration>)variantConfigurationProvider, (Provider<BuildIdProvider>)buildIdProvider, config, androidExtension, project, swazzlerExtension);
    }

    public static final /* synthetic */ void access$handlePluginException(SwazzlerPlugin $this, Exception e) {
        $this.handlePluginException(e);
    }

    public static final /* synthetic */ void access$onProjectEvaluated(SwazzlerPlugin $this, Project evaluatedProject) {
        $this.onProjectEvaluated(evaluatedProject);
    }

    public static final /* synthetic */ SwazzlerTestCheckPoints access$getTestCheckpoints$p(SwazzlerPlugin $this) {
        SwazzlerTestCheckPoints swazzlerTestCheckPoints = $this.testCheckpoints;
        if (swazzlerTestCheckPoints == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testCheckpoints");
        }
        return swazzlerTestCheckPoints;
    }

    public static final /* synthetic */ void access$setTestCheckpoints$p(SwazzlerPlugin $this, SwazzlerTestCheckPoints swazzlerTestCheckPoints) {
        $this.testCheckpoints = swazzlerTestCheckPoints;
    }
}

