/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin;

import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.di.DependencyInjectionAware;
import io.embrace.android.gradle.swazzler.di.DependencyInjectionProvider;
import io.embrace.android.gradle.swazzler.plugin.TaskException;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildReporter;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildReporterAwareTask;
import io.embrace.android.gradle.swazzler.plugin.model.AndroidCompactedVariantData;
import io.embrace.android.gradle.swazzler.service.sentry.SentryAwareTask;
import io.embrace.android.gradle.swazzler.service.sentry.SentryLogger;
import io.embrace.android.gradle.swazzler.service.sentry.SentryVariantData;
import io.embrace.android.gradle.swazzler.testcheckpoints.SwazzlerTestCheckPoints;
import io.embrace.android.gradle.swazzler.testcheckpoints.TestCheckpointsAwareTask;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\bH\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0017J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\bH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\bH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\bH\u0007J6\u0010\u001f\u001a\u00020 \"\b\b\u0000\u0010!*\u00020\u00002\u0006\u0010\"\u001a\u00020\u00172\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u000e\u0010#\u001a\n\u0012\u0004\u0012\u0002H!\u0018\u00010$J\b\u0010%\u001a\u00020 H&J\b\u0010&\u001a\u00020 H\u0007R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\f\u001a&\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00000\u0000 \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/GradleTask;", "Lorg/gradle/api/DefaultTask;", "Lio/embrace/android/gradle/swazzler/service/sentry/SentryAwareTask;", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildReporterAwareTask;", "Lio/embrace/android/gradle/swazzler/di/DependencyInjectionAware;", "Lio/embrace/android/gradle/swazzler/testcheckpoints/TestCheckpointsAwareTask;", "()V", "_dependency_injection_provider", "Lorg/gradle/api/provider/Property;", "Lio/embrace/android/gradle/swazzler/di/DependencyInjectionProvider;", "buildReporterProperty", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildReporter;", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "sentryLoggerProperty", "Lio/embrace/android/gradle/swazzler/service/sentry/SentryLogger;", "sentryVariantData", "Lorg/gradle/api/provider/Provider;", "Lio/embrace/android/gradle/swazzler/service/sentry/SentryVariantData;", "testCheckpointsProperty", "Lio/embrace/android/gradle/swazzler/testcheckpoints/SwazzlerTestCheckPoints;", "variantDataProperty", "Lio/embrace/android/gradle/swazzler/plugin/model/AndroidCompactedVariantData;", "getBuildReporter", "getDependencyInjectionProvider", "getObjects", "Lorg/gradle/api/model/ObjectFactory;", "getSentryLogger", "getTestCheckpoints", "getVariantInfo", "init", "", "T", "variantData", "configurationAction", "Lorg/gradle/api/Action;", "onRun", "run", "embrace-bug-shake-gradle-plugin"})
public abstract class GradleTask
extends DefaultTask
implements SentryAwareTask,
BuildReporterAwareTask,
DependencyInjectionAware,
TestCheckpointsAwareTask {
    private final Logger<GradleTask> logger = Logger.newLogger(GradleTask.class);
    private final Property<DependencyInjectionProvider> _dependency_injection_provider;
    private final Property<SentryLogger> sentryLoggerProperty;
    private final Property<BuildReporter> buildReporterProperty;
    private final Property<SwazzlerTestCheckPoints> testCheckpointsProperty;
    private final Property<AndroidCompactedVariantData> variantDataProperty;
    private Provider<SentryVariantData> sentryVariantData;

    @Override
    @NotNull
    public Property<DependencyInjectionProvider> getDependencyInjectionProvider() {
        return this._dependency_injection_provider;
    }

    @Override
    @NotNull
    public Property<SentryLogger> getSentryLogger() {
        return this.sentryLoggerProperty;
    }

    @Override
    @NotNull
    public Property<BuildReporter> getBuildReporter() {
        return this.buildReporterProperty;
    }

    @Override
    @NotNull
    public Property<SwazzlerTestCheckPoints> getTestCheckpoints() {
        return this.testCheckpointsProperty;
    }

    @Inject
    @NotNull
    public ObjectFactory getObjects() {
        throw (Throwable)new UnsupportedOperationException();
    }

    public final <T extends GradleTask> void init(@NotNull AndroidCompactedVariantData variantData, @NotNull Provider<SentryVariantData> sentryVariantData, @Nullable Action<T> configurationAction) throws TaskException {
        Intrinsics.checkNotNullParameter((Object)variantData, (String)"variantData");
        Intrinsics.checkNotNullParameter(sentryVariantData, (String)"sentryVariantData");
        this.variantDataProperty.set((Object)variantData);
        this.sentryVariantData = sentryVariantData;
        this.logger.debug("Task=" + this.getName() + " for variant=" + variantData.getName() + " is starting to get configured.");
        try {
            Action<T> action = configurationAction;
            if (action != null) {
                GradleTask gradleTask = this;
                if (gradleTask == null) {
                    throw new NullPointerException("null cannot be cast to non-null type T");
                }
                action.execute((Object)gradleTask);
            }
        }
        catch (Exception e) {
            ((SwazzlerTestCheckPoints)this.getTestCheckpoints().get()).exception(e);
            ((SentryLogger)this.sentryLoggerProperty.get()).sendException(e);
            ((BuildReporter)this.buildReporterProperty.get()).onException(e);
            throw (Throwable)new TaskException("An exception was thrown while initializing task: " + this.getName(), e);
        }
    }

    @TaskAction
    public final void run() {
        try {
            String msg = "Task=" + this.getName() + " for variant=" + ((AndroidCompactedVariantData)this.variantDataProperty.get()).getName() + " is starting execution.";
            SentryLogger sentryLogger = (SentryLogger)this.sentryLoggerProperty.get();
            Provider<SentryVariantData> provider2 = this.sentryVariantData;
            if (provider2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sentryVariantData");
            }
            sentryLogger.activateVariant((SentryVariantData)provider2.getOrNull());
            ((SentryLogger)this.sentryLoggerProperty.get()).addBreadcrumb(msg);
            this.logger.debug(msg);
            this.onRun();
            SwazzlerTestCheckPoints swazzlerTestCheckPoints = (SwazzlerTestCheckPoints)this.getTestCheckpoints().get();
            String string = this.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            swazzlerTestCheckPoints.executed(string);
            ((SentryLogger)this.sentryLoggerProperty.get()).addBreadcrumb("Task=" + this.getName() + " for variant=" + ((AndroidCompactedVariantData)this.variantDataProperty.get()).getName() + " finished execution.");
        }
        catch (Exception e) {
            ((SentryLogger)this.sentryLoggerProperty.get()).sendException(e);
            ((BuildReporter)this.buildReporterProperty.get()).onException(e);
            ((SwazzlerTestCheckPoints)this.getTestCheckpoints().get()).exception(e);
            throw (Throwable)e;
        }
    }

    @Internal
    @NotNull
    public final Property<AndroidCompactedVariantData> getVariantInfo() {
        return this.variantDataProperty;
    }

    public abstract void onRun();

    public GradleTask() {
        Property property = this.getObjects().property(DependencyInjectionProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"getObjects().property(De\u2026tionProvider::class.java)");
        this._dependency_injection_provider = property;
        Property property2 = this.getObjects().property(SentryLogger.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"getObjects().property(SentryLogger::class.java)");
        this.sentryLoggerProperty = property2;
        Property property3 = this.getObjects().property(BuildReporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"getObjects().property(BuildReporter::class.java)");
        this.buildReporterProperty = property3;
        Property property4 = this.getObjects().property(AndroidCompactedVariantData.class);
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"getObjects().property(An\u2026dVariantData::class.java)");
        this.variantDataProperty = property4;
        Property property5 = this.getObjects().property(SwazzlerTestCheckPoints.class);
        Intrinsics.checkNotNullExpressionValue((Object)property5, (String)"getObjects().property(Sw\u2026tCheckPoints::class.java)");
        this.testCheckpointsProperty = property5;
    }
}

