/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.config.VariantConfiguration;
import io.embrace.android.gradle.swazzler.config.unity.UnityConfig;
import io.embrace.android.gradle.swazzler.plugin.SwazzlerException;
import java.lang.reflect.Type;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB%\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ \u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/embrace/android/gradle/swazzler/config/VariantConfigurationDeserializer;", "Lcom/google/gson/JsonDeserializer;", "Lio/embrace/android/gradle/swazzler/config/VariantConfiguration;", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "variantName", "", "variantVersion", "(Lio/embrace/android/gradle/swazzler/Logger;Ljava/lang/String;Ljava/lang/String;)V", "getLogger", "()Lio/embrace/android/gradle/swazzler/Logger;", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "validateBoolean", "", "validateInteger", "", "validateSdkConfig", "", "jsonObject", "Lcom/google/gson/JsonObject;", "Companion", "embrace-bug-shake-gradle-plugin"})
public final class VariantConfigurationDeserializer
implements JsonDeserializer<VariantConfiguration> {
    @NotNull
    private final Logger<?> logger;
    private final String variantName;
    private final String variantVersion;
    private static final String JSON_APP_ID_KEY = "app_id";
    private static final String JSON_API_TOKEN_KEY = "api_token";
    private static final String JSON_NDK_ENABLED_KEY = "ndk_enabled";
    private static final String JSON_SDK_CONFIG_KEY = "sdk_config";
    private static final String JSON_UNITY_KEY = "unity";
    private static final String JSON_UNITY_SYMBOLS_ARCHIVE_NAME_KEY = "symbols_archive_name";
    private static final String JSON_ANR_KEY = "anr";
    private static final String JSON_CRASH_HANDLER_KEY = "crash_handler";
    private static final String JSON_NETWORKING_KEY = "networking";
    private static final String JSON_SESSION_KEY = "session";
    private static final String JSON_STARTUP_KEY = "startup_moment";
    private static final String JSON_TAPS_KEY = "taps";
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public VariantConfiguration deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) throws JsonParseException {
        boolean bl;
        Object object;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsonObject jsonObject = json.getAsJsonObject();
        String appId = null;
        String apiToken = null;
        Boolean ndkEnabled = null;
        String sdkConfig = null;
        UnityConfig unityConfig = null;
        try {
            if (jsonObject.has(JSON_APP_ID_KEY)) {
                JsonElement jsonElement = jsonObject.get(JSON_APP_ID_KEY);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject[JSON_APP_ID_KEY]");
                appId = jsonElement.getAsString();
            }
        }
        catch (Exception e) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "An error occurred when reading %s: %s";
            Object[] objectArray2 = new Object[]{JSON_APP_ID_KEY, e.getLocalizedMessage()};
            boolean bl2 = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            throw (Throwable)new SwazzlerException(string2);
        }
        try {
            if (jsonObject.has(JSON_API_TOKEN_KEY)) {
                JsonElement jsonElement = jsonObject.get(JSON_API_TOKEN_KEY);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject[JSON_API_TOKEN_KEY]");
                apiToken = jsonElement.getAsString();
            }
        }
        catch (Exception e) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "An error occurred when reading %s: %s";
            Object[] objectArray3 = new Object[]{JSON_API_TOKEN_KEY, e.getLocalizedMessage()};
            boolean bl3 = false;
            String string3 = String.format(string, Arrays.copyOf(objectArray3, objectArray3.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            throw (Throwable)new SwazzlerException(string3);
        }
        try {
            if (jsonObject.has(JSON_NDK_ENABLED_KEY)) {
                ndkEnabled = this.validateBoolean(jsonObject.get(JSON_NDK_ENABLED_KEY));
            }
        }
        catch (Exception e) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            objectArray = "The boolean field %s cannot be parsed. Please check the Embrace configuration file.";
            object = new Object[]{JSON_NDK_ENABLED_KEY};
            bl = false;
            String string = String.format((String)objectArray, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
            this.logger.error(string);
        }
        try {
            if (jsonObject.has(JSON_SDK_CONFIG_KEY)) {
                JsonElement jsonElement = jsonObject.get(JSON_SDK_CONFIG_KEY);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject[JSON_SDK_CONFIG_KEY]");
                if (jsonElement.isJsonNull()) {
                    StringCompanionObject e = StringCompanionObject.INSTANCE;
                    String string = "The boolean field %s cannot be parsed. Please check the Embrace configuration file.";
                    objectArray = new Object[]{JSON_SDK_CONFIG_KEY};
                    boolean bl4 = false;
                    String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
                    throw (Throwable)new SwazzlerException(string4);
                }
                JsonObject jsonObject2 = jsonObject.getAsJsonObject(JSON_SDK_CONFIG_KEY);
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"jsonObject.getAsJsonObject(JSON_SDK_CONFIG_KEY)");
                this.validateSdkConfig(jsonObject2);
                sdkConfig = jsonObject.getAsJsonObject(JSON_SDK_CONFIG_KEY).toString();
            }
        }
        catch (Exception e) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            objectArray = "An error occurred when reading %s: %s";
            object = new Object[]{JSON_SDK_CONFIG_KEY, e.getLocalizedMessage()};
            bl = false;
            String string = String.format((String)objectArray, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
            throw (Throwable)new SwazzlerException(string);
        }
        try {
            if (!jsonObject.has(JSON_UNITY_KEY)) return new VariantConfiguration(appId, apiToken, ndkEnabled, sdkConfig, unityConfig, this.variantName, this.variantVersion);
            UnityConfig.Builder unityConfigBuilder = UnityConfig.newBuilder();
            JsonObject jsonObject3 = jsonObject.getAsJsonObject(JSON_UNITY_KEY);
            if (jsonObject3.has(JSON_UNITY_SYMBOLS_ARCHIVE_NAME_KEY)) {
                JsonElement jsonElement = jsonObject3.get(JSON_UNITY_SYMBOLS_ARCHIVE_NAME_KEY);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"config[JSON_UNITY_SYMBOLS_ARCHIVE_NAME_KEY]");
                String archiveName = jsonElement.getAsString();
                if (archiveName == null) throw (Throwable)new SwazzlerException("Failed to read Unity config. The unity:symbols_archive_name cannot be an empty string. Please set a valid value or remove the key from your embrace-config.json file.");
                object = archiveName;
                bl = false;
                if (object.length() == 0) throw (Throwable)new SwazzlerException("Failed to read Unity config. The unity:symbols_archive_name cannot be an empty string. Please set a valid value or remove the key from your embrace-config.json file.");
                unityConfigBuilder.withSymbolsArchiveName(archiveName);
            }
            unityConfig = unityConfigBuilder.build();
            return new VariantConfiguration(appId, apiToken, ndkEnabled, sdkConfig, unityConfig, this.variantName, this.variantVersion);
        }
        catch (Exception e) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            objectArray = "An error occurred when reading %s config: %s";
            object = new Object[]{JSON_UNITY_KEY, e.getLocalizedMessage()};
            bl = false;
            String string = String.format((String)objectArray, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
            throw (Throwable)new SwazzlerException(string);
        }
    }

    private final void validateSdkConfig(JsonObject jsonObject) {
        boolean bl;
        Object[] objectArray;
        String string;
        StringCompanionObject stringCompanionObject;
        try {
            if (jsonObject.has(JSON_CRASH_HANDLER_KEY)) {
                JsonElement jsonElement = jsonObject.get(JSON_CRASH_HANDLER_KEY);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject.get(JSON_CRASH_HANDLER_KEY)");
                if (jsonElement.getAsJsonObject().has("enabled")) {
                    JsonElement jsonElement2 = jsonObject.get(JSON_CRASH_HANDLER_KEY);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"jsonObject.get(JSON_CRASH_HANDLER_KEY)");
                    this.validateBoolean(jsonElement2.getAsJsonObject().get("enabled"));
                }
            }
        }
        catch (Exception e) {
            stringCompanionObject = StringCompanionObject.INSTANCE;
            string = "An error occurred when reading %s: %s";
            objectArray = new Object[]{JSON_CRASH_HANDLER_KEY, e.getLocalizedMessage()};
            bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            this.logger.error(string2);
        }
        try {
            if (jsonObject.has(JSON_NETWORKING_KEY)) {
                JsonElement jsonElement = jsonObject.get(JSON_NETWORKING_KEY);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject.get(JSON_NETWORKING_KEY)");
                if (jsonElement.getAsJsonObject().has("capture_request_content_length")) {
                    JsonElement jsonElement3 = jsonObject.get(JSON_NETWORKING_KEY);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement3, (String)"jsonObject.get(JSON_NETWORKING_KEY)");
                    this.validateBoolean(jsonElement3.getAsJsonObject().get("capture_request_content_length"));
                }
            }
        }
        catch (Exception e) {
            stringCompanionObject = StringCompanionObject.INSTANCE;
            string = "An error occurred when reading %s: %s";
            objectArray = new Object[]{JSON_NETWORKING_KEY, e.getLocalizedMessage()};
            bl = false;
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            this.logger.error(string3);
        }
        try {
            if (jsonObject.has(JSON_SESSION_KEY)) {
                JsonElement jsonElement = jsonObject.get(JSON_SESSION_KEY);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject.get(JSON_SESSION_KEY)");
                if (jsonElement.getAsJsonObject().has("async_end")) {
                    JsonElement jsonElement4 = jsonObject.get(JSON_SESSION_KEY);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement4, (String)"jsonObject.get(JSON_SESSION_KEY)");
                    this.validateBoolean(jsonElement4.getAsJsonObject().get("async_end"));
                }
                JsonElement jsonElement5 = jsonObject.get(JSON_SESSION_KEY);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement5, (String)"jsonObject.get(JSON_SESSION_KEY)");
                if (jsonElement5.getAsJsonObject().has("max_session_seconds")) {
                    JsonElement jsonElement6 = jsonObject.get(JSON_SESSION_KEY);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement6, (String)"jsonObject.get(JSON_SESSION_KEY)");
                    JsonElement jsonElement7 = jsonElement6.getAsJsonObject().get("max_session_seconds");
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement7, (String)"jsonObject.get(JSON_SESS\u2026et(\"max_session_seconds\")");
                    this.validateInteger(jsonElement7);
                }
            }
        }
        catch (Exception e) {
            stringCompanionObject = StringCompanionObject.INSTANCE;
            string = "An error occurred when reading %s: %s";
            objectArray = new Object[]{JSON_SESSION_KEY, e.getLocalizedMessage()};
            bl = false;
            String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
            this.logger.error(string4);
        }
        try {
            if (jsonObject.has(JSON_STARTUP_KEY)) {
                JsonElement jsonElement = jsonObject.get(JSON_STARTUP_KEY);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject.get(JSON_STARTUP_KEY)");
                if (jsonElement.getAsJsonObject().has("automatically_end")) {
                    JsonElement jsonElement8 = jsonObject.get(JSON_STARTUP_KEY);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement8, (String)"jsonObject.get(JSON_STARTUP_KEY)");
                    this.validateBoolean(jsonElement8.getAsJsonObject().get("automatically_end"));
                }
                JsonElement jsonElement9 = jsonObject.get(JSON_STARTUP_KEY);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement9, (String)"jsonObject.get(JSON_STARTUP_KEY)");
                if (jsonElement9.getAsJsonObject().has("take_screenshot")) {
                    JsonElement jsonElement10 = jsonObject.get(JSON_STARTUP_KEY);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement10, (String)"jsonObject.get(JSON_STARTUP_KEY)");
                    this.validateBoolean(jsonElement10.getAsJsonObject().get("take_screenshot"));
                }
            }
        }
        catch (Exception e) {
            stringCompanionObject = StringCompanionObject.INSTANCE;
            string = "An error occurred when reading %s: %s";
            objectArray = new Object[]{JSON_STARTUP_KEY, e.getLocalizedMessage()};
            bl = false;
            String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
            this.logger.error(string5);
        }
        try {
            if (jsonObject.has(JSON_TAPS_KEY)) {
                JsonElement jsonElement = jsonObject.get(JSON_TAPS_KEY);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject.get(JSON_TAPS_KEY)");
                if (jsonElement.getAsJsonObject().has("capture_coordinates")) {
                    JsonElement jsonElement11 = jsonObject.get(JSON_TAPS_KEY);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement11, (String)"jsonObject.get(JSON_TAPS_KEY)");
                    this.validateBoolean(jsonElement11.getAsJsonObject().get("capture_coordinates"));
                }
            }
        }
        catch (Exception e) {
            stringCompanionObject = StringCompanionObject.INSTANCE;
            string = "An error occurred when reading %s: %s";
            objectArray = new Object[]{JSON_TAPS_KEY, e.getLocalizedMessage()};
            bl = false;
            String string6 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"java.lang.String.format(format, *args)");
            this.logger.error(string6);
        }
    }

    private final int validateInteger(JsonElement json) throws JsonParseException {
        int n;
        try {
            n = json.getAsInt();
        }
        catch (Exception e) {
            throw (Throwable)new JsonParseException("Invalid integer");
        }
        return n;
    }

    public final boolean validateBoolean(@Nullable JsonElement json) throws JsonParseException {
        JsonElement jsonElement = json;
        if (jsonElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.google.gson.JsonPrimitive");
        }
        if (((JsonPrimitive)jsonElement).isBoolean()) {
            return json.getAsBoolean();
        }
        if (((JsonPrimitive)json).isString()) {
            boolean bl;
            String jsonValue = json.getAsString();
            if (StringsKt.equals((String)jsonValue, (String)"true", (boolean)true)) {
                bl = true;
            } else if (StringsKt.equals((String)jsonValue, (String)"false", (boolean)true)) {
                bl = false;
            } else {
                throw (Throwable)new JsonParseException("Invalid boolean");
            }
            return bl;
        }
        int code = json.getAsInt();
        if (code == 0) {
            return false;
        }
        if (code != 1) {
            throw (Throwable)new JsonParseException("Invalid boolean");
        }
        return true;
    }

    @NotNull
    public final Logger<?> getLogger() {
        return this.logger;
    }

    public VariantConfigurationDeserializer(@NotNull Logger<?> logger, @Nullable String variantName, @Nullable String variantVersion) {
        Intrinsics.checkNotNullParameter(logger, (String)"logger");
        this.logger = logger;
        this.variantName = variantName;
        this.variantVersion = variantVersion;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/embrace/android/gradle/swazzler/config/VariantConfigurationDeserializer$Companion;", "", "()V", "JSON_ANR_KEY", "", "JSON_API_TOKEN_KEY", "JSON_APP_ID_KEY", "JSON_CRASH_HANDLER_KEY", "JSON_NDK_ENABLED_KEY", "JSON_NETWORKING_KEY", "JSON_SDK_CONFIG_KEY", "JSON_SESSION_KEY", "JSON_STARTUP_KEY", "JSON_TAPS_KEY", "JSON_UNITY_KEY", "JSON_UNITY_SYMBOLS_ARCHIVE_NAME_KEY", "embrace-bug-shake-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

