/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public final class HashUtils {
    private HashUtils() {
    }

    public static long generateCrc32Hash(String sourceString) {
        if (StringUtils.isBlank((CharSequence)sourceString)) {
            throw new IllegalArgumentException("Source string is null or empty.");
        }
        byte[] classNameBytes = sourceString.getBytes();
        CRC32 checksum = new CRC32();
        checksum.update(classNameBytes, 0, classNameBytes.length);
        return checksum.getValue();
    }

    public static String generateSha1FromFile(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        return DigestUtils.sha1Hex((InputStream)fis);
    }
}

