/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.reactnative;

import com.google.gson.JsonObject;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.di.DependencyInjectionProvider;
import io.embrace.android.gradle.swazzler.network.EmbraceEndpoint;
import io.embrace.android.gradle.swazzler.network.HttpCallResult;
import io.embrace.android.gradle.swazzler.network.UploadFileParams;
import io.embrace.android.gradle.swazzler.plugin.GradleUploadTask;
import io.embrace.android.gradle.swazzler.plugin.TaskException;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildReporter;
import io.embrace.android.gradle.swazzler.plugin.model.AndroidCompactedVariantData;
import io.embrace.android.gradle.swazzler.service.sentry.SentryLogger;
import io.sentry.SentryLevel;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0014H\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00020\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR2\u0010\f\u001a&\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00000\u0000 \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00020\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0013\u0010\u0011\u001a\u00020\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/reactnative/EmbraceRnSourcemapGeneratorTask;", "Lio/embrace/android/gradle/swazzler/plugin/GradleUploadTask;", "()V", "buildId", "Lorg/gradle/api/provider/Property;", "", "getBuildId", "()Lorg/gradle/api/provider/Property;", "bundleFileProperty", "Lorg/gradle/api/file/RegularFileProperty;", "getBundleFileProperty", "()Lorg/gradle/api/file/RegularFileProperty;", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "sourceMapInputFileProperty", "getSourceMapInputFileProperty", "sourceMapJsonFileProperty", "getSourceMapJsonFileProperty", "generateBundleZipFile", "Ljava/io/File;", "bundleFile", "sourceMapFile", "sourceMapJsonFile", "onRun", "", "readFile", "file", "uploadBundleFiles", "jsonFile", "Companion", "embrace-bug-shake-gradle-plugin"})
public class EmbraceRnSourcemapGeneratorTask
extends GradleUploadTask {
    private final Logger<EmbraceRnSourcemapGeneratorTask> logger = Logger.newLogger(EmbraceRnSourcemapGeneratorTask.class);
    @NotNull
    private final RegularFileProperty bundleFileProperty;
    @NotNull
    private final RegularFileProperty sourceMapInputFileProperty;
    @NotNull
    private final RegularFileProperty sourceMapJsonFileProperty;
    @NotNull
    private final Property<String> buildId;
    @NotNull
    public static final String NAME = "embraceRNSourcemapGeneratorFor";
    private static final String FILE_NAME_SOURCE_MAP_JSON = "sourcemap.json";
    private static final String KEY_NAME_BUNDLE = "bundle";
    private static final String KEY_NAME_SOURCE_MAP = "sourcemap";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Optional
    @InputFile
    @NotNull
    public final RegularFileProperty getBundleFileProperty() {
        return this.bundleFileProperty;
    }

    @Optional
    @InputFile
    @NotNull
    public final RegularFileProperty getSourceMapInputFileProperty() {
        return this.sourceMapInputFileProperty;
    }

    @OutputFile
    @NotNull
    public final RegularFileProperty getSourceMapJsonFileProperty() {
        return this.sourceMapJsonFileProperty;
    }

    @Input
    @NotNull
    public final Property<String> getBuildId() {
        return this.buildId;
    }

    @Override
    public void onRun() {
        if (((AndroidCompactedVariantData)this.getVariantInfo().get()).isBuildTypeDebuggable()) {
            String name = ((AndroidCompactedVariantData)this.getVariantInfo().get()).getName();
            this.logger.warn("The variant " + name + " is debuggable, skipping bundle upload");
            return;
        }
        this.logger.info("Starting React native artifacts upload task " + "{app-id=" + (String)this.getAppId().get() + ", api-token=" + (String)this.getApiToken().get() + ", build-id=" + (String)this.buildId.get() + "}.");
        if (this.bundleFileProperty.isPresent() && this.sourceMapInputFileProperty.isPresent()) {
            File bundleFile = (File)this.bundleFileProperty.getAsFile().get();
            File sourceMapFile = (File)this.sourceMapInputFileProperty.getAsFile().get();
            File sourceMapJsonFile = (File)this.sourceMapJsonFileProperty.getAsFile().get();
            File file = bundleFile;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"bundleFile");
            File file2 = sourceMapFile;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"sourceMapFile");
            File file3 = sourceMapJsonFile;
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"sourceMapJsonFile");
            this.uploadBundleFiles(this.generateBundleZipFile(file, file2, file3));
        } else {
            SentryLogger sentryLogger = (SentryLogger)this.getSentryLogger().get();
            Object object = this.getAppId().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"appId.get()");
            sentryLogger.sendEvent(SentryLevel.WARNING, "React native files were not uploaded.", (String)object, "0.7.2", ((AndroidCompactedVariantData)this.getVariantInfo().get()).getName());
            this.logger.warn("React native files were not uploaded.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readFile(File file) throws IOException {
        Closeable closeable = new FileInputStream(file);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileInputStream stream = (FileInputStream)closeable;
            boolean bl3 = false;
            FileChannel fc = stream.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            String string = Charset.defaultCharset().decode(bb).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Charset.defaultCharset().decode(bb).toString()");
            String string2 = string;
            return string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void uploadBundleFiles(File jsonFile) {
        block1: {
            HttpCallResult httpCallResult;
            HttpCallResult uploadResult;
            block2: {
                block0: {
                    this.logger.info("About to upload RN bundle files");
                    Object object = this.getAppId().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"appId.get()");
                    String string = (String)object;
                    Object object2 = this.getApiToken().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"apiToken.get()");
                    UploadFileParams uploadFileParams = new UploadFileParams(EmbraceEndpoint.SOURCE_MAP, string, (String)object2, jsonFile, FILE_NAME_SOURCE_MAP_JSON, (String)this.buildId.get());
                    httpCallResult = uploadResult = ((DependencyInjectionProvider)this.getDependencyInjectionProvider().get()).getNetworkService().uploadFile(uploadFileParams);
                    if (!(httpCallResult instanceof HttpCallResult.Success)) break block0;
                    this.logger.info("React Native sourcemap file was successfully uploaded. \n" + "Variant=" + ((AndroidCompactedVariantData)this.getVariantInfo().get()).getName() + " build_id=" + (String)this.buildId.get() + " \n");
                    break block1;
                }
                if (!(httpCallResult instanceof HttpCallResult.Failure)) break block2;
                this.logger.warn("Failed to upload React Native sourcemap file. \n" + "Variant=" + ((AndroidCompactedVariantData)this.getVariantInfo().get()).getName() + " build_id=" + (String)this.buildId.get() + ". \n" + "Status=" + ((HttpCallResult.Failure)uploadResult).getCode() + " Error=" + ((HttpCallResult.Failure)uploadResult).getErrorMessage() + " \n");
                break block1;
            }
            if (!(httpCallResult instanceof HttpCallResult.Error)) break block1;
            this.logger.warn("Failed to upload React Native sourcemap file. \n" + "Variant=" + ((AndroidCompactedVariantData)this.getVariantInfo().get()).getName() + " build_id=" + (String)this.buildId.get() + ". \n" + "Exception=" + ((HttpCallResult.Error)uploadResult).getException() + " \n");
            ((SentryLogger)this.getSentryLogger().get()).sendException(((HttpCallResult.Error)uploadResult).getException());
            ((BuildReporter)this.getBuildReporter().get()).onException(((HttpCallResult.Error)uploadResult).getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File generateBundleZipFile(File bundleFile, File sourceMapFile, File sourceMapJsonFile) throws TaskException {
        this.logger.debug("About to zip RN bundle file");
        JsonObject bundleGson = new JsonObject();
        this.logger.debug("RN bundle path=" + sourceMapJsonFile);
        sourceMapJsonFile.getParentFile().mkdirs();
        try {
            Closeable closeable = new FileOutputStream(sourceMapJsonFile);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileOutputStream stream = (FileOutputStream)closeable;
                boolean bl3 = false;
                this.logger.debug("Generating bundle zip file with bundleFile: " + bundleFile + " and sourceMapFile: " + sourceMapFile);
                bundleGson.addProperty(KEY_NAME_BUNDLE, this.readFile(bundleFile));
                bundleGson.addProperty(KEY_NAME_SOURCE_MAP, this.readFile(sourceMapFile));
                ByteArrayOutputStream os = new ByteArrayOutputStream(bundleGson.toString().length());
                GZIPOutputStream gos = new GZIPOutputStream(os);
                String string = bundleGson.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bundleGson.toString()");
                String string2 = string;
                Charset charset = Charsets.UTF_8;
                boolean bl4 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string3.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                gos.write(byArray);
                gos.close();
                byte[] compressed = os.toByteArray();
                os.close();
                this.logger.debug("RN bundle file successfully compressed");
                stream.write(compressed);
                this.logger.debug("RN bundle file successfully written");
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.logger.debug("Failed generating bundle zip file with bundleFile: " + bundleFile + " and sourceMapFile: " + sourceMapFile);
            throw (Throwable)new TaskException("Failed generating bundle zip file.", e);
        }
        return sourceMapJsonFile;
    }

    public EmbraceRnSourcemapGeneratorTask() {
        RegularFileProperty regularFileProperty = this.getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"getObjects().fileProperty()");
        this.bundleFileProperty = regularFileProperty;
        RegularFileProperty regularFileProperty2 = this.getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty2, (String)"getObjects().fileProperty()");
        this.sourceMapInputFileProperty = regularFileProperty2;
        RegularFileProperty regularFileProperty3 = this.getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty3, (String)"getObjects().fileProperty()");
        this.sourceMapJsonFileProperty = regularFileProperty3;
        Property property = this.getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"getObjects().property(String::class.java)");
        this.buildId = property;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/reactnative/EmbraceRnSourcemapGeneratorTask$Companion;", "", "()V", "FILE_NAME_SOURCE_MAP_JSON", "", "KEY_NAME_BUNDLE", "KEY_NAME_SOURCE_MAP", "NAME", "embrace-bug-shake-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

