/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.buildreporter;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildCheckpoints;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.TaskMetadata;
import java.io.Closeable;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0003<=>B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0003H\u0007J\u001f\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\u0010\u0015J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J*\u0010\u0018\u001a&\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00130\u0013 \u001a*\u0012\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00130\u0013\u0018\u00010\u001b0\u0019J \u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0007J\u000f\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007\u00a2\u0006\u0002\u0010\u001fJ\n\u0010 \u001a\u0004\u0018\u00010\u0013H\u0007J\u001a\u0010!\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0007J\u001f\u0010\"\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\u0010#J\u001f\u0010$\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\u0010#J*\u0010%\u001a&\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00130\u0013 \u001a*\u0012\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00130\u0013\u0018\u00010\u001b0\u0019J\u001f\u0010&\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\u0010\u0015J\u001f\u0010'\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\u0010\u0015J\u001f\u0010(\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\u0010\u0015J\u001f\u0010)\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001eJ\u0012\u0010-\u001a\u00020\u00032\n\u0010.\u001a\u00060/j\u0002`0J\u000e\u00101\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001eJ\u000e\u00102\u001a\u00020+2\u0006\u00103\u001a\u00020\u0013J\u000e\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u000206J\u0006\u00107\u001a\u00020+J\u000e\u00108\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u0013J\b\u0010:\u001a\u00020+H\u0002J\u0006\u0010;\u001a\u00020\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildCheckpoints;", "", "checkpointsDisabled", "", "isTestingEnabled", "writer", "Ljava/io/FileWriter;", "(ZZLjava/io/FileWriter;)V", "checkpoints", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildCheckpoints$Checkpoints;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "gson$delegate", "Lkotlin/Lazy;", "didBuildFinishedSuccessfully", "didTaskFinishedSuccessfully", "variantName", "", "taskName", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Boolean;", "findTaskCheckpoint", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildCheckpoints$TaskCheckpoint;", "getExceptions", "", "kotlin.jvm.PlatformType", "", "getExecutionReasons", "getFirstTaskStartedExecutionTime", "", "()Ljava/lang/Long;", "getMetadataRequestId", "getSkippedMessage", "getTaskEndTime", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Long;", "getTaskStarTime", "getWarnings", "isTaskConfigured", "isTaskExecuted", "isTaskFromCache", "isTaskRegistered", "onBuildFinished", "", "timestamp", "onException", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onFirstTaskStartedExecution", "onMetadataRequestId", "id", "onTaskEvent", "taskMetadata", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/TaskMetadata;", "onTaskFailed", "onWarning", "warning", "safelyWriteToDisk", "toJson", "Checkpoints", "TaskCheckpoint", "VariantCheckpoint", "embrace-bug-shake-gradle-plugin"})
public final class BuildCheckpoints {
    private Checkpoints checkpoints;
    private final Lazy gson$delegate;
    private final boolean checkpointsDisabled;
    private final boolean isTestingEnabled;
    private final FileWriter writer;

    private final Gson getGson() {
        Lazy lazy = this.gson$delegate;
        BuildCheckpoints buildCheckpoints2 = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Gson)lazy.getValue();
    }

    public final boolean onTaskEvent(@NotNull TaskMetadata taskMetadata) {
        Intrinsics.checkNotNullParameter((Object)taskMetadata, (String)"taskMetadata");
        if (this.checkpointsDisabled) {
            return false;
        }
        this.checkpoints.addTaskEvent(taskMetadata);
        this.safelyWriteToDisk();
        return true;
    }

    public final boolean onException(@NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        if (this.checkpointsDisabled) {
            return false;
        }
        this.checkpoints.addException(exception);
        this.safelyWriteToDisk();
        return true;
    }

    public final void onTaskFailed() {
        this.checkpoints.setBuildFailed(true);
    }

    public final void onFirstTaskStartedExecution(long timestamp) {
        this.checkpoints.setBuildStartedTime(timestamp);
    }

    public final void onMetadataRequestId(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.checkpoints.setMetadataRequestId(id);
    }

    public final void onBuildFinished(long timestamp) {
        this.checkpoints.setBuildEndTime(timestamp);
    }

    public final boolean onWarning(@NotNull String warning) {
        Intrinsics.checkNotNullParameter((Object)warning, (String)"warning");
        if (this.checkpointsDisabled) {
            return false;
        }
        this.checkpoints.addWarning(warning);
        this.safelyWriteToDisk();
        return true;
    }

    @NotNull
    public final String toJson() {
        String string = this.getGson().toJson((Object)this.checkpoints);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(checkpoints)");
        return string;
    }

    private final TaskCheckpoint findTaskCheckpoint(String variantName, String taskName) {
        VariantCheckpoint variantCheckpoint = this.checkpoints.getVariantCheckpoint(variantName);
        return variantCheckpoint != null ? variantCheckpoint.getTaskCheckpoint(taskName) : null;
    }

    @VisibleForTesting
    @Nullable
    public final Boolean isTaskRegistered(@NotNull String variantName, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        TaskCheckpoint taskCheckpoint = this.findTaskCheckpoint(variantName, taskName);
        return taskCheckpoint != null ? Boolean.valueOf(taskCheckpoint.getRegistered()) : null;
    }

    @VisibleForTesting
    @Nullable
    public final Boolean isTaskConfigured(@NotNull String variantName, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        TaskCheckpoint taskCheckpoint = this.findTaskCheckpoint(variantName, taskName);
        return taskCheckpoint != null ? Boolean.valueOf(taskCheckpoint.getConfigured()) : null;
    }

    @VisibleForTesting
    @Nullable
    public final Boolean isTaskExecuted(@NotNull String variantName, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        TaskCheckpoint taskCheckpoint = this.findTaskCheckpoint(variantName, taskName);
        return taskCheckpoint != null ? Boolean.valueOf(taskCheckpoint.getExecuted()) : null;
    }

    @VisibleForTesting
    @Nullable
    public final Long getTaskStarTime(@NotNull String variantName, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        TaskCheckpoint taskCheckpoint = this.findTaskCheckpoint(variantName, taskName);
        return taskCheckpoint != null ? Long.valueOf(taskCheckpoint.getStartTime()) : null;
    }

    @VisibleForTesting
    @Nullable
    public final Long getTaskEndTime(@NotNull String variantName, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        TaskCheckpoint taskCheckpoint = this.findTaskCheckpoint(variantName, taskName);
        return taskCheckpoint != null ? Long.valueOf(taskCheckpoint.getEndTime()) : null;
    }

    @VisibleForTesting
    @Nullable
    public final Boolean didTaskFinishedSuccessfully(@NotNull String variantName, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        TaskCheckpoint taskCheckpoint = this.findTaskCheckpoint(variantName, taskName);
        return taskCheckpoint != null ? Boolean.valueOf(taskCheckpoint.getFinishedSuccessfully()) : null;
    }

    @VisibleForTesting
    @Nullable
    public final String getSkippedMessage(@NotNull String variantName, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        TaskCheckpoint taskCheckpoint = this.findTaskCheckpoint(variantName, taskName);
        return taskCheckpoint != null ? taskCheckpoint.getSkippedMessage() : null;
    }

    @VisibleForTesting
    @Nullable
    public final List<String> getExecutionReasons(@NotNull String variantName, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        TaskCheckpoint taskCheckpoint = this.findTaskCheckpoint(variantName, taskName);
        return taskCheckpoint != null ? taskCheckpoint.getExecutionReasons() : null;
    }

    @VisibleForTesting
    @Nullable
    public final Boolean isTaskFromCache(@NotNull String variantName, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        TaskCheckpoint taskCheckpoint = this.findTaskCheckpoint(variantName, taskName);
        return taskCheckpoint != null ? taskCheckpoint.isFromCache() : null;
    }

    @VisibleForTesting
    public final boolean didBuildFinishedSuccessfully() {
        return !this.checkpoints.getBuildFailed();
    }

    @VisibleForTesting
    @Nullable
    public final Long getFirstTaskStartedExecutionTime() {
        return this.checkpoints.getBuildStartedTime();
    }

    @VisibleForTesting
    @Nullable
    public final String getMetadataRequestId() {
        return this.checkpoints.getMetadataRequestId();
    }

    public final List<String> getExceptions() {
        return Collections.unmodifiableList(this.checkpoints.getExceptions());
    }

    public final List<String> getWarnings() {
        return Collections.unmodifiableList(this.checkpoints.getWarnings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void safelyWriteToDisk() {
        block8: {
            if (!this.isTestingEnabled) {
                return;
            }
            try {
                FileWriter fileWriter = this.writer;
                if (fileWriter == null) break block8;
                Closeable closeable = fileWriter;
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    FileWriter it = (FileWriter)closeable;
                    boolean bl3 = false;
                    it.write(this.toJson());
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                System.err.println("Exception for file: checkpoints.txt");
                e.printStackTrace();
            }
        }
    }

    public BuildCheckpoints(boolean checkpointsDisabled, boolean isTestingEnabled, @Nullable FileWriter writer) {
        this.checkpointsDisabled = checkpointsDisabled;
        this.isTestingEnabled = isTestingEnabled;
        this.writer = writer;
        this.checkpoints = new Checkpoints(null, null, null, false, null, null, null, 127, null);
        this.gson$delegate = LazyKt.lazy((Function0)gson.2.INSTANCE);
    }

    public /* synthetic */ BuildCheckpoints(boolean bl, boolean bl2, FileWriter fileWriter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            fileWriter = null;
        }
        this(bl, bl2, fileWriter);
    }

    public BuildCheckpoints() {
        this(false, false, null, 7, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001Bc\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020\u0006J\u000f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\u000f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\t\u0010.\u001a\u00020\tH\u00c6\u0003J\u0010\u0010/\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u0010\u00100\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u000b\u00101\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003Jl\u00102\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001\u00a2\u0006\u0002\u00103J\u0013\u00104\u001a\u00020\t2\b\u00105\u001a\u0004\u0018\u000106H\u00d6\u0003J\u0012\u00107\u001a\u0004\u0018\u00010\u00042\u0006\u00108\u001a\u00020\u0006H\u0007J\u000e\u00109\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u0006J\t\u0010:\u001a\u00020;H\u00d6\u0001J\t\u0010<\u001a\u00020\u0006H\u00d6\u0001R\"\u0010\f\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\n\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u0018\u0010\u0010\"\u0004\b\u0019\u0010\u0012R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR \u0010\r\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001bR\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001b\u00a8\u0006="}, d2={"Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildCheckpoints$Checkpoints;", "Ljava/io/Serializable;", "variantsCheckpoints", "", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildCheckpoints$VariantCheckpoint;", "exceptions", "", "warnings", "buildFailed", "", "buildStartedTime", "", "buildEndTime", "metadataRequestId", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;ZLjava/lang/Long;Ljava/lang/Long;Ljava/lang/String;)V", "getBuildEndTime", "()Ljava/lang/Long;", "setBuildEndTime", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "getBuildFailed", "()Z", "setBuildFailed", "(Z)V", "getBuildStartedTime", "setBuildStartedTime", "getExceptions", "()Ljava/util/List;", "getMetadataRequestId", "()Ljava/lang/String;", "setMetadataRequestId", "(Ljava/lang/String;)V", "getVariantsCheckpoints", "getWarnings", "addException", "", "exception", "Ljava/lang/Exception;", "addTaskEvent", "taskMetadata", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/TaskMetadata;", "addWarning", "warningMessage", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;ZLjava/lang/Long;Ljava/lang/Long;Ljava/lang/String;)Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildCheckpoints$Checkpoints;", "equals", "other", "", "getVariantCheckpoint", "variantName", "getVariantCheckpointOrCreate", "hashCode", "", "toString", "embrace-bug-shake-gradle-plugin"})
    private static final class Checkpoints
    implements Serializable {
        @SerializedName(value="v")
        @NotNull
        private final List<VariantCheckpoint> variantsCheckpoints;
        @SerializedName(value="e")
        @NotNull
        private final List<String> exceptions;
        @SerializedName(value="w")
        @NotNull
        private final List<String> warnings;
        @SerializedName(value="bf")
        private boolean buildFailed;
        @SerializedName(value="bst")
        @Nullable
        private Long buildStartedTime;
        @SerializedName(value="bet")
        @Nullable
        private Long buildEndTime;
        @SerializedName(value="id")
        @Nullable
        private String metadataRequestId;

        public final void addTaskEvent(@NotNull TaskMetadata taskMetadata) {
            Intrinsics.checkNotNullParameter((Object)taskMetadata, (String)"taskMetadata");
            TaskCheckpoint taskCheckpoint = this.getVariantCheckpointOrCreate(taskMetadata.getVariant()).getTaskCheckpoint(taskMetadata.getTaskName());
            boolean bl = false;
            boolean bl2 = false;
            TaskCheckpoint $this$with = taskCheckpoint;
            boolean bl3 = false;
            $this$with.setStartTime(taskMetadata.getStartTime());
            $this$with.setEndTime(taskMetadata.getEndTime());
            $this$with.setExecuted(taskMetadata.getMetadataResult().getDidExecute());
            $this$with.setFinishedSuccessfully(taskMetadata.getMetadataResult().getFinishedSuccessfully());
            $this$with.setFromCache(taskMetadata.getMetadataResult().isFromCache());
            $this$with.setExecutionReasons(taskMetadata.getMetadataResult().getExecutionReasons());
            $this$with.setSkippedMessage(taskMetadata.getMetadataResult().getSkippedMessage());
            $this$with.setRegistered(true);
            $this$with.setConfigured(true);
        }

        public final void addException(@NotNull Exception exception) {
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            this.exceptions.add(exception.toString());
        }

        public final void addWarning(@NotNull String warningMessage) {
            Intrinsics.checkNotNullParameter((Object)warningMessage, (String)"warningMessage");
            this.warnings.add(warningMessage);
        }

        @NotNull
        public final VariantCheckpoint getVariantCheckpointOrCreate(@NotNull String variantName) {
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            VariantCheckpoint variantCheckpoint = this.getVariantCheckpoint(variantName);
            if (variantCheckpoint == null) {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                VariantCheckpoint variantCheckpoint2 = new VariantCheckpoint(variantName, null, 2, null);
                this.variantsCheckpoints.add(variantCheckpoint2);
                variantCheckpoint = variantCheckpoint2;
            }
            return variantCheckpoint;
        }

        @VisibleForTesting
        @Nullable
        public final VariantCheckpoint getVariantCheckpoint(@NotNull String variantName) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
                Iterable iterable = this.variantsCheckpoints;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    VariantCheckpoint it = (VariantCheckpoint)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getVariantName(), (Object)variantName)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @NotNull
        public final List<VariantCheckpoint> getVariantsCheckpoints() {
            return this.variantsCheckpoints;
        }

        @NotNull
        public final List<String> getExceptions() {
            return this.exceptions;
        }

        @NotNull
        public final List<String> getWarnings() {
            return this.warnings;
        }

        public final boolean getBuildFailed() {
            return this.buildFailed;
        }

        public final void setBuildFailed(boolean bl) {
            this.buildFailed = bl;
        }

        @Nullable
        public final Long getBuildStartedTime() {
            return this.buildStartedTime;
        }

        public final void setBuildStartedTime(@Nullable Long l) {
            this.buildStartedTime = l;
        }

        @Nullable
        public final Long getBuildEndTime() {
            return this.buildEndTime;
        }

        public final void setBuildEndTime(@Nullable Long l) {
            this.buildEndTime = l;
        }

        @Nullable
        public final String getMetadataRequestId() {
            return this.metadataRequestId;
        }

        public final void setMetadataRequestId(@Nullable String string) {
            this.metadataRequestId = string;
        }

        public Checkpoints(@NotNull List<VariantCheckpoint> variantsCheckpoints, @NotNull List<String> exceptions, @NotNull List<String> warnings, boolean buildFailed, @Nullable Long buildStartedTime, @Nullable Long buildEndTime, @Nullable String metadataRequestId) {
            Intrinsics.checkNotNullParameter(variantsCheckpoints, (String)"variantsCheckpoints");
            Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
            Intrinsics.checkNotNullParameter(warnings, (String)"warnings");
            this.variantsCheckpoints = variantsCheckpoints;
            this.exceptions = exceptions;
            this.warnings = warnings;
            this.buildFailed = buildFailed;
            this.buildStartedTime = buildStartedTime;
            this.buildEndTime = buildEndTime;
            this.metadataRequestId = metadataRequestId;
        }

        public /* synthetic */ Checkpoints(List list, List list2, List list3, boolean bl, Long l, Long l2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            boolean bl2;
            if ((n & 1) != 0) {
                bl2 = false;
                list = new ArrayList();
            }
            if ((n & 2) != 0) {
                bl2 = false;
                list2 = new ArrayList();
            }
            if ((n & 4) != 0) {
                bl2 = false;
                list3 = new ArrayList();
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                l = null;
            }
            if ((n & 0x20) != 0) {
                l2 = null;
            }
            if ((n & 0x40) != 0) {
                string = null;
            }
            this(list, list2, list3, bl, l, l2, string);
        }

        public Checkpoints() {
            this(null, null, null, false, null, null, null, 127, null);
        }

        @NotNull
        public final List<VariantCheckpoint> component1() {
            return this.variantsCheckpoints;
        }

        @NotNull
        public final List<String> component2() {
            return this.exceptions;
        }

        @NotNull
        public final List<String> component3() {
            return this.warnings;
        }

        public final boolean component4() {
            return this.buildFailed;
        }

        @Nullable
        public final Long component5() {
            return this.buildStartedTime;
        }

        @Nullable
        public final Long component6() {
            return this.buildEndTime;
        }

        @Nullable
        public final String component7() {
            return this.metadataRequestId;
        }

        @NotNull
        public final Checkpoints copy(@NotNull List<VariantCheckpoint> variantsCheckpoints, @NotNull List<String> exceptions, @NotNull List<String> warnings, boolean buildFailed, @Nullable Long buildStartedTime, @Nullable Long buildEndTime, @Nullable String metadataRequestId) {
            Intrinsics.checkNotNullParameter(variantsCheckpoints, (String)"variantsCheckpoints");
            Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
            Intrinsics.checkNotNullParameter(warnings, (String)"warnings");
            return new Checkpoints(variantsCheckpoints, exceptions, warnings, buildFailed, buildStartedTime, buildEndTime, metadataRequestId);
        }

        public static /* synthetic */ Checkpoints copy$default(Checkpoints checkpoints, List list, List list2, List list3, boolean bl, Long l, Long l2, String string, int n, Object object) {
            if ((n & 1) != 0) {
                list = checkpoints.variantsCheckpoints;
            }
            if ((n & 2) != 0) {
                list2 = checkpoints.exceptions;
            }
            if ((n & 4) != 0) {
                list3 = checkpoints.warnings;
            }
            if ((n & 8) != 0) {
                bl = checkpoints.buildFailed;
            }
            if ((n & 0x10) != 0) {
                l = checkpoints.buildStartedTime;
            }
            if ((n & 0x20) != 0) {
                l2 = checkpoints.buildEndTime;
            }
            if ((n & 0x40) != 0) {
                string = checkpoints.metadataRequestId;
            }
            return checkpoints.copy(list, list2, list3, bl, l, l2, string);
        }

        @NotNull
        public String toString() {
            return "Checkpoints(variantsCheckpoints=" + this.variantsCheckpoints + ", exceptions=" + this.exceptions + ", warnings=" + this.warnings + ", buildFailed=" + this.buildFailed + ", buildStartedTime=" + this.buildStartedTime + ", buildEndTime=" + this.buildEndTime + ", metadataRequestId=" + this.metadataRequestId + ")";
        }

        public int hashCode() {
            List<VariantCheckpoint> list = this.variantsCheckpoints;
            List<String> list2 = this.exceptions;
            List<String> list3 = this.warnings;
            int n = (((list != null ? ((Object)list).hashCode() : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0)) * 31;
            int n2 = this.buildFailed ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            Long l = this.buildStartedTime;
            Long l2 = this.buildEndTime;
            String string = this.metadataRequestId;
            return (((n + n2) * 31 + (l != null ? ((Object)l).hashCode() : 0)) * 31 + (l2 != null ? ((Object)l2).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Checkpoints)) break block3;
                    Checkpoints checkpoints = (Checkpoints)object;
                    if (!Intrinsics.areEqual(this.variantsCheckpoints, checkpoints.variantsCheckpoints) || !Intrinsics.areEqual(this.exceptions, checkpoints.exceptions) || !Intrinsics.areEqual(this.warnings, checkpoints.warnings) || this.buildFailed != checkpoints.buildFailed || !Intrinsics.areEqual((Object)this.buildStartedTime, (Object)checkpoints.buildStartedTime) || !Intrinsics.areEqual((Object)this.buildEndTime, (Object)checkpoints.buildEndTime) || !Intrinsics.areEqual((Object)this.metadataRequestId, (Object)checkpoints.metadataRequestId)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildCheckpoints$VariantCheckpoint;", "Ljava/io/Serializable;", "variantName", "", "embraceTasks", "", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildCheckpoints$TaskCheckpoint;", "(Ljava/lang/String;Ljava/util/Set;)V", "getEmbraceTasks", "()Ljava/util/Set;", "getVariantName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "getTaskCheckpoint", "taskName", "hashCode", "", "toString", "embrace-bug-shake-gradle-plugin"})
    private static final class VariantCheckpoint
    implements Serializable {
        @SerializedName(value="vn")
        @NotNull
        private final String variantName;
        @SerializedName(value="t")
        @NotNull
        private final Set<TaskCheckpoint> embraceTasks;

        @NotNull
        public final TaskCheckpoint getTaskCheckpoint(@NotNull String taskName) {
            TaskCheckpoint taskCheckpoint;
            Object v0;
            boolean bl;
            block2: {
                Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
                Iterable iterable = this.embraceTasks;
                bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    TaskCheckpoint it = (TaskCheckpoint)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getTaskName(), (Object)taskName)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            if ((taskCheckpoint = (TaskCheckpoint)v0) == null) {
                boolean bl4 = false;
                bl = false;
                boolean bl5 = false;
                TaskCheckpoint taskCheckpoint2 = new TaskCheckpoint(taskName, 0L, 0L, false, false, false, false, null, null, null, 1022, null);
                this.embraceTasks.add(taskCheckpoint2);
                taskCheckpoint = taskCheckpoint2;
            }
            return taskCheckpoint;
        }

        @NotNull
        public final String getVariantName() {
            return this.variantName;
        }

        @NotNull
        public final Set<TaskCheckpoint> getEmbraceTasks() {
            return this.embraceTasks;
        }

        public VariantCheckpoint(@NotNull String variantName, @NotNull Set<TaskCheckpoint> embraceTasks) {
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            Intrinsics.checkNotNullParameter(embraceTasks, (String)"embraceTasks");
            this.variantName = variantName;
            this.embraceTasks = embraceTasks;
        }

        public /* synthetic */ VariantCheckpoint(String string, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                boolean bl = false;
                set = new LinkedHashSet();
            }
            this(string, set);
        }

        @NotNull
        public final String component1() {
            return this.variantName;
        }

        @NotNull
        public final Set<TaskCheckpoint> component2() {
            return this.embraceTasks;
        }

        @NotNull
        public final VariantCheckpoint copy(@NotNull String variantName, @NotNull Set<TaskCheckpoint> embraceTasks) {
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            Intrinsics.checkNotNullParameter(embraceTasks, (String)"embraceTasks");
            return new VariantCheckpoint(variantName, embraceTasks);
        }

        public static /* synthetic */ VariantCheckpoint copy$default(VariantCheckpoint variantCheckpoint, String string, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                string = variantCheckpoint.variantName;
            }
            if ((n & 2) != 0) {
                set = variantCheckpoint.embraceTasks;
            }
            return variantCheckpoint.copy(string, set);
        }

        @NotNull
        public String toString() {
            return "VariantCheckpoint(variantName=" + this.variantName + ", embraceTasks=" + this.embraceTasks + ")";
        }

        public int hashCode() {
            String string = this.variantName;
            Set<TaskCheckpoint> set = this.embraceTasks;
            return (string != null ? string.hashCode() : 0) * 31 + (set != null ? ((Object)set).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof VariantCheckpoint)) break block3;
                    VariantCheckpoint variantCheckpoint = (VariantCheckpoint)object;
                    if (!Intrinsics.areEqual((Object)this.variantName, (Object)variantCheckpoint.variantName) || !Intrinsics.areEqual(this.embraceTasks, variantCheckpoint.embraceTasks)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b-\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001Bs\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0010J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010/\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010!J\t\u00100\u001a\u00020\u0005H\u00c6\u0003J\t\u00101\u001a\u00020\u0005H\u00c6\u0003J\t\u00102\u001a\u00020\bH\u00c6\u0003J\t\u00103\u001a\u00020\bH\u00c6\u0003J\t\u00104\u001a\u00020\bH\u00c6\u0003J\t\u00105\u001a\u00020\bH\u00c6\u0003J\u000b\u00106\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u00107\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000eH\u00c6\u0003J~\u00108\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0002\u00109J\u0013\u0010:\u001a\u00020\b2\b\u0010;\u001a\u0004\u0018\u00010<H\u00d6\u0003J\t\u0010=\u001a\u00020>H\u00d6\u0001J\t\u0010?\u001a\u00020\u0003H\u00d6\u0001R\u001e\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001e\u0010\n\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R&\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001e\u0010\u000b\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0012\"\u0004\b \u0010\u0014R\"\u0010\u000f\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010$\u001a\u0004\b\u000f\u0010!\"\u0004\b\"\u0010#R\u001e\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0012\"\u0004\b&\u0010\u0014R \u0010\f\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0016\"\u0004\b,\u0010\u0018R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010(\u00a8\u0006@"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildCheckpoints$TaskCheckpoint;", "Ljava/io/Serializable;", "taskName", "", "startTime", "", "endTime", "registered", "", "configured", "executed", "finishedSuccessfully", "skippedMessage", "executionReasons", "", "isFromCache", "(Ljava/lang/String;JJZZZZLjava/lang/String;Ljava/util/List;Ljava/lang/Boolean;)V", "getConfigured", "()Z", "setConfigured", "(Z)V", "getEndTime", "()J", "setEndTime", "(J)V", "getExecuted", "setExecuted", "getExecutionReasons", "()Ljava/util/List;", "setExecutionReasons", "(Ljava/util/List;)V", "getFinishedSuccessfully", "setFinishedSuccessfully", "()Ljava/lang/Boolean;", "setFromCache", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "getRegistered", "setRegistered", "getSkippedMessage", "()Ljava/lang/String;", "setSkippedMessage", "(Ljava/lang/String;)V", "getStartTime", "setStartTime", "getTaskName", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;JJZZZZLjava/lang/String;Ljava/util/List;Ljava/lang/Boolean;)Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildCheckpoints$TaskCheckpoint;", "equals", "other", "", "hashCode", "", "toString", "embrace-bug-shake-gradle-plugin"})
    private static final class TaskCheckpoint
    implements Serializable {
        @SerializedName(value="tn")
        @NotNull
        private final String taskName;
        @SerializedName(value="st")
        private long startTime;
        @SerializedName(value="et")
        private long endTime;
        @SerializedName(value="re")
        private boolean registered;
        @SerializedName(value="co")
        private boolean configured;
        @SerializedName(value="ex")
        private boolean executed;
        @SerializedName(value="fs")
        private boolean finishedSuccessfully;
        @SerializedName(value="sm")
        @Nullable
        private String skippedMessage;
        @SerializedName(value="er")
        @Nullable
        private List<String> executionReasons;
        @SerializedName(value="fc")
        @Nullable
        private Boolean isFromCache;

        @NotNull
        public final String getTaskName() {
            return this.taskName;
        }

        public final long getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(long l) {
            this.startTime = l;
        }

        public final long getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(long l) {
            this.endTime = l;
        }

        public final boolean getRegistered() {
            return this.registered;
        }

        public final void setRegistered(boolean bl) {
            this.registered = bl;
        }

        public final boolean getConfigured() {
            return this.configured;
        }

        public final void setConfigured(boolean bl) {
            this.configured = bl;
        }

        public final boolean getExecuted() {
            return this.executed;
        }

        public final void setExecuted(boolean bl) {
            this.executed = bl;
        }

        public final boolean getFinishedSuccessfully() {
            return this.finishedSuccessfully;
        }

        public final void setFinishedSuccessfully(boolean bl) {
            this.finishedSuccessfully = bl;
        }

        @Nullable
        public final String getSkippedMessage() {
            return this.skippedMessage;
        }

        public final void setSkippedMessage(@Nullable String string) {
            this.skippedMessage = string;
        }

        @Nullable
        public final List<String> getExecutionReasons() {
            return this.executionReasons;
        }

        public final void setExecutionReasons(@Nullable List<String> list) {
            this.executionReasons = list;
        }

        @Nullable
        public final Boolean isFromCache() {
            return this.isFromCache;
        }

        public final void setFromCache(@Nullable Boolean bl) {
            this.isFromCache = bl;
        }

        public TaskCheckpoint(@NotNull String taskName, long startTime, long endTime, boolean registered, boolean configured, boolean executed, boolean finishedSuccessfully, @Nullable String skippedMessage, @Nullable List<String> executionReasons, @Nullable Boolean isFromCache) {
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            this.taskName = taskName;
            this.startTime = startTime;
            this.endTime = endTime;
            this.registered = registered;
            this.configured = configured;
            this.executed = executed;
            this.finishedSuccessfully = finishedSuccessfully;
            this.skippedMessage = skippedMessage;
            this.executionReasons = executionReasons;
            this.isFromCache = isFromCache;
        }

        public /* synthetic */ TaskCheckpoint(String string, long l, long l2, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string2, List list, Boolean bl5, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                l = 0L;
            }
            if ((n & 4) != 0) {
                l2 = 0L;
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                bl2 = false;
            }
            if ((n & 0x20) != 0) {
                bl3 = false;
            }
            if ((n & 0x40) != 0) {
                bl4 = false;
            }
            if ((n & 0x80) != 0) {
                string2 = null;
            }
            if ((n & 0x100) != 0) {
                list = null;
            }
            if ((n & 0x200) != 0) {
                bl5 = null;
            }
            this(string, l, l2, bl, bl2, bl3, bl4, string2, list, bl5);
        }

        @NotNull
        public final String component1() {
            return this.taskName;
        }

        public final long component2() {
            return this.startTime;
        }

        public final long component3() {
            return this.endTime;
        }

        public final boolean component4() {
            return this.registered;
        }

        public final boolean component5() {
            return this.configured;
        }

        public final boolean component6() {
            return this.executed;
        }

        public final boolean component7() {
            return this.finishedSuccessfully;
        }

        @Nullable
        public final String component8() {
            return this.skippedMessage;
        }

        @Nullable
        public final List<String> component9() {
            return this.executionReasons;
        }

        @Nullable
        public final Boolean component10() {
            return this.isFromCache;
        }

        @NotNull
        public final TaskCheckpoint copy(@NotNull String taskName, long startTime, long endTime, boolean registered, boolean configured, boolean executed, boolean finishedSuccessfully, @Nullable String skippedMessage, @Nullable List<String> executionReasons, @Nullable Boolean isFromCache) {
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            return new TaskCheckpoint(taskName, startTime, endTime, registered, configured, executed, finishedSuccessfully, skippedMessage, executionReasons, isFromCache);
        }

        public static /* synthetic */ TaskCheckpoint copy$default(TaskCheckpoint taskCheckpoint, String string, long l, long l2, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string2, List list, Boolean bl5, int n, Object object) {
            if ((n & 1) != 0) {
                string = taskCheckpoint.taskName;
            }
            if ((n & 2) != 0) {
                l = taskCheckpoint.startTime;
            }
            if ((n & 4) != 0) {
                l2 = taskCheckpoint.endTime;
            }
            if ((n & 8) != 0) {
                bl = taskCheckpoint.registered;
            }
            if ((n & 0x10) != 0) {
                bl2 = taskCheckpoint.configured;
            }
            if ((n & 0x20) != 0) {
                bl3 = taskCheckpoint.executed;
            }
            if ((n & 0x40) != 0) {
                bl4 = taskCheckpoint.finishedSuccessfully;
            }
            if ((n & 0x80) != 0) {
                string2 = taskCheckpoint.skippedMessage;
            }
            if ((n & 0x100) != 0) {
                list = taskCheckpoint.executionReasons;
            }
            if ((n & 0x200) != 0) {
                bl5 = taskCheckpoint.isFromCache;
            }
            return taskCheckpoint.copy(string, l, l2, bl, bl2, bl3, bl4, string2, list, bl5);
        }

        @NotNull
        public String toString() {
            return "TaskCheckpoint(taskName=" + this.taskName + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", registered=" + this.registered + ", configured=" + this.configured + ", executed=" + this.executed + ", finishedSuccessfully=" + this.finishedSuccessfully + ", skippedMessage=" + this.skippedMessage + ", executionReasons=" + this.executionReasons + ", isFromCache=" + this.isFromCache + ")";
        }

        public int hashCode() {
            String string = this.taskName;
            long l = this.startTime;
            long l2 = this.endTime;
            int n = (((string != null ? string.hashCode() : 0) * 31 + (int)(l ^ l >>> 32)) * 31 + (int)(l2 ^ l2 >>> 32)) * 31;
            int n2 = this.registered ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            int n3 = (n + n2) * 31;
            int n4 = this.configured ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            int n5 = (n3 + n4) * 31;
            int n6 = this.executed ? 1 : 0;
            if (n6 != 0) {
                n6 = 1;
            }
            int n7 = (n5 + n6) * 31;
            int n8 = this.finishedSuccessfully ? 1 : 0;
            if (n8 != 0) {
                n8 = 1;
            }
            String string2 = this.skippedMessage;
            List<String> list = this.executionReasons;
            Boolean bl = this.isFromCache;
            return (((n7 + n8) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (bl != null ? ((Object)bl).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof TaskCheckpoint)) break block3;
                    TaskCheckpoint taskCheckpoint = (TaskCheckpoint)object;
                    if (!Intrinsics.areEqual((Object)this.taskName, (Object)taskCheckpoint.taskName) || this.startTime != taskCheckpoint.startTime || this.endTime != taskCheckpoint.endTime || this.registered != taskCheckpoint.registered || this.configured != taskCheckpoint.configured || this.executed != taskCheckpoint.executed || this.finishedSuccessfully != taskCheckpoint.finishedSuccessfully || !Intrinsics.areEqual((Object)this.skippedMessage, (Object)taskCheckpoint.skippedMessage) || !Intrinsics.areEqual(this.executionReasons, taskCheckpoint.executionReasons) || !Intrinsics.areEqual((Object)this.isFromCache, (Object)taskCheckpoint.isFromCache)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

