/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.instrumentation;

import com.android.build.api.extension.AndroidComponentsExtension;
import com.android.build.api.instrumentation.FramesComputationMode;
import com.android.build.api.instrumentation.InstrumentationScope;
import com.android.build.api.variant.Variant;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.instrumentation.SwazzleAsmClassVisitorFactory;
import io.embrace.android.gradle.swazzler.instrumentation.SwazzleParams;
import io.embrace.android.gradle.swazzler.instrumentation.TransformClassesWithReflectionException;
import io.embrace.android.gradle.swazzler.plugin.ProjectPropertiesKt;
import io.embrace.android.gradle.swazzler.util.AgpVersion;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u001a\u001b\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ2\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\t0\u0018R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00000\u0000 \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/embrace/android/gradle/swazzler/instrumentation/AsmCompatibilityHelper;", "", "()V", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "isInstrumentationAvailable", "", "registerAsmFactory", "", "project", "Lorg/gradle/api/Project;", "asmCallback", "Lorg/gradle/api/Action;", "Lcom/android/build/api/variant/Variant;", "setAsmFramesComputationMode", "variant", "framesComputationMode", "Lcom/android/build/api/instrumentation/FramesComputationMode;", "shouldUseASM", "transformClassesWith", "scope", "Lcom/android/build/api/instrumentation/InstrumentationScope;", "instrumentationConfiguration", "Lkotlin/Function1;", "Lio/embrace/android/gradle/swazzler/instrumentation/SwazzleParams;", "Agp4_2_2", "Agp7_1_0", "Agp8_0_0", "embrace-bug-shake-gradle-plugin"})
public final class AsmCompatibilityHelper {
    private static final Logger<AsmCompatibilityHelper> logger;
    @NotNull
    public static final AsmCompatibilityHelper INSTANCE;

    public final void setAsmFramesComputationMode(@NotNull Variant variant, @NotNull FramesComputationMode framesComputationMode) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)framesComputationMode, (String)"framesComputationMode");
        logger.debug("About to setAsmFramesComputationMode");
        if (this.isInstrumentationAvailable()) {
            logger.debug("Gradle instrumentation is available");
            Agp8_0_0.INSTANCE.setAsmFramesComputationMode(variant, framesComputationMode);
        } else {
            logger.debug("Gradle instrumentation is not available");
            Agp4_2_2.INSTANCE.setAsmFramesComputationMode(variant, framesComputationMode);
        }
        logger.debug("AsmFramesComputationMode successfully set");
    }

    public final void transformClassesWith(@NotNull Variant variant, @NotNull InstrumentationScope scope, @NotNull Project project, @NotNull Function1<? super SwazzleParams, Unit> instrumentationConfiguration) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(instrumentationConfiguration, (String)"instrumentationConfiguration");
        logger.debug("About to transformClassesWith");
        if (this.isInstrumentationAvailable()) {
            logger.debug("Gradle instrumentation is available");
            Agp8_0_0.INSTANCE.transformClassesWith(variant, scope, project, instrumentationConfiguration);
        } else {
            logger.debug("Gradle instrumentation is not available");
            Agp4_2_2.INSTANCE.transformClassesWith(variant, scope, instrumentationConfiguration);
        }
        logger.debug("transformClassesWith successfully called");
    }

    public final void registerAsmFactory(@NotNull Project project, @NotNull Action<Variant> asmCallback) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(asmCallback, (String)"asmCallback");
        logger.debug("About to registerAsmFactory");
        if (AgpVersion.Companion.isAtLeast(AgpVersion.AGP_7_1_0.INSTANCE)) {
            logger.debug("It is at least agp 7.1.0");
            Agp7_1_0.INSTANCE.registerAsmFactory(project, asmCallback);
        } else {
            logger.debug("agp is lower than 7.1.0");
            Agp4_2_2.INSTANCE.registerAsmFactory(project, asmCallback);
        }
        logger.debug("registerAsmFactory successfully called");
    }

    public final boolean shouldUseASM(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean useAsmTransformApi = ProjectPropertiesKt.getUseAsmTransformApi(project);
        if (AgpVersion.Companion.isAtLeast(AgpVersion.AGP_8_0_0.INSTANCE)) {
            logger.debug("It is at least agp 8.0.0");
            if (!useAsmTransformApi) {
                project.getLogger().info("Will use ASM transform api, even though embrace.useAsmTransformApi hasn't been set to true, because runtime version of AGP has removed previous transform api from its library.");
            }
            return true;
        }
        if (useAsmTransformApi) {
            logger.debug("Either property=embrace.useAsmTransformApi is true or it's not present and defaulted to true");
            if (!AgpVersion.Companion.isAtLeast(AgpVersion.AGP_4_2_2.INSTANCE)) {
                project.getLogger().warn("Will not use ASM transform api, because runtime AGP version must be at least 4.2.2. Will fall back to old transform api.");
                return false;
            }
            return true;
        }
        logger.debug("property=embrace.useAsmTransformApi is false");
        return false;
    }

    private final boolean isInstrumentationAvailable() {
        return AgpVersion.Companion.isAtLeast(AgpVersion.AGP_8_0_0.INSTANCE);
    }

    private AsmCompatibilityHelper() {
    }

    static {
        AsmCompatibilityHelper asmCompatibilityHelper;
        INSTANCE = asmCompatibilityHelper = new AsmCompatibilityHelper();
        logger = Logger.newLogger(AsmCompatibilityHelper.class);
    }

    public static final /* synthetic */ Logger access$getLogger$p(AsmCompatibilityHelper $this) {
        AsmCompatibilityHelper asmCompatibilityHelper = $this;
        return logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0001H\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J2\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000e0\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/embrace/android/gradle/swazzler/instrumentation/AsmCompatibilityHelper$Agp8_0_0;", "", "()V", "GET_INSTRUMENTATION_METHOD_NAME", "", "SET_FRAMES_COMP_MODE_METHOD_NAME", "TRANSFORM_CLASSES_WITH_METHOD_NAME", "getInstrumentationInstance", "variant", "Lcom/android/build/api/variant/Variant;", "getTransformClassesWithMethod", "Ljava/lang/reflect/Method;", "instrumentationInstance", "setAsmFramesComputationMode", "", "framesComputationMode", "Lcom/android/build/api/instrumentation/FramesComputationMode;", "transformClassesWith", "scope", "Lcom/android/build/api/instrumentation/InstrumentationScope;", "project", "Lorg/gradle/api/Project;", "instrumentationConfiguration", "Lkotlin/Function1;", "Lio/embrace/android/gradle/swazzler/instrumentation/SwazzleParams;", "embrace-bug-shake-gradle-plugin"})
    private static final class Agp8_0_0 {
        private static final String SET_FRAMES_COMP_MODE_METHOD_NAME = "setAsmFramesComputationMode";
        private static final String TRANSFORM_CLASSES_WITH_METHOD_NAME = "transformClassesWith";
        private static final String GET_INSTRUMENTATION_METHOD_NAME = "getInstrumentation";
        @NotNull
        public static final Agp8_0_0 INSTANCE;

        public final void setAsmFramesComputationMode(@NotNull Variant variant, @NotNull FramesComputationMode framesComputationMode) {
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            Intrinsics.checkNotNullParameter((Object)framesComputationMode, (String)"framesComputationMode");
            AsmCompatibilityHelper.access$getLogger$p(INSTANCE).debug("Setting FramesComputationMode=" + framesComputationMode.name() + " for agp >= 8.0.0");
            Object instrumentationInstance = this.getInstrumentationInstance(variant);
            AsmCompatibilityHelper.access$getLogger$p(INSTANCE).debug("Successfully obtained instrumentationInstance");
            Method asmFramesComputationModeMethod = instrumentationInstance.getClass().getMethod(SET_FRAMES_COMP_MODE_METHOD_NAME, FramesComputationMode.class);
            AsmCompatibilityHelper.access$getLogger$p(INSTANCE).debug("Successfully got method asmFramesComputationMode");
            asmFramesComputationModeMethod.invoke(instrumentationInstance, framesComputationMode);
            AsmCompatibilityHelper.access$getLogger$p(INSTANCE).debug("Successfully set frames computation mode");
        }

        public final void transformClassesWith(@NotNull Variant variant, @NotNull InstrumentationScope scope, @NotNull Project project, @NotNull Function1<? super SwazzleParams, Unit> instrumentationConfiguration) {
            block3: {
                boolean bl;
                boolean bl2;
                Object object;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                    Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter(instrumentationConfiguration, (String)"instrumentationConfiguration");
                    Object instrumentationInstance = this.getInstrumentationInstance(variant);
                    AsmCompatibilityHelper.access$getLogger$p(INSTANCE).debug("Successfully obtained instrumentationInstance");
                    Method transformClassesWithMethod = this.getTransformClassesWithMethod(instrumentationInstance);
                    Object object2 = transformClassesWithMethod;
                    if (object2 == null) break block2;
                    object = object2;
                    bl2 = false;
                    bl = false;
                    Object it = object;
                    boolean bl3 = false;
                    ((Method)it).invoke(instrumentationInstance, SwazzleAsmClassVisitorFactory.class, scope, instrumentationConfiguration);
                    project.getLogger().debug("Successfully called transformClassesWith method through reflection for agp >= 8.0.0");
                    object2 = object;
                    if (object2 != null) break block3;
                }
                object = this;
                bl2 = false;
                bl = false;
                Agp8_0_0 $this$run = (Agp8_0_0)object;
                boolean bl4 = false;
                String errorMessage = "transformClassesWith method was not found by reflection. Variant=" + variant.getName() + " will not be swazzled!";
                project.getLogger().warn(errorMessage);
                throw (Throwable)new TransformClassesWithReflectionException(errorMessage);
            }
        }

        private final Method getTransformClassesWithMethod(Object instrumentationInstance) {
            Method[] methodArray = instrumentationInstance.getClass().getMethods();
            int n = methodArray.length;
            for (int i = 0; i < n; ++i) {
                Method method;
                Method method2 = method = methodArray[i];
                Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"method");
                if (!Intrinsics.areEqual((Object)method2.getName(), (Object)TRANSFORM_CLASSES_WITH_METHOD_NAME)) continue;
                AsmCompatibilityHelper.access$getLogger$p(INSTANCE).debug("Successfully obtained transformClassesWithMethod");
                return method;
            }
            AsmCompatibilityHelper.access$getLogger$p(INSTANCE).debug("Failed to obtain transformClassesWithMethod");
            return null;
        }

        private final Object getInstrumentationInstance(Variant variant) {
            Object object = variant.getClass().getMethod(GET_INSTRUMENTATION_METHOD_NAME, new Class[0]).invoke((Object)variant, new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"variant::class.java.getM\u2026HOD_NAME).invoke(variant)");
            return object;
        }

        private Agp8_0_0() {
        }

        static {
            Agp8_0_0 agp8_0_0;
            INSTANCE = agp8_0_0 = new Agp8_0_0();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ*\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\u0012\u00a8\u0006\u0014"}, d2={"Lio/embrace/android/gradle/swazzler/instrumentation/AsmCompatibilityHelper$Agp4_2_2;", "", "()V", "registerAsmFactory", "", "project", "Lorg/gradle/api/Project;", "asmCallback", "Lorg/gradle/api/Action;", "Lcom/android/build/api/variant/Variant;", "setAsmFramesComputationMode", "variant", "framesComputationMode", "Lcom/android/build/api/instrumentation/FramesComputationMode;", "transformClassesWith", "scope", "Lcom/android/build/api/instrumentation/InstrumentationScope;", "instrumentationConfiguration", "Lkotlin/Function1;", "Lio/embrace/android/gradle/swazzler/instrumentation/SwazzleParams;", "embrace-bug-shake-gradle-plugin"})
    private static final class Agp4_2_2 {
        @NotNull
        public static final Agp4_2_2 INSTANCE;

        public final void setAsmFramesComputationMode(@NotNull Variant variant, @NotNull FramesComputationMode framesComputationMode) {
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            Intrinsics.checkNotNullParameter((Object)framesComputationMode, (String)"framesComputationMode");
            variant.setAsmFramesComputationMode(framesComputationMode);
            AsmCompatibilityHelper.access$getLogger$p(INSTANCE).debug("Successfully set FramesComputationMode=" + framesComputationMode.name() + " for agp >= 4.2.2 and variant=" + variant.getName());
        }

        public final void transformClassesWith(@NotNull Variant variant, @NotNull InstrumentationScope scope, @NotNull Function1<? super SwazzleParams, Unit> instrumentationConfiguration) {
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter(instrumentationConfiguration, (String)"instrumentationConfiguration");
            variant.transformClassesWith(SwazzleAsmClassVisitorFactory.class, scope, instrumentationConfiguration);
            AsmCompatibilityHelper.access$getLogger$p(INSTANCE).debug("Successfully transformClassesWith for agp >= 4.2.2 and variant=" + variant.getName());
        }

        public final void registerAsmFactory(@NotNull Project project, @NotNull Action<Variant> asmCallback) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(asmCallback, (String)"asmCallback");
            AndroidComponentsExtension extension = (AndroidComponentsExtension)project.getExtensions().getByType(AndroidComponentsExtension.class);
            AndroidComponentsExtension.DefaultImpls.onVariants$default((AndroidComponentsExtension)extension, null, (Function1)((Function1)new Function1<Variant, Unit>(asmCallback){
                final /* synthetic */ Action $asmCallback;

                public final void invoke(@NotNull Variant variant) {
                    Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                    this.$asmCallback.execute((Object)variant);
                }
                {
                    this.$asmCallback = action;
                    super(1);
                }
            }), (int)1, null);
        }

        private Agp4_2_2() {
        }

        static {
            Agp4_2_2 agp4_2_2;
            INSTANCE = agp4_2_2 = new Agp4_2_2();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/embrace/android/gradle/swazzler/instrumentation/AsmCompatibilityHelper$Agp7_1_0;", "", "()V", "ALL_METHOD_NAME", "", "ANDROID_COMPONENTS_EXTENSION_FULL_CLASS_NAME", "ON_VARIANTS_METHOD_NAME", "SELECTOR_METHOD_NAME", "VARIANT_SELECTOR_FULL_CLASS_NAME", "registerAsmFactory", "", "project", "Lorg/gradle/api/Project;", "asmCallback", "Lorg/gradle/api/Action;", "Lcom/android/build/api/variant/Variant;", "embrace-bug-shake-gradle-plugin"})
    private static final class Agp7_1_0 {
        private static final String VARIANT_SELECTOR_FULL_CLASS_NAME = "com.android.build.api.variant.VariantSelector";
        private static final String ANDROID_COMPONENTS_EXTENSION_FULL_CLASS_NAME = "com.android.build.api.variant.AndroidComponentsExtension";
        private static final String ON_VARIANTS_METHOD_NAME = "onVariants";
        private static final String SELECTOR_METHOD_NAME = "selector";
        private static final String ALL_METHOD_NAME = "all";
        @NotNull
        public static final Agp7_1_0 INSTANCE;

        public final void registerAsmFactory(@NotNull Project project, @NotNull Action<Variant> asmCallback) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(asmCallback, (String)"asmCallback");
            project.getLogger().debug("Will try to register for asm factory through reflection for agp >= 7.1.0");
            Class<?> variantSelectorClass = Class.forName(VARIANT_SELECTOR_FULL_CLASS_NAME);
            Class<?> androidComponentClass = Class.forName(ANDROID_COMPONENTS_EXTENSION_FULL_CLASS_NAME);
            Method onVariantsMethod = androidComponentClass.getMethod(ON_VARIANTS_METHOD_NAME, variantSelectorClass, Action.class);
            Method selectorMethod = androidComponentClass.getMethod(SELECTOR_METHOD_NAME, new Class[0]);
            Object extension = project.getExtensions().getByType(androidComponentClass);
            Object variantSelectorInstance = selectorMethod.invoke(extension, new Object[0]);
            Method variantSelectorAllMethod = variantSelectorClass.getMethod(ALL_METHOD_NAME, new Class[0]);
            Object allSelectorArg = variantSelectorAllMethod.invoke(variantSelectorInstance, new Object[0]);
            onVariantsMethod.invoke(extension, allSelectorArg, asmCallback);
            project.getLogger().debug("Successfully registered for asm factory through reflection for agp >= 7.1.0");
        }

        private Agp7_1_0() {
        }

        static {
            Agp7_1_0 agp7_1_0;
            INSTANCE = agp7_1_0 = new Agp7_1_0();
        }
    }
}

