/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.rules;

import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.plugin.rules.EmptySwazzlingRules;
import io.embrace.android.gradle.swazzler.plugin.rules.SwazzlerRulesStorage;
import io.embrace.android.gradle.swazzler.plugin.rules.SwazzlingRules;
import java.util.TreeMap;
import java.util.TreeSet;

@Deprecated
public class SmartSwazzlingManager {
    private static final Logger logger = Logger.newLogger(SmartSwazzlingManager.class);
    private final TreeMap<String, TreeSet<String>> unswazzledElements = new TreeMap();
    private final TreeMap<String, TreeSet<String>> swazzledElements = new TreeMap();
    public final SwazzlerRulesStorage swazzlerRulesStorage;
    public SwazzlingRules swazzlingRules = new EmptySwazzlingRules();

    public SmartSwazzlingManager(SwazzlerRulesStorage swazzlerRulesStorage) {
        this.swazzlerRulesStorage = swazzlerRulesStorage;
        swazzlerRulesStorage.withLogger(logger);
        this.loadSwazzlingRules();
    }

    public void addUnswazzledClass(String jarPackage, String clazz) {
        if (jarPackage == null) {
            logger.debug(String.format("Skipping adding class {%s} to unswazzledClassed; null artifact", clazz));
            return;
        }
        try {
            if (this.unswazzledElements.get(jarPackage) == null) {
                TreeSet<String> clazzes = new TreeSet<String>();
                clazzes.add(clazz);
                this.unswazzledElements.put(jarPackage, clazzes);
            } else {
                this.unswazzledElements.get(jarPackage).add(clazz);
            }
        }
        catch (Exception e) {
            logger.info(String.format("Failed updating unswazzled Jar package set {%s} with class {%s}", jarPackage, clazz), e);
        }
    }

    public void addSwazzledClass(String jarPackage, String clazz) {
        if (jarPackage == null) {
            logger.debug(String.format("Skipping adding class {%s} to swazzledClasses; null artifact", clazz));
            return;
        }
        try {
            if (this.swazzledElements.get(jarPackage) == null) {
                TreeSet<String> clazzes = new TreeSet<String>();
                clazzes.add(clazz);
                this.swazzledElements.put(jarPackage, clazzes);
            } else {
                this.swazzledElements.get(jarPackage).add(clazz);
            }
        }
        catch (Exception e) {
            logger.info(String.format("Failed updating swazzled Jar package set {%s} with class {%s}", jarPackage, clazz), e);
        }
    }

    public void deleteSwazzlingRulesFile() {
        this.swazzlerRulesStorage.deleteSwazzlingRulesFile();
    }

    public void saveSwazzlingRules() {
        SwazzlingRules swazzlingRules = new SwazzlingRules(this.swazzledElements, this.unswazzledElements);
        this.swazzlerRulesStorage.saveSwazzlingRules(swazzlingRules);
    }

    private void loadSwazzlingRules() {
        this.swazzlingRules = this.swazzlerRulesStorage.loadSwazzlingRules();
    }

    public boolean shouldSkipJar(String jarInput) {
        return this.swazzlingRules.shouldSkipJar(jarInput);
    }

    public boolean shouldSkipClass(String jarPackage, String name) {
        return this.swazzlingRules.shouldSkipClass(jarPackage, name);
    }
}

