/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.reactnative;

import com.android.build.gradle.api.ApplicationVariant;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.plugin.TaskRegisterKt;
import io.embrace.android.gradle.swazzler.plugin.TaskRegistrationUtilsKt;
import io.embrace.android.gradle.swazzler.plugin.extension.EmbraceExtensionInternal;
import io.embrace.android.gradle.swazzler.plugin.extension.SwazzlerExtension;
import io.embrace.android.gradle.swazzler.plugin.model.AndroidCompactedVariantData;
import io.embrace.android.gradle.swazzler.plugin.reactnative.EmbraceRnSourcemapGeneratorTask;
import io.embrace.android.gradle.swazzler.plugin.reactnative.EmbraceRnSourcemapGeneratorTaskRegistration;
import io.embrace.android.gradle.swazzler.plugin.reactnative.RnSourcemapPathFinder;
import io.embrace.android.gradle.swazzler.service.sentry.SentryVariantData;
import io.embrace.android.gradle.swazzler.util.GradleCompatibilityHelper;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u001e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\n\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00000\u0000 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/reactnative/EmbraceRnSourcemapGeneratorTaskRegistration;", "Lorg/gradle/api/Action;", "Lcom/android/build/gradle/api/ApplicationVariant;", "project", "Lorg/gradle/api/Project;", "swazzlerExtension", "Lio/embrace/android/gradle/swazzler/plugin/extension/SwazzlerExtension;", "embraceExtensionInternal", "Lio/embrace/android/gradle/swazzler/plugin/extension/EmbraceExtensionInternal;", "(Lorg/gradle/api/Project;Lio/embrace/android/gradle/swazzler/plugin/extension/SwazzlerExtension;Lio/embrace/android/gradle/swazzler/plugin/extension/EmbraceExtensionInternal;)V", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "configureCopyBundledJsTask", "", "task", "Lorg/gradle/api/Task;", "variant", "createRnSourcemapGeneratorTaskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Lio/embrace/android/gradle/swazzler/plugin/reactnative/EmbraceRnSourcemapGeneratorTask;", "execute", "mapProviderIfFileExists", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "regularFileProvider", "embrace-bug-shake-gradle-plugin"})
public final class EmbraceRnSourcemapGeneratorTaskRegistration
implements Action<ApplicationVariant> {
    private final Logger<EmbraceRnSourcemapGeneratorTaskRegistration> logger;
    private final Project project;
    private final SwazzlerExtension swazzlerExtension;
    private final EmbraceExtensionInternal embraceExtensionInternal;

    public void execute(@NotNull ApplicationVariant variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        this.logger.debug("About to register ReactNativeBundleRetrieverTask");
        String string = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.name");
        if (TaskRegistrationUtilsKt.isTaskRegistered(this.project, "embraceRNSourcemapGeneratorFor", string)) {
            this.logger.debug("Embrace React Native sourcemap generator task found for " + "variant " + variant.getName() + " in the task graph. Skipping task registration.");
            return;
        }
        this.logger.debug("EmbraceRNSourcemapGeneratorTask not registered, will attempt to register it");
        String wantedTaskName = "copy" + StringUtils.capitalize((String)variant.getName()) + "BundledJs";
        this.logger.debug("Attempting to configure EmbraceRNSourcemapGeneratorTask." + " Will iterate over all configured tasks in order to find task=" + wantedTaskName);
        this.project.getTasks().configureEach((Action)new Action<Task>(this, wantedTaskName, variant){
            final /* synthetic */ EmbraceRnSourcemapGeneratorTaskRegistration this$0;
            final /* synthetic */ String $wantedTaskName;
            final /* synthetic */ ApplicationVariant $variant;

            public final void execute(@NotNull Task task) {
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                EmbraceRnSourcemapGeneratorTaskRegistration.access$getLogger$p(this.this$0).debug("ConfigureEach for task=" + task.getName());
                if (Intrinsics.areEqual((Object)task.getName(), (Object)this.$wantedTaskName)) {
                    EmbraceRnSourcemapGeneratorTaskRegistration.access$configureCopyBundledJsTask(this.this$0, task, this.$variant);
                }
            }
            {
                this.this$0 = embraceRnSourcemapGeneratorTaskRegistration;
                this.$wantedTaskName = string;
                this.$variant = applicationVariant;
            }
        });
    }

    private final void configureCopyBundledJsTask(Task task, ApplicationVariant variant) {
        this.logger.debug("This task is the one we were looking for. Will attempt to add depends on.");
        task.dependsOn(new Object[]{new Callable<Object>(this, variant, task){
            final /* synthetic */ EmbraceRnSourcemapGeneratorTaskRegistration this$0;
            final /* synthetic */ ApplicationVariant $variant;
            final /* synthetic */ Task $task;

            public final Object call() {
                Object object = EmbraceRnSourcemapGeneratorTaskRegistration.access$getSwazzlerExtension$p(this.this$0).getDisableRNBundleRetriever().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"swazzlerExtension.disableRNBundleRetriever.get()");
                if (((Boolean)object).booleanValue()) {
                    EmbraceRnSourcemapGeneratorTaskRegistration.access$getLogger$p(this.this$0).info("React Native bundle retriever task is disabled by Embrace config for variant " + this.$variant.getName() + '.');
                    return CollectionsKt.emptyList();
                }
                EmbraceRnSourcemapGeneratorTaskRegistration.access$getLogger$p(this.this$0).info("React Native bundle retriever task is enabled for variant " + this.$variant.getName() + '.');
                EmbraceRnSourcemapGeneratorTaskRegistration.access$getLogger$p(this.this$0).debug("Our Callable object has been called. We will try to build the task we want to depend on.");
                String packageTaskName = "package" + StringUtils.capitalize((String)this.$variant.getName());
                EmbraceRnSourcemapGeneratorTaskRegistration.access$getLogger$p(this.this$0).debug("Will try to get task provider for task=" + packageTaskName);
                TaskProvider<Task> packageTaskProvider = TaskRegistrationUtilsKt.tryGetTaskProvider(EmbraceRnSourcemapGeneratorTaskRegistration.access$getProject$p(this.this$0), packageTaskName);
                if (packageTaskProvider != null) {
                    EmbraceRnSourcemapGeneratorTaskRegistration.access$getLogger$p(this.this$0).debug("TaskProvider for task=" + packageTaskName + " successfully found");
                    TaskProvider provider2 = EmbraceRnSourcemapGeneratorTaskRegistration.access$createRnSourcemapGeneratorTaskProvider(this.this$0, this.$variant);
                    EmbraceRnSourcemapGeneratorTaskRegistration.access$getLogger$p(this.this$0).info("Successfully registered Gradle task: embraceRNSourcemapGeneratorFor");
                    EmbraceRnSourcemapGeneratorTaskRegistration.access$getLogger$p(this.this$0).debug("Successfully added EmbraceRNSourcemapGeneratorTask as a dependency of task=" + this.$task.getName());
                    return provider2;
                }
                EmbraceRnSourcemapGeneratorTaskRegistration.access$getLogger$p(this.this$0).debug("TaskProvider for task=" + packageTaskName + " was not found");
                return CollectionsKt.emptyList();
            }
            {
                this.this$0 = embraceRnSourcemapGeneratorTaskRegistration;
                this.$variant = applicationVariant;
                this.$task = task;
            }
        }});
    }

    private final TaskProvider<EmbraceRnSourcemapGeneratorTask> createRnSourcemapGeneratorTaskProvider(ApplicationVariant variant) {
        return TaskRegisterKt.registerTask(this.project, "embraceRNSourcemapGeneratorFor", EmbraceRnSourcemapGeneratorTask.class, variant, (Provider<SentryVariantData>)((Provider)((EmbraceExtensionInternal.VariantExtension)this.embraceExtensionInternal.getVariants().getByName(variant.getName())).getSentryVariantData()), (Action)new Action<EmbraceRnSourcemapGeneratorTask>(this, variant){
            final /* synthetic */ EmbraceRnSourcemapGeneratorTaskRegistration this$0;
            final /* synthetic */ ApplicationVariant $variant;

            public final void execute(@NotNull EmbraceRnSourcemapGeneratorTask rnTask) {
                Intrinsics.checkNotNullParameter((Object)rnTask, (String)"rnTask");
                rnTask.getApiToken().set((Provider)EmbraceRnSourcemapGeneratorTaskRegistration.access$getEmbraceExtensionInternal$p(this.this$0).getApiToken());
                EmbraceExtensionInternal.VariantExtension variantExtension = (EmbraceExtensionInternal.VariantExtension)EmbraceRnSourcemapGeneratorTaskRegistration.access$getEmbraceExtensionInternal$p(this.this$0).getVariants().getByName(this.$variant.getName());
                rnTask.getAppId().set((Provider)variantExtension.getAppId());
                rnTask.getBuildId().set((Provider)variantExtension.getBuildId());
                ExtensionContainer extensionContainer = EmbraceRnSourcemapGeneratorTaskRegistration.access$getProject$p(this.this$0).getExtensions();
                Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"project.extensions");
                Object object = extensionContainer.getExtraProperties().get("react");
                if (!(object instanceof Map)) {
                    object = null;
                }
                RnSourcemapPathFinder sourcemapFinder = new RnSourcemapPathFinder((Map)object, null, 2, null);
                ProjectLayout projectLayout = EmbraceRnSourcemapGeneratorTaskRegistration.access$getProject$p(this.this$0).getLayout();
                Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"project.layout");
                Directory directory = projectLayout.getProjectDirectory();
                String string = this.$variant.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.name");
                TaskContainer taskContainer = EmbraceRnSourcemapGeneratorTaskRegistration.access$getProject$p(this.this$0).getTasks();
                Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
                ProviderFactory providerFactory = EmbraceRnSourcemapGeneratorTaskRegistration.access$getProject$p(this.this$0).getProviders();
                Intrinsics.checkNotNullExpressionValue((Object)providerFactory, (String)"project.providers");
                Provider bundleFile = directory.file(sourcemapFinder.getBundleFile(string, taskContainer, providerFactory));
                RegularFileProperty regularFileProperty = rnTask.getBundleFileProperty();
                Provider provider2 = bundleFile;
                Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"bundleFile");
                regularFileProperty.set(EmbraceRnSourcemapGeneratorTaskRegistration.access$mapProviderIfFileExists(this.this$0, provider2));
                ProjectLayout projectLayout2 = EmbraceRnSourcemapGeneratorTaskRegistration.access$getProject$p(this.this$0).getLayout();
                Intrinsics.checkNotNullExpressionValue((Object)projectLayout2, (String)"project.layout");
                Provider sourceMapFileProvider = projectLayout2.getBuildDirectory().file(sourcemapFinder.getEmbraceSourcemapFile());
                ProjectLayout projectLayout3 = EmbraceRnSourcemapGeneratorTaskRegistration.access$getProject$p(this.this$0).getLayout();
                Intrinsics.checkNotNullExpressionValue((Object)projectLayout3, (String)"project.layout");
                DirectoryProperty directoryProperty = projectLayout3.getBuildDirectory();
                String string2 = this.$variant.getDirName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"variant.dirName");
                Provider reactNativeSourceMapFileProvider = directoryProperty.file(sourcemapFinder.getReactNativeSourcemapFile(string2));
                RegularFileProperty regularFileProperty2 = rnTask.getSourceMapInputFileProperty();
                Provider provider3 = sourceMapFileProvider;
                Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"sourceMapFileProvider");
                Provider provider4 = EmbraceRnSourcemapGeneratorTaskRegistration.access$mapProviderIfFileExists(this.this$0, provider3);
                Provider provider5 = reactNativeSourceMapFileProvider;
                Intrinsics.checkNotNullExpressionValue((Object)provider5, (String)"reactNativeSourceMapFileProvider");
                regularFileProperty2.set(provider4.orElse(EmbraceRnSourcemapGeneratorTaskRegistration.access$mapProviderIfFileExists(this.this$0, provider5)));
                RegularFileProperty regularFileProperty3 = rnTask.getSourceMapJsonFileProperty();
                ProjectLayout projectLayout4 = EmbraceRnSourcemapGeneratorTaskRegistration.access$getProject$p(this.this$0).getLayout();
                Intrinsics.checkNotNullExpressionValue((Object)projectLayout4, (String)"project.layout");
                regularFileProperty3.set(projectLayout4.getBuildDirectory().file(sourcemapFinder.getSourceMapJson(AndroidCompactedVariantData.Companion.from(this.$variant))));
            }
            {
                this.this$0 = embraceRnSourcemapGeneratorTaskRegistration;
                this.$variant = applicationVariant;
            }
        });
    }

    private final Provider<RegularFile> mapProviderIfFileExists(Provider<RegularFile> regularFileProvider) {
        ProviderFactory providerFactory = this.project.getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)providerFactory, (String)"project.providers");
        return GradleCompatibilityHelper.INSTANCE.map(regularFileProvider, providerFactory, mapProviderIfFileExists.1.INSTANCE);
    }

    public EmbraceRnSourcemapGeneratorTaskRegistration(@NotNull Project project, @NotNull SwazzlerExtension swazzlerExtension, @NotNull EmbraceExtensionInternal embraceExtensionInternal) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)swazzlerExtension, (String)"swazzlerExtension");
        Intrinsics.checkNotNullParameter((Object)embraceExtensionInternal, (String)"embraceExtensionInternal");
        this.project = project;
        this.swazzlerExtension = swazzlerExtension;
        this.embraceExtensionInternal = embraceExtensionInternal;
        this.logger = Logger.newLogger(EmbraceRnSourcemapGeneratorTaskRegistration.class);
    }

    public static final /* synthetic */ Logger access$getLogger$p(EmbraceRnSourcemapGeneratorTaskRegistration $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$configureCopyBundledJsTask(EmbraceRnSourcemapGeneratorTaskRegistration $this, Task task, ApplicationVariant variant) {
        $this.configureCopyBundledJsTask(task, variant);
    }

    public static final /* synthetic */ SwazzlerExtension access$getSwazzlerExtension$p(EmbraceRnSourcemapGeneratorTaskRegistration $this) {
        return $this.swazzlerExtension;
    }

    public static final /* synthetic */ Project access$getProject$p(EmbraceRnSourcemapGeneratorTaskRegistration $this) {
        return $this.project;
    }

    public static final /* synthetic */ TaskProvider access$createRnSourcemapGeneratorTaskProvider(EmbraceRnSourcemapGeneratorTaskRegistration $this, ApplicationVariant variant) {
        return $this.createRnSourcemapGeneratorTaskProvider(variant);
    }

    public static final /* synthetic */ EmbraceExtensionInternal access$getEmbraceExtensionInternal$p(EmbraceRnSourcemapGeneratorTaskRegistration $this) {
        return $this.embraceExtensionInternal;
    }

    public static final /* synthetic */ Provider access$mapProviderIfFileExists(EmbraceRnSourcemapGeneratorTaskRegistration $this, Provider regularFileProvider) {
        return $this.mapProviderIfFileExists((Provider<RegularFile>)regularFileProvider);
    }
}

