/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.ndk;

import com.android.build.gradle.tasks.ExternalNativeBuildTask;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.plugin.ndk.ObjFolderCompatibilityHelper;
import io.embrace.android.gradle.swazzler.util.AgpVersion;
import io.embrace.android.gradle.swazzler.util.GradleCompatibilityHelper;
import java.io.File;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/ndk/ObjFolderCompatibilityHelper;", "", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "(Lio/embrace/android/gradle/swazzler/Logger;Lorg/gradle/api/provider/ProviderFactory;)V", "getArchitectureFiles", "Lorg/gradle/api/provider/Provider;", "", "Ljava/io/File;", "task", "Lcom/android/build/gradle/tasks/ExternalNativeBuildTask;", "getArchitectureFilesUsingNewApi", "getArchitectureFolders", "soFolder", "Lorg/gradle/api/file/DirectoryProperty;", "embrace-bug-shake-gradle-plugin"})
public final class ObjFolderCompatibilityHelper {
    private final Logger<ObjFolderCompatibilityHelper> logger;
    private final ProviderFactory providerFactory;

    @NotNull
    public final Provider<File[]> getArchitectureFiles(@NotNull ExternalNativeBuildTask task) {
        Provider provider2;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (AgpVersion.Companion.isAtLeast(AgpVersion.AGP_7_2_0.INSTANCE)) {
            provider2 = this.getArchitectureFilesUsingNewApi(task);
        } else {
            Provider provider3 = this.providerFactory.provider((Callable)new Callable<File[]>(this, task){
                final /* synthetic */ ObjFolderCompatibilityHelper this$0;
                final /* synthetic */ ExternalNativeBuildTask $task;

                public final File[] call() {
                    File objFolder = this.$task.getObjFolder();
                    ObjFolderCompatibilityHelper.access$getLogger$p(this.this$0).debug("obj folder path: " + objFolder.getPath());
                    File[] fileArray = objFolder.listFiles();
                    if (fileArray == null) {
                        fileArray = new File[]{};
                    }
                    return fileArray;
                }
                {
                    this.this$0 = objFolderCompatibilityHelper;
                    this.$task = externalNativeBuildTask;
                }
            });
            provider2 = provider3;
            Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"providerFactory.provider\u2026mptyArray()\n            }");
        }
        return provider2;
    }

    private final Provider<File[]> getArchitectureFilesUsingNewApi(ExternalNativeBuildTask task) {
        Provider<File[]> provider2;
        this.logger.debug("Trying to get so folder for AGP >= 7.2.0");
        try {
            Object object = task.getClass().getMethod("getSoFolder", new Class[0]).invoke((Object)task, new Object[0]);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.file.DirectoryProperty");
            }
            DirectoryProperty soFolder = (DirectoryProperty)object;
            provider2 = this.getArchitectureFolders(soFolder);
        }
        catch (NoSuchMethodException e) {
            this.logger.error("Get obj folder failed.", e);
            Provider<File[]> provider3 = this.providerFactory.provider((Callable)getArchitectureFilesUsingNewApi.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"providerFactory.provider { null }");
            provider2 = provider3;
        }
        return provider2;
    }

    private final Provider<File[]> getArchitectureFolders(DirectoryProperty soFolder) {
        return GradleCompatibilityHelper.INSTANCE.map((Provider)soFolder, this.providerFactory, (Transformer)new Transformer<File[], Directory>(this){
            final /* synthetic */ ObjFolderCompatibilityHelper this$0;

            @Nullable
            public final File[] transform(Directory it) {
                File[] fileArray;
                File[] localFolder2;
                Directory directory = it;
                Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"it");
                File soFolderFile = directory.getAsFile();
                Logger logger = ObjFolderCompatibilityHelper.access$getLogger$p(this.this$0);
                StringBuilder stringBuilder = new StringBuilder().append("so folder path: ");
                File file = soFolderFile;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"soFolderFile");
                logger.debug(stringBuilder.append(file.getPath()).toString());
                Object[] objectArray = soFolderFile.listFiles(getArchitectureFolders.localFolder.1.INSTANCE);
                File[] fileArray2 = localFolder2 = objectArray != null ? (File[])ArraysKt.getOrNull((Object[])objectArray, (int)0) : null;
                if (localFolder2 == null || (fileArray2 = fileArray2.listFiles()) == null) {
                    fileArray2 = fileArray = soFolderFile.listFiles();
                }
                if (fileArray2 == null) {
                    fileArray = new File[]{};
                }
                return fileArray;
            }
            {
                this.this$0 = objFolderCompatibilityHelper;
            }
        });
    }

    public ObjFolderCompatibilityHelper(@NotNull Logger<ObjFolderCompatibilityHelper> logger, @NotNull ProviderFactory providerFactory) {
        Intrinsics.checkNotNullParameter(logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        this.logger = logger;
        this.providerFactory = providerFactory;
    }

    public static final /* synthetic */ Logger access$getLogger$p(ObjFolderCompatibilityHelper $this) {
        return $this.logger;
    }
}

