/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.buildreporter;

import com.google.gson.Gson;
import io.embrace.android.gradle.swazzler.network.EmbraceEndpoint;
import io.embrace.android.gradle.swazzler.network.HttpCallResult;
import io.embrace.android.gradle.swazzler.network.NetworkService;
import io.embrace.android.gradle.swazzler.network.PostJsonParams;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildCheckpoints;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildStaticData;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildDataSender;", "", "networkService", "Lio/embrace/android/gradle/swazzler/network/NetworkService;", "gson", "Lcom/google/gson/Gson;", "(Lio/embrace/android/gradle/swazzler/network/NetworkService;Lcom/google/gson/Gson;)V", "sendDynamicData", "", "buildCheckpoints", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildCheckpoints;", "sendStaticData", "staticData", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildStaticData;", "embrace-bug-shake-gradle-plugin"})
public final class BuildDataSender {
    private final NetworkService networkService;
    private final Gson gson;

    public final boolean sendStaticData(@NotNull BuildStaticData staticData) {
        boolean bl;
        String staticDataJson;
        Intrinsics.checkNotNullParameter((Object)staticData, (String)"staticData");
        String string = staticDataJson = this.gson.toJson((Object)staticData);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"staticDataJson");
        HttpCallResult httpCallResult = this.networkService.postJson(new PostJsonParams(EmbraceEndpoint.STATIC_BUILD_DATA, null, null, string, 6, null));
        if (httpCallResult instanceof HttpCallResult.Success) {
            bl = true;
        } else if (httpCallResult instanceof HttpCallResult.Failure) {
            bl = false;
        } else if (httpCallResult instanceof HttpCallResult.Error) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public final boolean sendDynamicData(@NotNull BuildCheckpoints buildCheckpoints2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)buildCheckpoints2, (String)"buildCheckpoints");
        String dynamicData = buildCheckpoints2.toJson();
        HttpCallResult httpCallResult = this.networkService.postJson(new PostJsonParams(EmbraceEndpoint.DYNAMIC_BUILD_DATA, null, null, dynamicData, 6, null));
        if (httpCallResult instanceof HttpCallResult.Success) {
            bl = true;
        } else if (httpCallResult instanceof HttpCallResult.Failure) {
            bl = false;
        } else if (httpCallResult instanceof HttpCallResult.Error) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public BuildDataSender(@NotNull NetworkService networkService, @NotNull Gson gson2) {
        Intrinsics.checkNotNullParameter((Object)networkService, (String)"networkService");
        Intrinsics.checkNotNullParameter((Object)gson2, (String)"gson");
        this.networkService = networkService;
        this.gson = gson2;
    }
}

