/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin;

import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.di.DependencyInjectionProvider;
import io.embrace.android.gradle.swazzler.network.EmbraceEndpoint;
import io.embrace.android.gradle.swazzler.network.HttpCallResult;
import io.embrace.android.gradle.swazzler.network.UploadFileParams;
import io.embrace.android.gradle.swazzler.plugin.GradleUploadTask;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildReporter;
import io.embrace.android.gradle.swazzler.plugin.model.AndroidCompactedVariantData;
import io.embrace.android.gradle.swazzler.service.sentry.SentryLogger;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0010\u001a\u00020\u0015H\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007R2\u0010\r\u001a&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00000\u0000 \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00020\u00118G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/CompressedFileUploadTask;", "Lio/embrace/android/gradle/swazzler/plugin/GradleUploadTask;", "()V", "buildId", "Lorg/gradle/api/provider/Property;", "", "getBuildId", "()Lorg/gradle/api/provider/Property;", "endpoint", "Lio/embrace/android/gradle/swazzler/network/EmbraceEndpoint;", "getEndpoint", "filename", "getFilename", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "uploadFile", "Lorg/gradle/api/file/RegularFileProperty;", "getUploadFile", "()Lorg/gradle/api/file/RegularFileProperty;", "onRun", "", "embrace-bug-shake-gradle-plugin"})
public class CompressedFileUploadTask
extends GradleUploadTask {
    private final Logger<CompressedFileUploadTask> logger = Logger.newLogger(CompressedFileUploadTask.class);
    @NotNull
    private final RegularFileProperty uploadFile;
    @NotNull
    private final Property<String> buildId;
    @NotNull
    private final Property<String> filename;
    @NotNull
    private final Property<EmbraceEndpoint> endpoint;

    @InputFile
    @NotNull
    public final RegularFileProperty getUploadFile() {
        return this.uploadFile;
    }

    @Input
    @NotNull
    public final Property<String> getBuildId() {
        return this.buildId;
    }

    @Input
    @NotNull
    public final Property<String> getFilename() {
        return this.filename;
    }

    @Input
    @NotNull
    public final Property<EmbraceEndpoint> getEndpoint() {
        return this.endpoint;
    }

    @Override
    public void onRun() {
        this.uploadFile();
    }

    private final void uploadFile() throws IOException {
        block1: {
            HttpCallResult httpCallResult;
            HttpCallResult uploadResult;
            block2: {
                block0: {
                    File fileToUpload = (File)this.uploadFile.getAsFile().get();
                    StringBuilder stringBuilder = new StringBuilder().append("Uploading compressed file {");
                    File file = fileToUpload;
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"fileToUpload");
                    this.logger.info(stringBuilder.append(file.getPath()).append('}').toString());
                    Object object = this.endpoint.get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"endpoint.get()");
                    EmbraceEndpoint embraceEndpoint = (EmbraceEndpoint)((Object)object);
                    Object object2 = this.getAppId().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"appId.get()");
                    String string = (String)object2;
                    Object object3 = this.getApiToken().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"apiToken.get()");
                    String string2 = (String)object3;
                    Object object4 = this.filename.get();
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"filename.get()");
                    UploadFileParams uploadFileParams = new UploadFileParams(embraceEndpoint, string, string2, fileToUpload, (String)object4, (String)this.buildId.get());
                    httpCallResult = uploadResult = ((DependencyInjectionProvider)this.getDependencyInjectionProvider().get()).getNetworkService().uploadFile(uploadFileParams);
                    if (!(httpCallResult instanceof HttpCallResult.Success)) break block0;
                    this.logger.info("File was successfully uploaded. \n" + "Variant=" + ((AndroidCompactedVariantData)this.getVariantInfo().get()).getName() + " build_id=" + (String)this.buildId.get() + " \n");
                    break block1;
                }
                if (!(httpCallResult instanceof HttpCallResult.Failure)) break block2;
                this.logger.warn("Failed to upload file. \n" + "Variant=" + ((AndroidCompactedVariantData)this.getVariantInfo().get()).getName() + " build_id=" + (String)this.buildId.get() + ". \n" + "Status=" + ((HttpCallResult.Failure)uploadResult).getCode() + " Error=" + ((HttpCallResult.Failure)uploadResult).getErrorMessage() + " \n");
                break block1;
            }
            if (!(httpCallResult instanceof HttpCallResult.Error)) break block1;
            this.logger.warn("Failed to upload file \n" + "Variant=" + ((AndroidCompactedVariantData)this.getVariantInfo().get()).getName() + " build_id=" + (String)this.buildId.get() + ". \n" + "Exception=" + ((HttpCallResult.Error)uploadResult).getException() + " \n");
            ((SentryLogger)this.getSentryLogger().get()).sendException(((HttpCallResult.Error)uploadResult).getException());
            ((BuildReporter)this.getBuildReporter().get()).onException(((HttpCallResult.Error)uploadResult).getException());
        }
    }

    public CompressedFileUploadTask() {
        RegularFileProperty regularFileProperty = this.getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"getObjects().fileProperty()");
        this.uploadFile = regularFileProperty;
        Property property = this.getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"getObjects().property(String::class.java)");
        this.buildId = property;
        Property property2 = this.getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"getObjects().property(String::class.java)");
        this.filename = property2;
        Property property3 = this.getObjects().property(EmbraceEndpoint.class).convention((Object)EmbraceEndpoint.PROGUARD);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"getObjects().property(Em\u2026EmbraceEndpoint.PROGUARD)");
        this.endpoint = property3;
    }
}

