/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.util;

import com.android.build.api.transform.JarInput;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.plugin.oldtransform.JarInfo;
import io.embrace.android.gradle.swazzler.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;

@Deprecated
public final class JarUtils {
    private static final Logger logger = Logger.newLogger(JarUtils.class);
    private static final Pattern JAR_NAME_POST_4_2_PATTERN = Pattern.compile("[0-9a-fA-F]{40}");
    private static final String JETIFIED_PREFIX_NAME = "jetified-";
    private static final String JAR_SUFFIX_NAME = ".jar";
    private static final String RUNTIME_SUFFIX_NAME = "-runtime";

    private JarUtils() {
    }

    public static void createJarFileFromDirectory(File jarFile, File srcDir, boolean encodeClassNames) throws IOException {
        Validate.notNull((Object)jarFile, (String)"Destination JAR file is null.", (Object[])new Object[0]);
        Validate.notNull((Object)srcDir, (String)"Source directory file is null.", (Object[])new Object[0]);
        JarUtils.createJarFileFromDirectory(Paths.get(jarFile.getPath(), new String[0]), Paths.get(srcDir.getPath(), new String[0]), encodeClassNames);
    }

    public static void createJarFileFromDirectory(Path jarFile, final Path srcDir, boolean encodeClassNames) throws IOException {
        Validate.notNull((Object)jarFile, (String)"Destination JAR file is null.", (Object[])new Object[0]);
        Validate.notNull((Object)srcDir, (String)"Source directory file is null.", (Object[])new Object[0]);
        Validate.isTrue((boolean)srcDir.toFile().exists(), (String)("Source directory does not exist: " + srcDir), (Object[])new Object[0]);
        Validate.isTrue((boolean)srcDir.toFile().isDirectory(), (String)("Source directory is not a directory: " + srcDir), (Object[])new Object[0]);
        try (final JarOutputStream out = new JarOutputStream(new FileOutputStream(jarFile.toFile()));){
            Files.walkFileTree(srcDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
                    JarEntry entry = this.getJarEntry(path);
                    if (entry != null) {
                        out.putNextEntry(entry);
                        out.closeEntry();
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    JarEntry entry = this.getJarEntry(path);
                    if (entry != null) {
                        byte[] buffer = new byte[1024];
                        out.putNextEntry(entry);
                        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(path.toFile()));){
                            int len;
                            while ((len = in.read(buffer)) > 0) {
                                out.write(buffer, 0, len);
                            }
                        }
                        out.closeEntry();
                    }
                    return FileVisitResult.CONTINUE;
                }

                JarEntry getJarEntry(Path path) {
                    String relativePath = srcDir.relativize(path).toString().replace('\\', '/');
                    if (path.toFile().isDirectory() && !relativePath.endsWith("/")) {
                        relativePath = relativePath + "/";
                    }
                    if (FileUtils.isEncodedClassFile(relativePath)) {
                        return new JarEntry(FileUtils.decodeFileName(relativePath));
                    }
                    return relativePath.equals("/") ? null : new JarEntry(relativePath);
                }
            });
        }
    }

    public static void extractJarFileToDirectory(File jarFile, File destDir, boolean encodeClassNames) throws IOException, SecurityException {
        Validate.notNull((Object)jarFile, (String)"Source JAR file is null.", (Object[])new Object[0]);
        Validate.notNull((Object)destDir, (String)"Destination directory file is null.", (Object[])new Object[0]);
        JarUtils.extractJarFileToDirectory(Paths.get(jarFile.getPath(), new String[0]), Paths.get(destDir.getPath(), new String[0]), encodeClassNames);
    }

    public static void extractJarFileToDirectory(Path jarFile, Path destDir, boolean encodeClassNames) throws IOException, SecurityException {
        Validate.notNull((Object)jarFile, (String)"Source JAR file is null.", (Object[])new Object[0]);
        Validate.notNull((Object)destDir, (String)"Destination directory file is null.", (Object[])new Object[0]);
        Validate.isTrue((boolean)jarFile.toFile().exists(), (String)("Source JAR file does not exist: " + jarFile), (Object[])new Object[0]);
        Validate.isTrue((boolean)destDir.toFile().exists(), (String)("Destination directory does not exist: " + destDir), (Object[])new Object[0]);
        Validate.isTrue((boolean)destDir.toFile().isDirectory(), (String)("Destination directory is not a directory: " + destDir), (Object[])new Object[0]);
        byte[] buffer = new byte[1024];
        try (JarInputStream in = new JarInputStream(new FileInputStream(jarFile.toFile()));){
            JarEntry entry = in.getNextJarEntry();
            while (entry != null) {
                String entryName = entry.getName();
                if (encodeClassNames && FileUtils.isPlainClassFile(entry.getName())) {
                    entryName = FileUtils.encodeFileName(entryName);
                }
                File destFile = Paths.get(destDir.toString(), entryName).toFile();
                if (entry.isDirectory()) {
                    destFile.mkdirs();
                } else {
                    new File(destFile.getParent()).mkdirs();
                    try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destFile));){
                        int len;
                        while ((len = in.read(buffer)) > 0) {
                            out.write(buffer, 0, len);
                        }
                    }
                }
                entry = in.getNextJarEntry();
            }
        }
    }

    public static JarInfo getJarInfo(JarInput jarInput) {
        String jarName = jarInput.getName();
        if (JAR_NAME_POST_4_2_PATTERN.matcher(jarName).matches()) {
            return JarUtils.getPost42JarInfo(jarInput);
        }
        return JarUtils.getPre42JarInfo(jarInput);
    }

    private static JarInfo getPre42JarInfo(JarInput jarInput) {
        if (jarInput == null) {
            return null;
        }
        return new JarInfo(jarInput.getName(), JarInfo.JarType.PRE_4_2);
    }

    private static JarInfo getPost42JarInfo(JarInput jarInput) {
        String filename;
        if (jarInput == null) {
            return null;
        }
        String jarname = filename = jarInput.getFile().getName();
        logger.debug(String.format("JAR-INFO: Attempting to process JarInput AGP4.2 {fileName: %s}", jarname));
        if (filename.startsWith(JETIFIED_PREFIX_NAME)) {
            jarname = jarname.substring(JETIFIED_PREFIX_NAME.length());
        }
        logger.debug(String.format("JAR-INFO: {fileName: %s}", jarname));
        if (filename.endsWith(JAR_SUFFIX_NAME)) {
            jarname = jarname.substring(0, jarname.length() - JAR_SUFFIX_NAME.length());
        }
        logger.debug(String.format("JAR-INFO: {fileName: %s}", jarname));
        if (filename.contains(RUNTIME_SUFFIX_NAME) && jarname.endsWith(RUNTIME_SUFFIX_NAME)) {
            jarname = jarname.substring(0, jarname.length() - RUNTIME_SUFFIX_NAME.length());
        }
        logger.debug(String.format("JAR-INFO: {fileName: %s}", jarname));
        return new JarInfo(jarname, JarInfo.JarType.POST_4_2);
    }
}

