/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.rules;

import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.plugin.GradleTask;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildReporter;
import io.embrace.android.gradle.swazzler.plugin.rules.SmartSwazzlingManager;
import io.embrace.android.gradle.swazzler.service.sentry.SentryLogger;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;

public class SwazzlingRulesGeneratorTask
extends GradleTask {
    public static final String NAME = "generateEmbraceSwazzlingRulesFor";
    private static final Logger logger = Logger.newLogger(SwazzlingRulesGeneratorTask.class);
    private Property<SmartSwazzlingManager> smartSwazzlingManagerProperty = this.getObjects().property(SmartSwazzlingManager.class);

    @Override
    public void onRun() {
        try {
            logger.info("Generating smart swazzling rules file.");
            ((SmartSwazzlingManager)this.smartSwazzlingManagerProperty.get()).saveSwazzlingRules();
        }
        catch (Exception e) {
            logger.warn("Unable to generate swazzling rules");
            ((SentryLogger)this.getSentryLogger().get()).sendException(e);
            ((BuildReporter)this.getBuildReporter().get()).onException(e);
            throw e;
        }
    }

    @Internal
    public Property<SmartSwazzlingManager> getSmartSwazzlingManagerProperty() {
        return this.smartSwazzlingManagerProperty;
    }
}

