/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.oldtransform;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.BaseExtension;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.compile.manifest.SwazzleManifest;
import io.embrace.android.gradle.swazzler.compile.swazzler.Swazzler;
import io.embrace.android.gradle.swazzler.plugin.PluginErrorMessages;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildReporter;
import io.embrace.android.gradle.swazzler.plugin.extension.SwazzlerExtension;
import io.embrace.android.gradle.swazzler.plugin.oldtransform.IncrementalSwazzleTransformer;
import io.embrace.android.gradle.swazzler.plugin.oldtransform.NonIncrementalSwazzleTransformer;
import io.embrace.android.gradle.swazzler.plugin.oldtransform.SwazzleTransformException;
import io.embrace.android.gradle.swazzler.plugin.oldtransform.SwazzleTransformer;
import io.embrace.android.gradle.swazzler.plugin.rules.SmartSwazzlingManager;
import io.embrace.android.gradle.swazzler.service.sentry.SentryLogger;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javassist.ClassPool;
import javassist.NotFoundException;
import org.apache.commons.lang3.Validate;

@Deprecated
public class SwazzleTransform
extends Transform {
    public static final String NAME = "swazzle";
    static final Set<QualifiedContent.ContentType> INPUT_TYPES = Collections.unmodifiableSet(new HashSet<QualifiedContent.DefaultContentType>(Collections.singleton(QualifiedContent.DefaultContentType.CLASSES)));
    static final Set<QualifiedContent.ContentType> OUTPUT_TYPES = Collections.unmodifiableSet(new HashSet<QualifiedContent.DefaultContentType>(Collections.singleton(QualifiedContent.DefaultContentType.CLASSES)));
    static final Set<QualifiedContent.Scope> SCOPES = Collections.unmodifiableSet(new HashSet<QualifiedContent.Scope>(Arrays.asList(QualifiedContent.Scope.PROJECT, QualifiedContent.Scope.SUB_PROJECTS, QualifiedContent.Scope.EXTERNAL_LIBRARIES)));
    private static final Logger logger = Logger.newLogger(SwazzleTransform.class);
    final BaseExtension androidExtension;
    final ClassPool classPool;
    final Swazzler swazzler;
    final SwazzlerExtension swazzlerExtension;
    final SmartSwazzlingManager smartSwazzlingManager;
    final Boolean encodeExtractedFileNames;
    final SentryLogger sentryLogger;
    final BuildReporter buildReporter;

    public SwazzleTransform(BaseExtension androidExtension, SwazzlerExtension swazzlerExtension, SwazzleManifest swazzleManifest, SmartSwazzlingManager smartSwazzlingManager, SentryLogger sentryLogger, BuildReporter buildReporter, Boolean encodeExtractedFileNames) throws SwazzleTransformException {
        Validate.notNull((Object)androidExtension, (String)"Android Extension instance is null.", (Object[])new Object[0]);
        Validate.notNull((Object)swazzlerExtension, (String)"SwazzlerExtension instance is null.", (Object[])new Object[0]);
        Validate.notNull((Object)smartSwazzlingManager, (String)"Smart swazzling manager instance is null.", (Object[])new Object[0]);
        Validate.notNull((Object)encodeExtractedFileNames, (String)"Encode extracted file names setting is null.", (Object[])new Object[0]);
        try {
            this.androidExtension = androidExtension;
            this.classPool = new ClassPool(true);
            this.swazzler = new Swazzler(this.classPool, swazzleManifest);
            this.swazzlerExtension = swazzlerExtension;
            this.smartSwazzlingManager = smartSwazzlingManager;
            this.sentryLogger = sentryLogger;
            this.buildReporter = buildReporter;
            this.encodeExtractedFileNames = encodeExtractedFileNames;
        }
        catch (Exception e) {
            throw new SwazzleTransformException("An exception was thrown while initializing the SwazzleTransform instance.", e);
        }
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return INPUT_TYPES;
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return OUTPUT_TYPES;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return SCOPES;
    }

    public boolean isIncremental() {
        return true;
    }

    public final String getName() {
        return NAME;
    }

    public final void transform(TransformInvocation invocation) {
        String variantName = invocation.getContext().getVariantName();
        if (this.swazzlerExtension.isSwazzlingDisabled(variantName)) {
            logger.info(String.format("Will skip swazzling. Swazzling is disabled for variant %s.", variantName));
            return;
        }
        try {
            SwazzleTransformer transformer;
            try {
                long startTime = System.currentTimeMillis();
                logger.info("Populating class pool from input dependencies.");
                this.registerPathsWithClassPool(this.androidExtension.getBootClasspath().stream().map(File::toString).collect(Collectors.toList()));
                this.registerInputsWithClassPool(invocation.getInputs());
                this.registerInputsWithClassPool(invocation.getReferencedInputs());
                logger.info(String.format("All input dependencies successfully added to the class pool in %dms.", System.currentTimeMillis() - startTime));
            }
            catch (NotFoundException e) {
                throw new SwazzleTransformException("An exception was thrown while attempting to register dependencies with the class pool.", e);
            }
            if (invocation.isIncremental()) {
                logger.info("Executing swazzle transformer: INCREMENTAL");
                transformer = new IncrementalSwazzleTransformer(this, this.classPool, this.swazzler, this.swazzlerExtension, this.smartSwazzlingManager, this.encodeExtractedFileNames);
            } else {
                logger.info("Executing swazzle transformer: NON-INCREMENTAL");
                transformer = new NonIncrementalSwazzleTransformer(this, this.classPool, this.swazzler, this.swazzlerExtension, this.smartSwazzlingManager, this.encodeExtractedFileNames);
            }
            transformer.run(invocation);
        }
        catch (Exception e) {
            SwazzleTransformException exception = new SwazzleTransformException("An exception was thrown while attempting a swazzle transformation. " + PluginErrorMessages.getProjectCleanNeeded(), e);
            this.sentryLogger.sendException(exception);
            this.buildReporter.onException(exception);
            throw exception;
        }
    }

    void registerInputsWithClassPool(Collection<TransformInput> inputs) throws NotFoundException {
        this.registerPathsWithClassPool(inputs.stream().map(input -> Arrays.asList(input.getJarInputs(), input.getDirectoryInputs())).flatMap(Collection::stream).flatMap(Collection::stream).map(input -> input.getFile().toString()).collect(Collectors.toList()));
    }

    void registerPathsWithClassPool(Collection<String> paths) throws NotFoundException {
        for (String path : paths) {
            this.classPool.appendClassPath(path);
        }
    }
}

