/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.knownissues;

import io.embrace.android.gradle.swazzler.plugin.SwazzlerException;
import io.embrace.android.gradle.swazzler.plugin.knownissues.KnownIssueListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/knownissues/IronSourceIssue;", "Lio/embrace/android/gradle/swazzler/plugin/knownissues/KnownIssueListener;", "()V", "name", "", "getName", "()Ljava/lang/String;", "isKnownIssue", "", "failure", "performAction", "", "embrace-bug-shake-gradle-plugin"})
public final class IronSourceIssue
extends KnownIssueListener {
    @NotNull
    private final String name;

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isKnownIssue(@NotNull String failure) {
        Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
        return StringsKt.contains((CharSequence)failure, (CharSequence)"com.ironsource.mediationsdk", (boolean)true) || StringsKt.contains((CharSequence)failure, (CharSequence)"actually defines class", (boolean)true);
    }

    @Override
    public void performAction() {
        throw (Throwable)new SwazzlerException("Unable to transform all jars correctly. This can be caused by a library defining classes with names that only differ in case (e.g. m.class and M.class). Because of this, the build fails because of duplicated classes.\nPlease follow any of these suggestions:\n\t- set ASM as your default transform api by upgrading embrace plugin to version 5.3.0 or greater (Recommended)\n\t\tIf you already match this requirement and the issue still persists, then check if the following property exists in your gradle.properties file. If so, then remove it:\n\t\t\tembrace.useAsmTransformApi=false\n\t- or add the following configuration to your build.gradle file: (https://embrace.io/docs/android/features/build-options/#encodeextractedfilenames-bool)\n\t\tswazzler {\n\t\t\tencodeExtractedFileNames = true\n\t\t}" + "\nStacktrace:\n" + this.getOriginalStacktrace());
    }

    public IronSourceIssue() {
        this.name = "IronSource Mediation SDK Issue";
    }
}

