/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin;

import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.plugin.GradleTask;
import io.embrace.android.gradle.swazzler.plugin.TaskException;
import io.embrace.android.gradle.swazzler.service.sentry.SentryLogger;
import io.embrace.android.gradle.swazzler.util.compression.FileCompressor;
import io.embrace.android.gradle.swazzler.util.compression.ZstdFileCompressor;
import java.io.File;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;

public class FileCompressionTask
extends GradleTask {
    private static final Logger logger = Logger.newLogger(FileCompressionTask.class);
    private FileCompressor fileCompressor = new ZstdFileCompressor(this.getSentryLogger(), this.getBuildReporter());
    private final RegularFileProperty originalFile = this.getObjects().fileProperty();
    private final RegularFileProperty compressedFile = this.getObjects().fileProperty();

    @Override
    public void onRun() {
        try {
            logger.info("Starting file compression task");
            this.compressFile((File)this.getOriginalFile().getAsFile().get());
        }
        catch (Exception e) {
            ((SentryLogger)this.getSentryLogger().get()).sendException(e);
            throw new TaskException("Failed compressing artifact.", e);
        }
    }

    private void compressFile(File inputFile) {
        String outputDir = ((File)this.compressedFile.getAsFile().get()).getParent();
        File compressedFile = this.fileCompressor.compress(inputFile, outputDir);
        if (compressedFile == null) {
            throw new TaskException("Error while compressing file");
        }
        logger.info("File successfully compressed.");
    }

    public void setFileCompressor(FileCompressor fileCompressor) {
        this.fileCompressor = fileCompressor;
    }

    @InputFile
    public RegularFileProperty getOriginalFile() {
        return this.originalFile;
    }

    @OutputFile
    public RegularFileProperty getCompressedFile() {
        return this.compressedFile;
    }
}

