/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.compile.manifest;

import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.compile.manifest.ClassDirective;
import io.embrace.android.gradle.swazzler.compile.manifest.InterfaceDirective;
import io.embrace.android.gradle.swazzler.compile.manifest.SwazzleManifestException;
import io.embrace.android.gradle.swazzler.config.Config;
import io.embrace.android.gradle.swazzler.config.swazzle.SwazzleDirective;
import io.embrace.android.gradle.swazzler.config.swazzle.SwazzleDirectivesConfigKt;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

@Deprecated
public final class SwazzleManifest {
    static final int DIRECTIVE_TYPE_UNKNOWN = 0;
    static final int DIRECTIVE_TYPE_CLASS = 1;
    static final int DIRECTIVE_TYPE_INTERFACE = 2;
    private static final Logger logger = Logger.newLogger(SwazzleManifest.class);
    private static final String FORMAT_TO_STRING = "{method-suffix=%s, classes=%s, interfaces=%s}";
    final String methodSuffix;
    final String version;
    final Map<String, ClassDirective> classes = new HashMap<String, ClassDirective>();
    final Map<String, InterfaceDirective> interfaces = new HashMap<String, InterfaceDirective>();

    public SwazzleManifest(Config config) throws SwazzleManifestException {
        Validate.notNull((Object)config, (String)"Config is null.", (Object[])new Object[0]);
        this.methodSuffix = config.getSwazzlerMethodSuffix();
        this.version = "0.5.0";
        if (StringUtils.isBlank((CharSequence)this.methodSuffix)) {
            throw new SwazzleManifestException("Swazzle method suffix is null or blank.");
        }
        if (StringUtils.isBlank((CharSequence)this.version)) {
            throw new SwazzleManifestException("Swazzle version is null or blank.");
        }
    }

    public static SwazzleManifest buildManifest(Config config) throws SwazzleManifestException {
        long startTime = System.currentTimeMillis();
        SwazzleManifest manifest = new SwazzleManifest(config);
        for (SwazzleDirective directive : SwazzleDirectivesConfigKt.getSwazzleDirectives()) {
            manifest.register(directive.getDirective());
        }
        logger.debug("Loaded swazzling rules.");
        logger.debug(String.format("Swazzle manifest successfully built in %dms.", System.currentTimeMillis() - startTime));
        return manifest;
    }

    static int getDirectiveType(Map<String, Object> directive) {
        int directiveType = 0;
        if (directive.get("class") != null) {
            directiveType |= 1;
        }
        if (directive.get("interface") != null) {
            directiveType |= 2;
        }
        return Integer.bitCount(directiveType) == 1 ? directiveType : 0;
    }

    public void register(Map<String, Object> directive) throws SwazzleManifestException {
        if (directive == null) {
            throw new IllegalArgumentException("Directive map is null.");
        }
        switch (SwazzleManifest.getDirectiveType(directive)) {
            case 1: {
                ClassDirective clazz = new ClassDirective(this, directive);
                this.classes.put(clazz.getName(), clazz);
                break;
            }
            case 2: {
                InterfaceDirective iface = new InterfaceDirective(this, directive);
                this.interfaces.put(iface.getName(), iface);
                break;
            }
            default: {
                throw new SwazzleManifestException("Directive type could not be determined.");
            }
        }
    }

    public Map<String, ClassDirective> getClasses() {
        return this.classes;
    }

    public Map<String, InterfaceDirective> getInterfaces() {
        return this.interfaces;
    }

    public String getMethodSuffix() {
        return this.methodSuffix;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return String.format(FORMAT_TO_STRING, this.methodSuffix, this.classes, this.interfaces);
    }
}

