/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.util;

import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.config.unity.UnityConfig;
import io.embrace.android.gradle.swazzler.config.unity.UnitySymbolsDir;
import io.embrace.android.gradle.swazzler.plugin.model.AndroidCompactedVariantData;
import io.embrace.android.gradle.swazzler.service.sentry.SentryLogger;
import java.io.File;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.file.Directory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J/\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J+\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0019J*\u0010\u001a\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J.\u0010\u001f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010 \u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\rH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\rH\u0002J$\u0010$\u001a\u0004\u0018\u00010\n2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\n2\b\u0010%\u001a\u0004\u0018\u00010\u0012H\u0002R2\u0010\u0005\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00000\u0000 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/embrace/android/gradle/swazzler/util/UnitySymbolFilesManager;", "", "sentryLogger", "Lio/embrace/android/gradle/swazzler/service/sentry/SentryLogger;", "(Lio/embrace/android/gradle/swazzler/service/sentry/SentryLogger;)V", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "extractSoFilesFromZipFile", "", "Ljava/io/File;", "objFolder", "buildDir", "Lorg/gradle/api/file/Directory;", "variantData", "Lio/embrace/android/gradle/swazzler/plugin/model/AndroidCompactedVariantData;", "(Ljava/io/File;Lorg/gradle/api/file/Directory;Lio/embrace/android/gradle/swazzler/plugin/model/AndroidCompactedVariantData;)[Ljava/io/File;", "getCustomSymbolsArchiveName", "", "unityConfig", "Lio/embrace/android/gradle/swazzler/config/unity/UnityConfig;", "getMappingFileFolder", "getSymbolFiles", "unitySymbolsDir", "Lio/embrace/android/gradle/swazzler/config/unity/UnitySymbolsDir;", "(Lio/embrace/android/gradle/swazzler/config/unity/UnitySymbolsDir;Lorg/gradle/api/file/Directory;Lio/embrace/android/gradle/swazzler/plugin/model/AndroidCompactedVariantData;)[Ljava/io/File;", "getSymbolsDir", "realProjectDirectory", "projectDirectory", "getUncompressedUnityFilesPath", "getUnitySymbolsArchive", "getUnitySymbolsArchiveFromExportDir", "projectDir", "exportDir", "getUnitySymbolsDir", "getUnityTempSymbolsDir", "searchSymbolsArchive", "customArchiveName", "Factory", "embrace-bug-shake-gradle-plugin"})
public final class UnitySymbolFilesManager {
    private final Logger<UnitySymbolFilesManager> logger = Logger.newLogger(UnitySymbolFilesManager.class);
    private final SentryLogger sentryLogger;
    private static UnitySymbolFilesManager INSTANCE;
    @NotNull
    public static final Factory Factory;

    @Nullable
    public final UnitySymbolsDir getSymbolsDir(@NotNull Directory realProjectDirectory, @NotNull Directory projectDirectory, @NotNull AndroidCompactedVariantData variantData, @Nullable UnityConfig unityConfig) {
        Intrinsics.checkNotNullParameter((Object)realProjectDirectory, (String)"realProjectDirectory");
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        Intrinsics.checkNotNullParameter((Object)variantData, (String)"variantData");
        StringBuilder stringBuilder = new StringBuilder().append("Project at path=");
        File file = realProjectDirectory.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"realProjectDirectory.asFile");
        this.logger.debug(stringBuilder.append(file.getAbsolutePath()).toString());
        File unitySymbolsArchiveFile = this.getUnitySymbolsArchive(projectDirectory, variantData, unityConfig);
        if (unitySymbolsArchiveFile != null) {
            this.logger.debug("Unity symbols archive file found");
            return new UnitySymbolsDir(unitySymbolsArchiveFile, true);
        }
        this.logger.debug("Unity symbols archive file not found");
        File unitySymbolsDir = this.getUnitySymbolsDir(projectDirectory);
        if (unitySymbolsDir != null) {
            this.logger.debug("Unity symbols dir found");
            return new UnitySymbolsDir(unitySymbolsDir, false);
        }
        this.logger.debug("Unity symbols dir not found");
        File unityTempSymbolsDir = this.getUnityTempSymbolsDir(realProjectDirectory);
        if (unityTempSymbolsDir != null) {
            this.logger.debug("unityTempSymbols Dir found");
            return new UnitySymbolsDir(unityTempSymbolsDir, false);
        }
        this.logger.debug("unityTempSymbols Dir not found");
        StringBuilder stringBuilder2 = new StringBuilder().append("No Unity symbols found for project at path=");
        File file2 = realProjectDirectory.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"realProjectDirectory.asFile");
        this.logger.debug(stringBuilder2.append(file2.getAbsolutePath()).append(". ").append("The project is not a Unity project or symbols file was not exported.").toString());
        return new UnitySymbolsDir(null, false, 3, null);
    }

    @Nullable
    public final File[] getSymbolFiles(@NotNull UnitySymbolsDir unitySymbolsDir, @NotNull Directory buildDir, @NotNull AndroidCompactedVariantData variantData) {
        Intrinsics.checkNotNullParameter((Object)unitySymbolsDir, (String)"unitySymbolsDir");
        Intrinsics.checkNotNullParameter((Object)buildDir, (String)"buildDir");
        Intrinsics.checkNotNullParameter((Object)variantData, (String)"variantData");
        File[] listOfArch = null;
        if (unitySymbolsDir.isDirPresent() && unitySymbolsDir.getZippedSymbols()) {
            File file = unitySymbolsDir.getUnitySymbolsDir();
            this.logger.debug("Attempting to use symbols from symbols.zip in " + (file != null ? file.getPath() : null));
            listOfArch = this.extractSoFilesFromZipFile(unitySymbolsDir.getUnitySymbolsDir(), buildDir, variantData);
        } else {
            File file = unitySymbolsDir.getUnitySymbolsDir();
            this.logger.debug("Attempting to use symbols from " + (file != null ? file.getPath() : null));
            File file2 = unitySymbolsDir.getUnitySymbolsDir();
            listOfArch = file2 != null ? file2.listFiles() : null;
        }
        return listOfArch;
    }

    private final File getUnitySymbolsArchive(Directory projectDirectory, AndroidCompactedVariantData variantData, UnityConfig unityConfig) {
        File file = projectDirectory.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"projectDirectory.asFile");
        File projectDir = file.getParentFile();
        StringBuilder stringBuilder = new StringBuilder().append("Attempting to find Unity symbols archive {projectPath=");
        File file2 = projectDir;
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"projectDir");
        this.logger.debug(stringBuilder.append(file2.getPath()).append(", ").append("variant=").append(variantData.getName()).append('}').toString());
        this.logger.debug("Project dir=" + projectDir.getPath());
        File exportDir = projectDir.getParentFile();
        return this.getUnitySymbolsArchiveFromExportDir(variantData, unityConfig, projectDir, exportDir);
    }

    private final File getUnitySymbolsArchiveFromExportDir(AndroidCompactedVariantData variantData, UnityConfig unityConfig, File projectDir, File exportDir) {
        File file;
        if (exportDir == null) {
            this.logger.debug("Export dir is null");
            return null;
        }
        this.logger.debug("Export dir=" + exportDir.getPath());
        String customArchiveName = this.getCustomSymbolsArchiveName(variantData, unityConfig);
        File symbolsArchive = this.searchSymbolsArchive(projectDir, exportDir, customArchiveName);
        File exportDirParent = exportDir.getParentFile();
        if (symbolsArchive == null && exportDirParent != null) {
            symbolsArchive = this.searchSymbolsArchive(projectDir, exportDirParent, customArchiveName);
        }
        if (symbolsArchive == null) {
            StringBuilder stringBuilder = new StringBuilder().append("No Unity symbols archive found {path=").append(exportDir.getPath()).append(" or ").append("path=");
            Object object = exportDirParent;
            if (object == null || (object = ((File)object).getPath()) == null) {
                object = "";
            }
            this.logger.debug(stringBuilder.append((String)object).append('}').toString());
            file = null;
        } else {
            this.logger.info("Unity symbols archive found {path=" + symbolsArchive.getPath());
            file = symbolsArchive;
        }
        return file;
    }

    private final File searchSymbolsArchive(File projectDir, File exportDir, String customArchiveName) {
        String defaultArchiveName = projectDir.getName();
        this.logger.debug("Searching for Unity symbols archive " + "{customName=" + customArchiveName + ", defaultName=" + defaultArchiveName + ", path=" + exportDir + '}');
        File foundFile = null;
        try {
            File[] fileArray = exportDir.listFiles();
            if (fileArray != null) {
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                File[] fileArray2 = $this$forEach$iv;
                int n = fileArray2.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File file = element$iv = fileArray2[i];
                    boolean bl = false;
                    if (customArchiveName != null) {
                        File file2 = file;
                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                        String string = file2.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                        if (StringsKt.startsWith$default((String)string, (String)customArchiveName, (boolean)false, (int)2, null)) {
                            String string2 = file.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.name");
                            if (StringsKt.endsWith$default((String)string2, (String)".zip", (boolean)false, (int)2, null)) {
                                foundFile = file;
                                continue;
                            }
                        }
                    }
                    File file3 = file;
                    Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"file");
                    String string = file3.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"symbols", (boolean)false, (int)2, null)) continue;
                    String string3 = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.name");
                    if (!StringsKt.endsWith$default((String)string3, (String)".zip", (boolean)false, (int)2, null)) continue;
                    String string4 = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"file.name");
                    String string5 = defaultArchiveName;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"defaultArchiveName");
                    if (!StringsKt.startsWith$default((String)string4, (String)string5, (boolean)false, (int)2, null)) continue;
                    foundFile = file;
                }
            }
        }
        catch (Exception ex) {
            this.logger.debug("Error searching for Unity symbols archive.", ex);
        }
        if (foundFile != null) {
            File file = foundFile;
            this.logger.debug("Found symbols archive, with path=" + (file != null ? file.getPath() : null));
        } else {
            this.logger.info("Didn't found symbols archive {path=" + exportDir + '}');
        }
        return foundFile;
    }

    private final File getUnityTempSymbolsDir(Directory projectDirectory) {
        File file;
        try {
            File file2;
            File realProjectDir;
            File file3 = projectDirectory.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"projectDirectory.asFile");
            File file4 = realProjectDir = file3.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"realProjectDir");
            File symbolsDir = Paths.get(file4.getPath(), "StagingArea", "symbols").toFile();
            StringBuilder stringBuilder = new StringBuilder().append("Attempting to find symbols in Unity temp build directory ").append("{at projectPath=").append(realProjectDir.getPath()).append(", path=");
            File file5 = symbolsDir;
            Intrinsics.checkNotNullExpressionValue((Object)file5, (String)"symbolsDir");
            this.logger.debug(stringBuilder.append(file5.getName()).append('}').toString());
            if (symbolsDir.exists()) {
                this.logger.info("Unity symbols found in build directory " + "{at projectPath=" + realProjectDir.getPath() + ", path=" + symbolsDir.getAbsoluteFile() + '}');
                file2 = symbolsDir;
            } else {
                this.logger.debug("symbolsDir does not exist");
                file2 = null;
            }
            file = file2;
        }
        catch (UnsupportedOperationException e) {
            file = null;
        }
        return file;
    }

    private final File getUnitySymbolsDir(Directory projectDirectory) {
        try {
            File file = projectDirectory.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"projectDirectory.asFile");
            File launcherParentDir = file.getParentFile();
            StringBuilder stringBuilder = new StringBuilder().append("Real project dir=");
            File file2 = launcherParentDir;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"launcherParentDir");
            this.logger.debug(stringBuilder.append(file2.getPath()).toString());
            File symbolsDir = Paths.get(launcherParentDir.getPath(), "unityLibrary", "symbols").toFile();
            StringBuilder stringBuilder2 = new StringBuilder().append("Attempting to find symbols in unityLibrary/symbols directory ").append("{at projectPath=").append(launcherParentDir.getPath()).append(", path=");
            File file3 = symbolsDir;
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"symbolsDir");
            this.logger.debug(stringBuilder2.append(file3.getName()).append('}').toString());
            if (symbolsDir.exists()) {
                this.logger.info("Unity symbols found in build directory " + "{at projectPath=" + launcherParentDir.getPath() + ", path=" + symbolsDir.getAbsoluteFile() + '}');
                return symbolsDir;
            }
            this.logger.debug("symbolsDir does not exist");
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
        this.logger.debug("Unity symbols dir not found");
        return null;
    }

    private final String getCustomSymbolsArchiveName(AndroidCompactedVariantData variantData, UnityConfig unityConfig) {
        String customArchiveName = null;
        if (unityConfig != null) {
            if (unityConfig.getSymbolsArchiveName() != null) {
                String string = unityConfig.getSymbolsArchiveName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unityConfig.symbolsArchiveName");
                CharSequence charSequence = string;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    customArchiveName = unityConfig.getSymbolsArchiveName();
                    this.logger.info("Using configured Unity symbols archive name " + "{archiveName=" + customArchiveName + ", variant=" + variantData.getName() + '}');
                } else {
                    this.logger.debug("Unity symbols archive name is empty");
                }
            } else {
                this.logger.debug("Unity symbols archive name is null");
            }
        } else {
            this.logger.debug("Unity config is null");
        }
        if (customArchiveName != null) {
            this.logger.debug("Custom symbols archive name=" + customArchiveName);
        } else {
            this.logger.debug("Custom symbols archive name is null");
        }
        return customArchiveName;
    }

    /*
     * Exception decompiling
     */
    private final File[] extractSoFilesFromZipFile(File objFolder, Directory buildDir, AndroidCompactedVariantData variantData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final String getUncompressedUnityFilesPath(Directory buildDir, AndroidCompactedVariantData variantData) {
        StringBuilder stringBuilder = new StringBuilder();
        File file = buildDir.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"buildDir.asFile");
        return stringBuilder.append(file.getAbsoluteFile()).append("/intermediates/embrace/unity/").append(this.getMappingFileFolder(variantData)).toString();
    }

    private final String getMappingFileFolder(AndroidCompactedVariantData variantData) {
        return StringsKt.isBlank((CharSequence)variantData.getFlavorName()) ? variantData.getBuildTypeName() : variantData.getFlavorName() + '/' + variantData.getBuildTypeName();
    }

    private UnitySymbolFilesManager(SentryLogger sentryLogger) {
        this.sentryLogger = sentryLogger;
    }

    static {
        Factory = new Factory(null);
    }

    public /* synthetic */ UnitySymbolFilesManager(SentryLogger sentryLogger, DefaultConstructorMarker $constructor_marker) {
        this(sentryLogger);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/embrace/android/gradle/swazzler/util/UnitySymbolFilesManager$Factory;", "", "()V", "INSTANCE", "Lio/embrace/android/gradle/swazzler/util/UnitySymbolFilesManager;", "of", "sentryLogger", "Lio/embrace/android/gradle/swazzler/service/sentry/SentryLogger;", "embrace-bug-shake-gradle-plugin"})
    public static final class Factory {
        @NotNull
        public final UnitySymbolFilesManager of(@NotNull SentryLogger sentryLogger) {
            Intrinsics.checkNotNullParameter((Object)sentryLogger, (String)"sentryLogger");
            if (io.embrace.android.gradle.swazzler.util.UnitySymbolFilesManager$Factory.access$getINSTANCE$li(this) == null) {
                INSTANCE = new UnitySymbolFilesManager(sentryLogger, null);
            }
            UnitySymbolFilesManager unitySymbolFilesManager = INSTANCE;
            if (unitySymbolFilesManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"INSTANCE");
            }
            return unitySymbolFilesManager;
        }

        private Factory() {
        }

        public static final /* synthetic */ UnitySymbolFilesManager access$getINSTANCE$li(Factory $this) {
            Factory factory = $this;
            return INSTANCE;
        }

        public static final /* synthetic */ void access$setINSTANCE$li(Factory $this, UnitySymbolFilesManager unitySymbolFilesManager) {
            Factory factory = $this;
            INSTANCE = unitySymbolFilesManager;
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

