/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.service.sentry;

import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildStaticData;
import io.embrace.android.gradle.swazzler.service.sentry.SentryLogger;
import io.embrace.android.gradle.swazzler.service.sentry.SentryVariantData;
import io.embrace.android.gradle.swazzler.util.AgpVersion;
import io.sentry.Sentry;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.protocol.Message;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0007H\u0016J0\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0016R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00000\u0000 \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/embrace/android/gradle/swazzler/service/sentry/DefaultSentryLogger;", "Lio/embrace/android/gradle/swazzler/service/sentry/SentryLogger;", "()V", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "addBreadcrumb", "", "message", "", "addStaticDataTags", "buildStaticData", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildStaticData;", "addTag", "key", "value", "", "close", "sendEvent", "level", "Lio/sentry/SentryLevel;", "appId", "swazzlerVersion", "variant", "sendException", "throwable", "", "setAppSentryTags", "apiToken", "embrace-bug-shake-gradle-plugin"})
public final class DefaultSentryLogger
implements SentryLogger {
    private final Logger<DefaultSentryLogger> logger = Logger.newLogger(DefaultSentryLogger.class);

    @Override
    public void addStaticDataTags(@NotNull BuildStaticData buildStaticData) {
        Intrinsics.checkNotNullParameter((Object)buildStaticData, (String)"buildStaticData");
        try {
            this.addTag("build_cache_enabled", buildStaticData.isBuildCacheEnabled());
            this.addTag("agp_cache_enabled", buildStaticData.isAgpCacheEnabled());
            this.addTag("config_cache_enabled", buildStaticData.isConfigCacheEnabled());
            this.addTag("gradle_command", buildStaticData.getUserGradleCommand());
            this.addTag("parallel_exec_enabled", buildStaticData.isGradleParallelExecutionEnabled());
            this.addTag("jvm_args", buildStaticData.getJvmArgs());
            this.addTag("operating_system", buildStaticData.getOperatingSystem());
            this.addTag("build_env", buildStaticData.getBuildEnvironment());
            this.addTag("jre_version", buildStaticData.getJreVersion());
            this.addTag("jdk_version", buildStaticData.getJdkVersion());
        }
        catch (Throwable exc) {
            this.logger.warn("Failed to set static data on Sentry, continuing...", exc);
        }
    }

    @Override
    public void setAppSentryTags(@NotNull String apiToken, @NotNull String appId, @NotNull String variant) {
        Intrinsics.checkNotNullParameter((Object)apiToken, (String)"apiToken");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        StringBuilder stringBuilder = new StringBuilder();
        String string = apiToken;
        int n = 0;
        int n2 = 8;
        boolean bl = false;
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String obfuscatedApiToken = stringBuilder.append(string2).append("************************").toString();
        this.addTag("api-token-" + variant, obfuscatedApiToken);
        this.addTag("app-id-" + variant, appId);
    }

    private final synchronized void addTag(String key, Object value) {
        CharSequence charSequence = key;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            Sentry.setTag((String)key, (String)String.valueOf(value));
        }
    }

    @Override
    public synchronized void addBreadcrumb(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Sentry.addBreadcrumb((String)message);
    }

    @Override
    public synchronized void sendException(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        try {
            Intrinsics.checkNotNullExpressionValue((Object)Sentry.captureException((Throwable)throwable), (String)"Sentry.captureException(throwable)");
        }
        catch (Exception e) {
            this.logger.error("An exception was thrown by the Sentry client while attempting to send an exception.", e);
        }
    }

    @Override
    public void sendEvent(@NotNull SentryLevel level, @NotNull String message, @NotNull String appId, @NotNull String swazzlerVersion, @NotNull String variant) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)swazzlerVersion, (String)"swazzlerVersion");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        SentryEvent event = new SentryEvent();
        Message eventMessage = new Message();
        eventMessage.setMessage(message);
        event.setMessage(eventMessage);
        event.setLevel(level);
        event.setTag("app-id", appId);
        event.setTag("swazzle-version", swazzlerVersion);
        event.setTag("variant", variant);
        Sentry.captureEvent((SentryEvent)event);
    }

    @Override
    public void close() {
        Sentry.close();
    }

    public DefaultSentryLogger() {
        Sentry.init((Sentry.OptionsConfiguration)1.INSTANCE);
        this.addTag("gradle-version", GradleVersion.current());
        this.addTag("android-gradle-plugin-version", AgpVersion.CURRENT.INSTANCE.getVersion().toString());
    }

    @Override
    public void activateVariant(@Nullable SentryVariantData sentryVariantData) {
        SentryLogger.DefaultImpls.activateVariant(this, sentryVariantData);
    }
}

