/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.util;

import com.android.build.gradle.AppExtension;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.config.unity.UnitySymbolsDir;
import io.embrace.android.gradle.swazzler.plugin.extension.SwazzlerExtension;
import io.embrace.android.gradle.swazzler.util.ProjectType;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\u0012\u0010\u0011\u001a\u00020\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00000\u0000 \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/embrace/android/gradle/swazzler/util/ProjectTypeVerifier;", "", "()V", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "getProjectType", "Lio/embrace/android/gradle/swazzler/util/ProjectType;", "unitySymbolsDir", "Lio/embrace/android/gradle/swazzler/config/unity/UnitySymbolsDir;", "androidExtension", "Lcom/android/build/gradle/AppExtension;", "swazzlerExtension", "Lio/embrace/android/gradle/swazzler/plugin/extension/SwazzlerExtension;", "isNative", "", "isReactNative", "isUnity", "usesCMake", "usesCustomNativeBuild", "usesNdkBuild", "embrace-bug-shake-gradle-plugin"})
public final class ProjectTypeVerifier {
    private static final Logger<ProjectTypeVerifier> logger;
    @NotNull
    public static final ProjectTypeVerifier INSTANCE;

    @JvmStatic
    @NotNull
    public static final ProjectType getProjectType(@Nullable UnitySymbolsDir unitySymbolsDir, @NotNull AppExtension androidExtension, @NotNull SwazzlerExtension swazzlerExtension) {
        Intrinsics.checkNotNullParameter((Object)androidExtension, (String)"androidExtension");
        Intrinsics.checkNotNullParameter((Object)swazzlerExtension, (String)"swazzlerExtension");
        return INSTANCE.isNative(androidExtension, swazzlerExtension) ? ProjectType.NATIVE : (INSTANCE.isUnity(unitySymbolsDir) ? ProjectType.UNITY : (INSTANCE.isReactNative() ? ProjectType.REACT_NATIVE : ProjectType.OTHER));
    }

    private final boolean isUnity(UnitySymbolsDir unitySymbolsDir) {
        boolean bl;
        if (unitySymbolsDir != null && unitySymbolsDir.isDirPresent()) {
            logger.info("Unity symbols detected. Register symbols upload task for Unity process started.");
            bl = true;
        } else {
            logger.debug("Unity symbols not detected");
            bl = false;
        }
        return bl;
    }

    private final boolean isNative(AppExtension androidExtension, SwazzlerExtension swazzlerExtension) {
        boolean bl;
        boolean isNative;
        boolean bl2 = isNative = this.usesCMake(androidExtension) || this.usesNdkBuild(androidExtension) || this.usesCustomNativeBuild(swazzlerExtension);
        if (isNative) {
            logger.info("Native project detected.");
            bl = true;
        } else {
            logger.debug("Native project not detected.");
            bl = false;
        }
        return bl;
    }

    private final boolean usesCustomNativeBuild(SwazzlerExtension swazzlerExtension) {
        boolean bl;
        String customSymbolsDirectory = (String)swazzlerExtension.getCustomSymbolsDirectory().get();
        CharSequence charSequence = customSymbolsDirectory;
        boolean bl2 = false;
        boolean bl3 = false;
        if (charSequence == null || charSequence.length() == 0) {
            logger.debug("Custom symbols directory was not set");
            bl = false;
        } else {
            logger.info("NDK detected. Custom symbols directory set: " + customSymbolsDirectory + '.');
            bl = true;
        }
        return bl;
    }

    private final boolean usesCMake(AppExtension androidExtension) {
        boolean bl;
        File cmakePath = androidExtension.getExternalNativeBuild().getCmake().getPath();
        if (cmakePath != null) {
            logger.info("NDK detected. Cmake file exists in path " + cmakePath.getPath() + '.');
            bl = true;
        } else {
            logger.debug("Cmake path is null. Cmake configuration doesn't exist.");
            bl = false;
        }
        return bl;
    }

    private final boolean usesNdkBuild(AppExtension androidExtension) {
        boolean bl;
        File ndkBuildPath = androidExtension.getExternalNativeBuild().getNdkBuild().getPath();
        if (ndkBuildPath != null) {
            logger.info("NDK detected. NdkBuild file exists in path " + ndkBuildPath.getPath() + '.');
            bl = true;
        } else {
            logger.debug("NdkBuild path is null. Cmake configuration doesn't exist.");
            bl = false;
        }
        return bl;
    }

    private final boolean isReactNative() {
        return false;
    }

    private ProjectTypeVerifier() {
    }

    static {
        ProjectTypeVerifier projectTypeVerifier;
        INSTANCE = projectTypeVerifier = new ProjectTypeVerifier();
        logger = Logger.newLogger(ProjectTypeVerifier.class);
    }
}

