/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.instrumentation;

import com.android.build.api.instrumentation.FramesComputationMode;
import com.android.build.api.instrumentation.InstrumentationScope;
import com.android.build.api.variant.Variant;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.compile.swazzler.SwazzleFilter;
import io.embrace.android.gradle.swazzler.instrumentation.AsmCompatibilityHelper;
import io.embrace.android.gradle.swazzler.instrumentation.AsmTasks;
import io.embrace.android.gradle.swazzler.instrumentation.SwazzleParams;
import io.embrace.android.gradle.swazzler.instrumentation.TransformClassesWithReflectionException;
import io.embrace.android.gradle.swazzler.plugin.ProjectPropertiesKt;
import io.embrace.android.gradle.swazzler.plugin.extension.SwazzlerExtension;
import io.embrace.android.gradle.swazzler.plugin.knownissues.KnownIssuesBuildService;
import io.embrace.android.gradle.swazzler.plugin.knownissues.KnownIssuesBuildServiceKt;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"registerAsmTasks", "", "project", "Lorg/gradle/api/Project;", "swazzlerExtension", "Lio/embrace/android/gradle/swazzler/plugin/extension/SwazzlerExtension;", "embrace-bug-shake-gradle-plugin"})
@JvmName(name="AsmTasks")
public final class AsmTasks {
    public static final void registerAsmTasks(@NotNull Project project, @NotNull SwazzlerExtension swazzlerExtension) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)swazzlerExtension, (String)"swazzlerExtension");
        InstrumentationScope instrumentationScope = ProjectPropertiesKt.getInstrumentationScope(project);
        if (instrumentationScope == null) {
            instrumentationScope = InstrumentationScope.ALL;
        }
        InstrumentationScope scope = instrumentationScope;
        project.getLogger().debug("ASM scope=" + scope.name());
        AsmCompatibilityHelper.INSTANCE.registerAsmFactory(project, (Action<Variant>)((Action)new Action<Variant>(project, scope, swazzlerExtension){
            final /* synthetic */ Project $project;
            final /* synthetic */ InstrumentationScope $scope;
            final /* synthetic */ SwazzlerExtension $swazzlerExtension;

            public final void execute(Variant variant) {
                Logger logger = this.$project.getLogger();
                StringBuilder stringBuilder = new StringBuilder().append("Registered ASM task for ");
                Variant variant2 = variant;
                Intrinsics.checkNotNullExpressionValue((Object)variant2, (String)"variant");
                logger.info(stringBuilder.append(variant2.getName()).append(" with scope=").append(this.$scope.name()).toString());
                AsmCompatibilityHelper.INSTANCE.setAsmFramesComputationMode(variant, FramesComputationMode.COMPUTE_FRAMES_FOR_INSTRUMENTED_METHODS);
                this.$project.getLogger().debug("Asm frames computation mode successfully set " + "to=" + FramesComputationMode.COMPUTE_FRAMES_FOR_INSTRUMENTED_METHODS);
                try {
                    AsmCompatibilityHelper.INSTANCE.transformClassesWith(variant, this.$scope, this.$project, (Function1<? super SwazzleParams, Unit>)((Function1)new Function1<SwazzleParams, Unit>(this, variant){
                        final /* synthetic */ registerAsmTasks.1 this$0;
                        final /* synthetic */ Variant $variant;

                        public final void invoke(@NotNull SwazzleParams params) {
                            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                            this.this$0.$project.getLogger().debug("Configuring ASM instrumentation");
                            params.getLogLevel().set(this.this$0.$project.provider((Callable)new Callable<Logger.EmbraceLogLevel>(this){
                                final /* synthetic */ registerAsmTasks.1 this$0;

                                public final Logger.EmbraceLogLevel call() {
                                    String str = ProjectPropertiesKt.getLogLevel(this.this$0.this$0.$project);
                                    Logger.EmbraceLogLevel embraceLogLevel = Logger.EmbraceLogLevel.forName(str);
                                    if (embraceLogLevel == null) {
                                        Logger.EmbraceLogLevel embraceLogLevel2 = Logger.EmbraceLogLevel.DEFAULT;
                                        boolean bl = false;
                                        boolean bl2 = false;
                                        Logger.EmbraceLogLevel $this$apply = embraceLogLevel2;
                                        boolean bl3 = false;
                                        this.this$0.this$0.$project.getLogger().debug("ASM config logLevel: " + $this$apply.name());
                                        embraceLogLevel = embraceLogLevel2;
                                    }
                                    return embraceLogLevel;
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            }));
                            params.getDisabled().set(this.this$0.$project.provider((Callable)new Callable<Boolean>(this){
                                final /* synthetic */ registerAsmTasks.1 this$0;

                                public final Boolean call() {
                                    SwazzlerExtension swazzlerExtension = this.this$0.this$0.$swazzlerExtension;
                                    Variant variant = this.this$0.$variant;
                                    Intrinsics.checkNotNullExpressionValue((Object)variant, (String)"variant");
                                    boolean swazzlingDisabled = swazzlerExtension.isSwazzlingDisabled(variant.getName());
                                    Logger logger = this.this$0.this$0.$project.getLogger();
                                    String string = swazzlingDisabled ? "disabled" : "enabled";
                                    Variant variant2 = this.this$0.$variant;
                                    Intrinsics.checkNotNullExpressionValue((Object)variant2, (String)"variant");
                                    logger.debug("Swazzling %s for variant=%s", (Object)string, (Object)variant2.getName());
                                    return swazzlingDisabled;
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            }));
                            params.getSwazzleFilter().set(this.this$0.$swazzlerExtension.getClassSkipList().map((Transformer)new Transformer<SwazzleFilter, List<String>>(this){
                                final /* synthetic */ registerAsmTasks.1 this$0;

                                public final SwazzleFilter transform(List<String> it) {
                                    List<String> list = it;
                                    Intrinsics.checkNotNullExpressionValue(list, (String)"it");
                                    SwazzleFilter swazzleFilter = new SwazzleFilter(list, SwazzleFilter.Kind.CLASS);
                                    boolean bl = false;
                                    boolean bl2 = false;
                                    SwazzleFilter swazzleFilter2 = swazzleFilter;
                                    boolean bl3 = false;
                                    this.this$0.this$0.$project.getLogger().debug("ASM config classSkipList: " + CollectionsKt.joinToString$default((Iterable)swazzleFilter2.getSkipList$embrace_bug_shake_gradle_plugin(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
                                    return swazzleFilter;
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            }));
                            params.getInvalidate().set(this.this$0.$swazzlerExtension.getForceIncrementalOverwrite().map((Transformer)new Transformer<Long, Boolean>(this){
                                final /* synthetic */ registerAsmTasks.1 this$0;

                                public final Long transform(Boolean invalidate) {
                                    this.this$0.this$0.$project.getLogger().debug("ASM config invalidate: " + invalidate);
                                    Boolean bl = invalidate;
                                    Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"invalidate");
                                    return bl != false ? System.currentTimeMillis() : -1L;
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            }));
                            params.getShouldInstrumentFirebaseMessaging().set((Provider)this.this$0.$swazzlerExtension.getInstrumentFirebaseMessaging());
                            params.getShouldInstrumentWebview().set((Provider)this.this$0.$swazzlerExtension.getInstrumentWebview());
                            params.getShouldInstrumentOkHttp().set((Provider)this.this$0.$swazzlerExtension.getInstrumentOkHttp());
                            params.getShouldInstrumentOnLongClick().set((Provider)this.this$0.$swazzlerExtension.getInstrumentOnLongClick());
                            params.getShouldInstrumentOnClick().set((Provider)this.this$0.$swazzlerExtension.getInstrumentOnClick());
                        }
                        {
                            this.this$0 = var1_1;
                            this.$variant = variant;
                            super(1);
                        }
                    }));
                    this.$project.getLogger().debug("Asm transformClassesWith successfully called.");
                    try {
                        KnownIssuesBuildServiceKt.registerKnownIssueBuildService(this.$project, KnownIssuesBuildService.KnownIssueType.MOSHI);
                    }
                    catch (Throwable t) {
                        this.$project.getLogger().debug("An exception was thrown while registering for buildFinished for known issues", t);
                    }
                }
                catch (TransformClassesWithReflectionException e) {
                    this.$project.getLogger().warn("There was a reflection issue while performing ASM bytecode transformation.\nThis shouldn't affect build output.", (Throwable)e);
                }
            }
            {
                this.$project = project;
                this.$scope = instrumentationScope;
                this.$swazzlerExtension = swazzlerExtension;
            }
        }));
    }
}

