package io.embrace.android.embracesdk.config.behavior

import io.embrace.android.embracesdk.config.remote.NetworkSpanForwardingRemoteConfig

internal class NetworkSpanForwardingBehavior(
    thresholdCheck: BehaviorThresholdCheck,
    remoteSupplier: () -> NetworkSpanForwardingRemoteConfig?
) : MergedConfigBehavior<UnimplementedConfig, NetworkSpanForwardingRemoteConfig>(
    thresholdCheck,
    { null },
    remoteSupplier
) {
    companion object {
        /**
         * Header name for the W3C traceparent
         */
        const val TRACEPARENT_HEADER_NAME = "traceparent"

        private const val DEFAULT_PCT_ENABLED = 0.0f
    }

    fun isNetworkSpanForwardingEnabled(): Boolean {
        return thresholdCheck.isBehaviorEnabled(remote?.pctEnabled ?: DEFAULT_PCT_ENABLED)
    }
}
