package io.embrace.android.embracesdk.capture.screenshot

/**
 * Service for taking a screenshot of the app for a slow moment or a particular log event.
 */
internal interface ScreenshotService {

    /**
     * Take a screenshot which is associated with a particular bug report.
     *
     * @return whether the screenshot was successfully taken or not
     */
    fun takeScreenshotBugReport(): Boolean

    /**
     * Get a cached screenshot to be attached to a bug report, if it exists
     */
    fun getScreenshotBugReport(): ByteArray?

    /**
     * Delete a cached screenshot if present
     */
    fun deleteScreenshotBugReport()
}
