package io.embrace.android.embracesdk.bugshake

import android.app.Activity
import android.graphics.BitmapFactory
import android.os.Bundle
import android.widget.ImageView
import io.embrace.android.embracesdk.Embrace
import io.embrace.android.embracesdk.R

internal class EmbraceScreenshotActivity : Activity() {

    private lateinit var preview: ImageView

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.embrace_screenshot_activity)

        val close = findViewById<ImageView>(R.id.embrace_bugshake_close)
        close.setOnClickListener {
            finish()
        }

        val screenshot = Embrace.getInstance().getScreenshot()
        screenshot?.let {
            preview = findViewById(R.id.embrace_bugshake_full_screenshot)
            try {
                val bitmap = BitmapFactory.decodeByteArray(screenshot, 0, screenshot.size)
                preview.setImageBitmap(bitmap)
            } catch (ex: Throwable) {
                Embrace.getInstance().logInternalError(ex)
            }
        }
    }
}
