package io.embrace.android.embracesdk.bugshake

import android.content.Intent
import io.embrace.android.embracesdk.Embrace
import io.embrace.android.embracesdk.session.ActivityService
import io.embrace.android.embracesdk.utils.UnityUtils

internal class EmbraceBugShakeService(val activityService: ActivityService, val isUnity: Boolean) : BugShakeService {

    private var shakeListener: ShakeListener = object : ShakeListener {
        override fun onShake() {
            Embrace.getInstance().showBugReportForm()
        }
    }

    override fun showBugReportForm() {
        var currentActivity = activityService.foregroundActivity
        if (currentActivity == null && isUnity) {
            // Since Unity apps start the SDK while already in the foreground,
            // on a cold start activityService will not have a reference to
            // the foreground activity
            currentActivity = UnityUtils.getUnityActivity()
        }
        currentActivity?.let { activity ->
            val intent = Intent(activity, EmbraceBugShakeActivity::class.java)
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
            activity.startActivity(intent)
        }
    }

    override fun setShakeListener(listener: ShakeListener?) {
        listener?.let {
            shakeListener = listener
        }
    }

    override fun getShakeListener() = shakeListener
}
