package io.embrace.android.embracesdk.bugshake

import android.app.Activity
import android.app.Application.ActivityLifecycleCallbacks
import android.content.Context
import android.hardware.Sensor
import android.hardware.SensorEventListener
import android.hardware.SensorManager
import android.os.Bundle
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger
import java.lang.ref.WeakReference

internal class ShakeActivityListener(val bugShakeService: BugShakeService) :
    ActivityLifecycleCallbacks by NoOpActivityLifecycleCallbacks() {

    private var sensorListener: SensorEventListener? = null
    private var sensorManagerRef: WeakReference<SensorManager>? = null

    override fun onActivityResumed(activity: Activity) {
        try {
            registerListener(activity)
        } catch (ex: Throwable) {
            InternalStaticEmbraceLogger.logError("Could not add shake listener to activity", ex)
        }
    }

    override fun onActivityPaused(activity: Activity) {
        try {
            unregisterListener(activity)
        } catch (ex: Throwable) {
            InternalStaticEmbraceLogger.logError("Could not remove shake listener from activity", ex)
        }
    }

    private fun registerListener(activity: Activity) {
        val sensorManager = activity.getSystemService(Context.SENSOR_SERVICE) as SensorManager?

        sensorManager?.let { sensor ->
            sensorManagerRef = WeakReference(sensor)

            sensorListener = EmbraceGestureListener(bugShakeService)
            sensor.registerListener(
                sensorListener,
                sensorManager.getDefaultSensor(Sensor.TYPE_ACCELEROMETER),
                SensorManager.SENSOR_DELAY_NORMAL
            )
        }
    }

    private fun unregisterListener(activity: Activity) {
        sensorListener?.let { listener ->
            sensorManagerRef?.get()?.let { sensor ->
                sensor.unregisterListener(listener)
                return
            }
            val sensorManager = activity.getSystemService(Context.SENSOR_SERVICE) as SensorManager?
            sensorManager?.unregisterListener(listener)
        }
    }
}

internal class NoOpActivityLifecycleCallbacks : ActivityLifecycleCallbacks {
    override fun onActivityCreated(p0: Activity, p1: Bundle?) {
        // no op
    }

    override fun onActivityStarted(p0: Activity) {
        // no op
    }

    override fun onActivityResumed(p0: Activity) {
        // no op
    }

    override fun onActivityPaused(p0: Activity) {
        // no op
    }

    override fun onActivityStopped(p0: Activity) {
        // no op
    }

    override fun onActivitySaveInstanceState(p0: Activity, p1: Bundle) {
        // no op
    }

    override fun onActivityDestroyed(p0: Activity) {
        // no op
    }
}
