package io.embrace.android.embracesdk

import io.embrace.android.embracesdk.Embrace.BugReportCategory

/**
 * The public API for the Bug Shake functionality
 */
internal interface BugShakeApi {

    /**
     * Logs a bug report. The report will be send immediately, the same as a log
     *
     * @type Type of the report (one of bug, question or suggestion)
     * @report Text of the report as filled by the end user
     */
    fun logBugReport(type: BugReportCategory, report: String)

    /**
     * Show an activity that allows the end user to fill out and send a bug report.
     *
     */
    fun showBugReportForm()

    /**
     * Get the contents of the screenshot taken when the device was shaken
     */
    fun getScreenshot(): ByteArray?

    /**
     * Delete the stored screenshot if it exists
     */
    fun deleteScreenshot()
}
