package io.embrace.android.embracesdk.injection

import io.embrace.android.embracesdk.bugshake.BugShakeService
import io.embrace.android.embracesdk.bugshake.EmbraceBugShakeService
import io.embrace.android.embracesdk.session.ActivityService

internal interface BugShakeModule {
    val bugShakeService: BugShakeService
}

internal class BugShakeModuleImpl(
    activityService: ActivityService
) : BugShakeModule {

    override val bugShakeService by singleton {
        EmbraceBugShakeService(activityService)
    }
}
