package io.embrace.android.embracesdk.config.behavior

import io.embrace.android.embracesdk.config.local.BugShakeLocalConfig
import io.embrace.android.embracesdk.config.remote.BugShakeRemoteConfig

internal class BugShakeBehavior(
    thresholdCheck: BehaviorThresholdCheck,
    localSupplier: () -> BugShakeLocalConfig?,
    remoteSupplier: () -> BugShakeRemoteConfig?
) : MergedConfigBehavior<BugShakeLocalConfig, BugShakeRemoteConfig>(
    thresholdCheck,
    localSupplier,
    remoteSupplier
) {

    companion object {
        /**
         * By default, only send sessions containing bug reports or crashes
         */
        const val DEFAULT_PCT_SEND_ALL_DATA = 0.0f
        const val DEFAULT_PCT_ENABLED = 100.0f
        const val DEFAULT_SHAKE_DETECT_ENABLED = true
    }

    /**
     * Controls whether to whole bug shaking feature is enabled
     */
    fun isBugShakeEnabled(): Boolean {
        local?.reportEnabled?.let {
            return it
        }
        return thresholdCheck.isBehaviorEnabled(remote?.pctEnabled ?: DEFAULT_PCT_ENABLED)
    }

    /**
     * Controls whether to listen for shake gestures
     */
    fun isShakeDetectEnabled(): Boolean {
        local?.shakeDetectEnabled?.let {
            return it
        }
        return DEFAULT_SHAKE_DETECT_ENABLED
    }

    /**
     * If disabled, only sessions with an associated bug report will be sent
     */
    fun sendAllData(): Boolean {
        local?.sendAllData?.let {
            return it
        }
        return thresholdCheck.isBehaviorEnabled(remote?.pctSendAllData ?: DEFAULT_PCT_SEND_ALL_DATA)
    }
}
