package io.embrace.android.embracesdk.bugshake

import android.content.Intent
import io.embrace.android.embracesdk.session.ActivityService

internal class EmbraceBugShakeService(val activityService: ActivityService) : BugShakeService {

    override fun showBugReportForm() {
        val currentActivity = activityService.foregroundActivity
        currentActivity?.let { activity ->
            val intent = Intent(activity, EmbraceBugShakeActivity::class.java)
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
            activity.startActivity(intent)
        }
    }
}
