/*
 * Decompiled with CFR 0.152.
 */
package io.easywalk.simply.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.persistence.AttributeConverter;

public class JsonConverter
implements AttributeConverter<Object, String> {
    private static final ObjectMapper om = new ObjectMapper();

    public String convertToDatabaseColumn(Object attribute) {
        try {
            return om.writeValueAsString(attribute);
        }
        catch (JsonProcessingException ex) {
            return null;
        }
    }

    public Object convertToEntityAttribute(String dbData) {
        try {
            return om.readValue(dbData, Object.class);
        }
        catch (IOException ex) {
            return null;
        }
    }
}

