/*
 * Decompiled with CFR 0.152.
 */
package io.easywalk.simply.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;

public class GsonTools {
    public static void extendJsonObject(JsonObject destinationObject, ConflictStrategy conflictResolutionStrategy, ArrayStrategy arrayStrategy, JsonObject ... objs) throws JsonObjectExtensionConflictException {
        for (JsonObject obj : objs) {
            GsonTools.extendJsonObject(destinationObject, obj, conflictResolutionStrategy, arrayStrategy);
        }
    }

    private static void extendJsonObject(JsonObject leftObj, JsonObject rightObj, ConflictStrategy conflictStrategy, ArrayStrategy arrayStrategy) throws JsonObjectExtensionConflictException {
        for (Map.Entry rightEntry : rightObj.entrySet()) {
            String rightKey = (String)rightEntry.getKey();
            JsonElement rightVal = (JsonElement)rightEntry.getValue();
            if (leftObj.has(rightKey)) {
                JsonElement leftVal = leftObj.get(rightKey);
                if (leftVal.isJsonArray() && rightVal.isJsonArray()) {
                    if (arrayStrategy == ArrayStrategy.REPLACE) {
                        leftObj.remove(rightKey);
                        leftObj.add(rightKey, rightVal);
                        continue;
                    }
                    JsonArray leftArr = leftVal.getAsJsonArray();
                    JsonArray rightArr = rightVal.getAsJsonArray();
                    for (int i = 0; i < rightArr.size(); ++i) {
                        leftArr.add(rightArr.get(i));
                    }
                    continue;
                }
                if (leftVal.isJsonObject() && rightVal.isJsonObject()) {
                    GsonTools.extendJsonObject(leftVal.getAsJsonObject(), rightVal.getAsJsonObject(), conflictStrategy, arrayStrategy);
                    continue;
                }
                GsonTools.handleMergeConflict(rightKey, leftObj, leftVal, rightVal, conflictStrategy);
                continue;
            }
            leftObj.add(rightKey, rightVal);
        }
    }

    private static void handleMergeConflict(String key, JsonObject leftObj, JsonElement leftVal, JsonElement rightVal, ConflictStrategy conflictStrategy) throws JsonObjectExtensionConflictException {
        switch (conflictStrategy) {
            case PREFER_FIRST_OBJ: {
                break;
            }
            case PREFER_SECOND_OBJ: {
                leftObj.add(key, rightVal);
                break;
            }
            case PREFER_NON_NULL: {
                if (!leftVal.isJsonNull() || rightVal.isJsonNull()) break;
                leftObj.add(key, rightVal);
                break;
            }
            case THROW_EXCEPTION: {
                throw new JsonObjectExtensionConflictException("Key " + key + " exists in both objects and the conflict resolution strategy is " + conflictStrategy);
            }
            default: {
                throw new UnsupportedOperationException("The conflict strategy " + conflictStrategy + " is unknown and cannot be processed");
            }
        }
    }

    public static <T> T merge(T obj, Map<String, Object> fields) throws JsonObjectExtensionConflictException {
        Gson gson = new GsonBuilder().create();
        JsonObject target = gson.toJsonTree(obj).getAsJsonObject();
        JsonObject patch = gson.toJsonTree(fields).getAsJsonObject();
        GsonTools.extendJsonObject(target, ConflictStrategy.PREFER_SECOND_OBJ, ArrayStrategy.REPLACE, patch);
        return (T)gson.fromJson(target.toString(), obj.getClass());
    }

    public static class JsonObjectExtensionConflictException
    extends Exception {
        public JsonObjectExtensionConflictException(String message) {
            super(message);
        }
    }

    public static enum ArrayStrategy {
        MERGE,
        REPLACE;

    }

    public static enum ConflictStrategy {
        THROW_EXCEPTION,
        PREFER_FIRST_OBJ,
        PREFER_SECOND_OBJ,
        PREFER_NON_NULL;

    }
}

