/*
 * Decompiled with CFR 0.152.
 */
package io.easywalk.simply.serviceable;

import io.easywalk.simply.specification.SimplySpec;
import io.easywalk.simply.specification.eventable.annotations.SimplyProducer;
import io.easywalk.simply.specification.eventable.annotations.SimplyProducerId;
import io.easywalk.simply.specification.serviceable.annotations.SimplyEntity;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import org.springframework.beans.BeanUtils;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.jpa.repository.JpaRepository;

public abstract class AbstractServiceable<T extends SimplyEntity, ID>
implements SimplySpec<T, ID> {
    protected final JpaRepository<T, ID> repository;

    protected AbstractServiceable(JpaRepository<T, ID> repository) {
        this.repository = repository;
    }

    @SimplyProducer(value="CREATE")
    public T create(T entity) throws EntityExistsException, DataIntegrityViolationException {
        return (T)((SimplyEntity)this.repository.save(entity));
    }

    public T get(ID id) throws NoSuchElementException {
        return (T)((SimplyEntity)this.repository.findById(id).orElseThrow(() -> new NoSuchElementException("entityid=" + id)));
    }

    @SimplyProducer(value="UPDATE")
    public T updateById(@SimplyProducerId ID id, Map<String, Object> fields) throws Throwable {
        Object target = this.get(id);
        fields.forEach((key, value) -> {
            try {
                target.getClass().getDeclaredMethod("set" + key.substring(0, 1).toUpperCase() + key.substring(1), value.getClass()).invoke(target, value);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        });
        return (T)((SimplyEntity)this.repository.save(target));
    }

    @SimplyProducer(value="DELETE")
    public void deleteById(@SimplyProducerId ID id) {
        Optional byId = this.repository.findById(id);
        byId.ifPresent(arg_0 -> this.repository.delete(arg_0));
    }

    @SimplyProducer(value="DELETE")
    public void delete(T entity) {
        Optional byId = this.repository.findById(entity.getId());
        byId.ifPresent(arg_0 -> this.repository.delete(arg_0));
    }

    @SimplyProducer(value="UPDATE")
    public T replaceById(@SimplyProducerId ID id, T replace) throws EntityNotFoundException {
        T retrieved = this.get(id);
        BeanUtils.copyProperties(replace, retrieved, (String[])new String[]{"id"});
        return (T)((SimplyEntity)this.repository.save(retrieved));
    }

    public List<T> getAll() {
        return this.repository.findAll();
    }
}

