/*
 * Decompiled with CFR 0.152.
 */
package io.easywalk.simply.eventable.kafka.config;

import io.easywalk.simply.eventable.kafka.SimplyEventableMessage;
import io.easywalk.simply.specification.eventable.annotations.SimplyProducerService;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.serialization.StringSerializer;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.support.serializer.JsonSerializer;

@Configuration
public class KafkaProducerConfig {
    private static final Logger log = LoggerFactory.getLogger(KafkaProducerConfig.class);
    private final BeanFactory beanFactory;
    private final KafkaProperties kafkaProperties;
    private Map<Class, String> topics = new HashMap<Class, String>();
    @Value(value="${simply.eventable.entity-base-package}")
    private String basePackage;
    @Value(value="${simply.eventable.topic-property.number-of-partitions:1}")
    private Integer numPartitions;
    @Value(value="${simply.eventable.topic-property.number-of-replicas:1}")
    private Short numReplicas;

    @PostConstruct
    public void initialize() {
        this.createTopics();
        log.info("KafkaProducerConfig initiated");
    }

    private void createTopics() {
        Reflections reflections = new Reflections(this.basePackage, new Scanner[0]);
        Set subTypesOf = reflections.getTypesAnnotatedWith(SimplyProducerService.class);
        ConfigurableBeanFactory factory = (ConfigurableBeanFactory)this.beanFactory;
        subTypesOf.stream().forEach(item -> {
            this.topics.put((Class)item, item.getName());
            SimplyProducerService annotation = item.getAnnotation(SimplyProducerService.class);
            NewTopic newTopic = new NewTopic(annotation.value(), this.numPartitions.intValue(), this.numReplicas.shortValue());
            factory.registerSingleton(item.getName() + "topic", (Object)newTopic);
            log.info("Topic created {} : {} : {}", new Object[]{item.getName(), this.numPartitions, this.numReplicas});
        });
    }

    @Bean(value={"eventableProducerFactory"})
    public ProducerFactory<String, SimplyEventableMessage> eventableProducerFactory() {
        HashMap<String, Object> configProps = new HashMap<String, Object>();
        configProps.put("bootstrap.servers", this.kafkaProperties.getBootstrapServers());
        configProps.put("key.serializer", StringSerializer.class);
        configProps.put("value.serializer", JsonSerializer.class);
        return new DefaultKafkaProducerFactory(configProps);
    }

    @Bean(value={"eventableEntityKafkaTemplate"})
    public KafkaTemplate<String, SimplyEventableMessage> eventableEntityKafkaTemplate() {
        return new KafkaTemplate(this.eventableProducerFactory());
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public KafkaProperties getKafkaProperties() {
        return this.kafkaProperties;
    }

    public Map<Class, String> getTopics() {
        return this.topics;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public Integer getNumPartitions() {
        return this.numPartitions;
    }

    public Short getNumReplicas() {
        return this.numReplicas;
    }

    public KafkaProducerConfig(BeanFactory beanFactory, KafkaProperties kafkaProperties) {
        this.beanFactory = beanFactory;
        this.kafkaProperties = kafkaProperties;
    }
}

