/*
 * Decompiled with CFR 0.152.
 */
package io.easywalk.simply.eventable.kafka;

import javax.annotation.PostConstruct;
import lombok.NonNull;

public class SimplyEventableMessage<T> {
    @NonNull
    private String key;
    @NonNull
    private String eventType;
    private String payloadType;
    private T payload;

    @PostConstruct
    private void init() {
        this.payloadType = this.payload.getClass().getName();
    }

    @NonNull
    public String getKey() {
        return this.key;
    }

    @NonNull
    public String getEventType() {
        return this.eventType;
    }

    public String getPayloadType() {
        return this.payloadType;
    }

    public T getPayload() {
        return this.payload;
    }

    public void setKey(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.key = key;
    }

    public void setEventType(@NonNull String eventType) {
        if (eventType == null) {
            throw new NullPointerException("eventType is marked non-null but is null");
        }
        this.eventType = eventType;
    }

    public void setPayloadType(String payloadType) {
        this.payloadType = payloadType;
    }

    public void setPayload(T payload) {
        this.payload = payload;
    }

    public String toString() {
        return "SimplyEventableMessage(key=" + this.getKey() + ", eventType=" + this.getEventType() + ", payloadType=" + this.getPayloadType() + ", payload=" + this.getPayload() + ")";
    }

    public SimplyEventableMessage() {
    }

    public SimplyEventableMessage(@NonNull String key, @NonNull String eventType, String payloadType, T payload) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (eventType == null) {
            throw new NullPointerException("eventType is marked non-null but is null");
        }
        this.key = key;
        this.eventType = eventType;
        this.payloadType = payloadType;
        this.payload = payload;
    }
}

