/*
 * Decompiled with CFR 0.152.
 */
package io.easywalk.simply.eventable.kafka.producer;

import io.easywalk.simply.eventable.kafka.SimplyEventableMessage;
import io.easywalk.simply.eventable.kafka.config.KafkaProducerConfig;
import io.easywalk.simply.specification.eventable.annotations.SimplyProducer;
import io.easywalk.simply.specification.eventable.annotations.SimplyProducerService;
import io.easywalk.simply.specification.serviceable.annotations.SimplyEntity;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.annotation.PostConstruct;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Component;

@EnableAsync
@Aspect
@Component
public class ProducibleAspect {
    private static final Logger log = LoggerFactory.getLogger(ProducibleAspect.class);
    private final KafkaProducerConfig kafkaConfig;
    private final KafkaTemplate kafkaTemplate;

    public ProducibleAspect(KafkaProducerConfig kafkaConfig, @Qualifier(value="eventableEntityKafkaTemplate") KafkaTemplate kafkaTemplate) {
        this.kafkaConfig = kafkaConfig;
        this.kafkaTemplate = kafkaTemplate;
    }

    private static Class<?> getEntity(Object target) {
        Type clazzes = ProducibleAspect.getGenericType(target.getClass())[0];
        return ProducibleAspect.getClass(((ParameterizedType)clazzes).getActualTypeArguments()[0]);
    }

    private static Type[] getGenericType(Class<?> target) {
        if (target == null) {
            return new Type[0];
        }
        Type[] types = target.getGenericInterfaces();
        if (types.length > 0) {
            return types;
        }
        Type type = target.getGenericSuperclass();
        if (type != null && type instanceof ParameterizedType) {
            return new Type[]{type};
        }
        return new Type[0];
    }

    private static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ProducibleAspect.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = ProducibleAspect.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    @PostConstruct
    private void init() {
        log.info("ProducibleAspect initiated");
    }

    private boolean isValid(SimplyEntity entity) {
        if (entity == null) {
            log.error("Entity could not be published (entity is null)");
            return true;
        }
        return false;
    }

    private String getTopic(JoinPoint call) {
        return call.getTarget().getClass().getAnnotation(SimplyProducerService.class).value();
    }

    private String getEventType(JoinPoint call) {
        MethodSignature signature = (MethodSignature)call.getSignature();
        Method method = signature.getMethod();
        return method.getAnnotation(SimplyProducer.class).value();
    }

    @Pointcut(value="@annotation(io.easywalk.simply.specification.eventable.annotations.SimplyProducer) && @target(io.easywalk.simply.specification.eventable.annotations.SimplyProducerService)")
    public void producibleAnnotations() {
    }

    @AfterReturning(value="producibleAnnotations() && execution(* *(..))", returning="entity")
    private void publishCreate(JoinPoint call, SimplyEntity entity) throws RuntimeException {
        if (entity == null) {
            return;
        }
        this.publish(this.getTopic(call), this.getEventType(call), entity.getId().toString(), entity);
    }

    @AfterReturning(value="producibleAnnotations() && execution(void *(..)) && args(entity)")
    private void publish(JoinPoint call, SimplyEntity entity) throws RuntimeException {
        SimplyProducer caller = this.getSimplyProducer(call);
        this.publish(this.getTopic(call), this.getEventType(call), entity.getId().toString(), null);
    }

    @AfterReturning(value="producibleAnnotations() && execution(void *(.., @io.easywalk.simply.specification.eventable.annotations.SimplyProducerId (*), ..)) && args(id)")
    private void publish(JoinPoint call, Object id) throws RuntimeException {
        SimplyProducer caller = this.getSimplyProducer(call);
        this.publish(this.getTopic(call), this.getEventType(call), id.toString(), null);
    }

    @AfterReturning(value="producibleAnnotations() && execution(* *(.., @io.easywalk.simply.specification.eventable.annotations.SimplyProducerId (*), ..)) && args(id)", returning="entity")
    private void publish(JoinPoint call, Object id, SimplyEntity entity) throws RuntimeException {
        this.publish(this.getTopic(call), this.getEventType(call), id.toString(), entity);
    }

    private SimplyProducer getSimplyProducer(JoinPoint call) {
        MethodSignature signature = (MethodSignature)call.getSignature();
        Method method = signature.getMethod();
        return method.getAnnotation(SimplyProducer.class);
    }

    public void publish(String topic, String type, String key, SimplyEntity entity) {
        SimplyEventableMessage<Object> message = null;
        message = entity == null ? new SimplyEventableMessage<Object>(key, type, null, null) : new SimplyEventableMessage<SimplyEntity>(key, type, entity.getClass().getName(), entity);
        log.info("[PUB] {} {}", (Object)topic, message);
        this.kafkaTemplate.send(topic, Integer.valueOf(Math.abs(key.hashCode() % this.kafkaConfig.getNumPartitions())), (Object)key, message);
    }
}

