/*
 * Decompiled with CFR 0.152.
 */
package io.easywalk.simply.controllable;

import io.easywalk.simply.controllable.SimplyControllableResponse;
import io.easywalk.simply.controllable.SimplyErrorResponse;
import io.easywalk.simply.utils.GsonTools;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@RestControllerAdvice(annotations={SimplyControllableResponse.class})
public class SimplyControllableAdvice {
    private static final Logger log = LoggerFactory.getLogger(SimplyControllableAdvice.class);

    @ExceptionHandler(value={EntityExistsException.class})
    public ResponseEntity<SimplyErrorResponse> handle(EntityExistsException e) {
        return this.responseError((Throwable)e, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={EntityNotFoundException.class})
    public ResponseEntity<SimplyErrorResponse> handle(EntityNotFoundException e) {
        return this.responseError((Throwable)e, HttpStatus.NO_CONTENT);
    }

    @ExceptionHandler(value={NoSuchElementException.class})
    public ResponseEntity<SimplyErrorResponse> handle(NoSuchElementException e) {
        return this.responseError(e, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    public ResponseEntity<SimplyErrorResponse> handle(DataIntegrityViolationException e) {
        return this.responseError((Throwable)e, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<SimplyErrorResponse> handle(MethodArgumentNotValidException e) {
        Object message = e.getFieldErrors().stream().map(field -> field.getField()).collect(Collectors.joining(","));
        message = (String)message + " is invalid";
        return this.responseError((Throwable)e, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<SimplyErrorResponse> handle(Exception e) {
        return this.responseError(e, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={GsonTools.JsonObjectExtensionConflictException.class})
    public ResponseEntity<SimplyErrorResponse> handle(GsonTools.JsonObjectExtensionConflictException e) {
        return this.responseError((Throwable)e, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private ResponseEntity<SimplyErrorResponse> responseError(Throwable exception, HttpStatus status) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        log.info("[ERR] {} {} Param:{}, Response:{} {}", new Object[]{request.getMethod(), request.getRequestURI(), request.getQueryString(), status, exception.getMessage()});
        return ResponseEntity.status((HttpStatus)status).body((Object)new SimplyErrorResponse(exception.getClass().getName(), exception.getMessage()));
    }
}

