/*
 * Decompiled with CFR 0.152.
 */
package io.easywalk.simply.controllable;

import io.easywalk.simply.controllable.SimplyLogging;
import io.easywalk.simply.serviceable.AbstractServiceable;
import io.easywalk.simply.specification.SimplySpec;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.persistence.EntityNotFoundException;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

public abstract class AbstractControllable<T, ID>
implements SimplySpec<T, ID> {
    private final AbstractServiceable<T, ID> service;

    @SimplyLogging
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public T create(@Valid @RequestBody T createForm) throws Throwable {
        return (T)this.service.create(createForm);
    }

    @SimplyLogging
    @PutMapping(value={"/{id}"})
    public T replaceById(@PathVariable ID id, @RequestBody @Valid T replace) throws Throwable {
        this.checkEntityExistenceAndThrow(id);
        return (T)this.service.replaceById(id, replace);
    }

    @SimplyLogging
    @PatchMapping(value={"/{id}"})
    public T updateById(@PathVariable ID id, @RequestBody Map<String, Object> fields) throws Throwable {
        this.checkEntityExistenceAndThrow(id);
        return (T)this.service.updateById(id, fields);
    }

    @GetMapping(value={"/{id}"})
    public T get(@PathVariable ID id) throws Throwable {
        return (T)this.service.get(id);
    }

    @GetMapping
    public List<T> getAll() {
        List all = this.service.getAll();
        if (all.isEmpty()) {
            throw new EntityNotFoundException();
        }
        return all;
    }

    @SimplyLogging
    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteById(@PathVariable ID id) throws Throwable {
        try {
            this.checkEntityExistenceAndThrow(id);
        }
        catch (NoSuchElementException e) {
            return;
        }
        this.service.deleteById(id);
    }

    public void delete(T entity) throws Throwable {
    }

    private void checkEntityExistenceAndThrow(@PathVariable ID id) throws NoSuchElementException {
        try {
            this.service.get(id);
        }
        catch (EntityNotFoundException e) {
            throw new NoSuchElementException(e.getMessage());
        }
    }

    public AbstractControllable(AbstractServiceable<T, ID> service) {
        this.service = service;
    }
}

