/*
 * Decompiled with CFR 0.152.
 */
package io.easywalk.simply.clientable;

import io.easywalk.simply.controllable.SimplyErrorResponse;
import io.easywalk.simply.specification.SimplySpec;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class AbstractClientable<T, ID>
implements SimplySpec<T, ID> {
    private static final Logger log = LoggerFactory.getLogger(AbstractClientable.class);
    private WebClient client;
    private Class<T> entityTypeClass;

    public AbstractClientable(Class<T> typeParameterClass, WebClient client) {
        this.entityTypeClass = typeParameterClass;
        this.client = client;
    }

    private Throwable makeException(SimplyErrorResponse errorbody) {
        try {
            Class<?> exception = Class.forName(errorbody.getOriginalExceptionType());
            Constructor<?>[] constructors = exception.getDeclaredConstructors();
            Optional<Object> exceptionClass = Arrays.stream(constructors).filter(constructor -> constructor.getParameterTypes().length == 1 && constructor.getParameterTypes()[0].equals(String.class)).map(newException -> {
                try {
                    return newException.newInstance(errorbody.getDescription());
                }
                catch (Exception e) {
                    log.debug(e.getMessage());
                    return null;
                }
            }).findFirst();
            return (Throwable)exceptionClass.orElseGet(() -> new Exception(errorbody.getDescription()));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return new Exception(errorbody.getDescription());
        }
    }

    public T create(T createForm) throws Throwable {
        return (T)this.client.post().body((Object)Mono.just(createForm), createForm.getClass()).retrieve().onStatus(status -> !status.equals((Object)HttpStatus.CREATED), clientResponse -> clientResponse.bodyToMono(SimplyErrorResponse.class).flatMap(errorbody -> Mono.error((Throwable)this.makeException((SimplyErrorResponse)errorbody)))).bodyToMono(this.entityTypeClass).block();
    }

    public T replaceById(ID id, T replace) throws Throwable {
        String path = "/" + id.toString();
        return (T)((WebClient.RequestBodySpec)this.client.put().uri(path, new Object[0])).body((Object)Mono.just(replace), replace.getClass()).retrieve().onStatus(status -> !status.equals((Object)HttpStatus.OK), clientResponse -> clientResponse.bodyToMono(SimplyErrorResponse.class).flatMap(errorbody -> Mono.error((Throwable)this.makeException((SimplyErrorResponse)errorbody)))).bodyToMono(this.entityTypeClass).block();
    }

    public T updateById(ID id, Map<String, Object> fields) throws Throwable {
        String path = "/" + id.toString();
        return (T)((WebClient.RequestBodySpec)this.client.patch().uri(path, new Object[0])).body((Object)Mono.just(fields), fields.getClass()).retrieve().onStatus(status -> !status.equals((Object)HttpStatus.OK), clientResponse -> clientResponse.bodyToMono(SimplyErrorResponse.class).flatMap(errorbody -> Mono.error((Throwable)this.makeException((SimplyErrorResponse)errorbody)))).bodyToMono(this.entityTypeClass).block();
    }

    public T get(ID id) throws Throwable {
        String path = "/" + id.toString();
        return (T)this.client.get().uri(path, new Object[0]).retrieve().onStatus(status -> !status.equals((Object)HttpStatus.OK), clientResponse -> clientResponse.bodyToMono(SimplyErrorResponse.class).flatMap(errorbody -> Mono.error((Throwable)this.makeException((SimplyErrorResponse)errorbody)))).bodyToMono(this.entityTypeClass).block();
    }

    public List<T> getAll() throws Throwable {
        return (List)this.client.get().retrieve().onStatus(status -> !status.equals((Object)HttpStatus.OK), clientResponse -> clientResponse.bodyToMono(SimplyErrorResponse.class).flatMap(errorbody -> Mono.error((Throwable)this.makeException((SimplyErrorResponse)errorbody)))).bodyToFlux(this.entityTypeClass).collect(Collectors.toList()).block();
    }

    public void deleteById(ID id) throws Throwable {
        String path = "/" + id.toString();
        this.client.delete().uri(path, new Object[0]).retrieve().onStatus(status -> !status.equals((Object)HttpStatus.NO_CONTENT), clientResponse -> clientResponse.bodyToMono(SimplyErrorResponse.class).flatMap(errorbody -> Mono.error((Throwable)this.makeException((SimplyErrorResponse)errorbody)))).bodyToMono(Void.class).block();
    }

    public void delete(T entity) throws Throwable {
        throw new Exception("Not Implement");
    }

    public WebClient getClient() {
        return this.client;
    }

    public Class<T> getEntityTypeClass() {
        return this.entityTypeClass;
    }

    public void setClient(WebClient client) {
        this.client = client;
    }

    public void setEntityTypeClass(Class<T> entityTypeClass) {
        this.entityTypeClass = entityTypeClass;
    }
}

