/*
 * Decompiled with CFR 0.152.
 */
package io.easyspring.service.file.impl;

import io.easyspring.framework.common.snowflake.SnowflakeHelp;
import io.easyspring.framework.common.utils.FileUtils;
import io.easyspring.service.file.EasyFileException;
import io.easyspring.service.file.FilePathGenerator;
import io.easyspring.service.file.properties.FileProperties;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DefaultFilePathGeneratorImpl
implements FilePathGenerator {
    @Autowired
    private FileProperties fileProperties;
    @Autowired
    private SnowflakeHelp snowflakeHelp;

    @Override
    public String getBucketName(String fileTypeCode) {
        Map<String, String> bucketNameMap = this.fileProperties.getBucketName();
        if (CollectionUtils.isEmpty(bucketNameMap)) {
            throw new EasyFileException("\u6587\u4ef6\u7684\u5b58\u50a8\u533a\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a, \u8bf7\u914d\u7f6e easy-spring.file.bucket-name");
        }
        String bucketName = bucketNameMap.get(fileTypeCode);
        if (StringUtils.isEmpty((Object)bucketName)) {
            throw new EasyFileException("\u6587\u4ef6\u8bc6\u522b\u7801 " + fileTypeCode + "\u5bf9\u5e94\u7684\u5b58\u50a8\u533a\u4e0d\u5b58\u5728, \u8bf7\u68c0\u67e5\u914d\u7f6e: easy-spring.file.bucket-name");
        }
        return bucketName;
    }

    @Override
    public String generatorObjectName(String fileTypeCode, String fileName) {
        String objectNamePrefix = this.getObjectNamePrefix(fileTypeCode);
        String intermediatePath = this.generatorObjectIntermediatePath();
        return objectNamePrefix + intermediatePath + "/" + fileName;
    }

    @Override
    public String generatorNewObjectName(String fileTypeCode, String sourceFileName) {
        String objectNamePrefix = this.getObjectNamePrefix(fileTypeCode);
        String intermediatePath = this.generatorObjectIntermediatePath();
        String newFileName = this.generatorNewFileName(sourceFileName);
        return objectNamePrefix + intermediatePath + "/" + newFileName;
    }

    @Override
    public String generatorNewFileName(String sourceFileName) {
        String newFileName = String.valueOf(this.snowflakeHelp.nextId());
        if (StringUtils.isEmpty((Object)sourceFileName)) {
            return newFileName;
        }
        String fileSuffix = FileUtils.getFileSuffix((String)sourceFileName);
        if (!StringUtils.isEmpty((Object)fileSuffix)) {
            newFileName = newFileName + fileSuffix;
        }
        return newFileName;
    }

    @Override
    public String generatorObjectIntermediatePath() {
        return FileUtils.getDatePath();
    }

    private String getObjectNamePrefix(String fileTypeCode) {
        Map<String, String> objectNamePrefixMap = this.fileProperties.getObjectNamePrefix();
        if (CollectionUtils.isEmpty(objectNamePrefixMap)) {
            throw new EasyFileException("\u6587\u4ef6\u7684\u540d\u79f0\u524d\u7f00\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a, \u8bf7\u914d\u7f6e easy-spring.file.object-name-prefix");
        }
        String objectNamePrefix = objectNamePrefixMap.get(fileTypeCode);
        if (StringUtils.isEmpty((Object)objectNamePrefix)) {
            throw new EasyFileException("\u6587\u4ef6\u8bc6\u522b\u7801 " + fileTypeCode + "\u5bf9\u5e94\u7684\u6587\u4ef6\u540d\u79f0\u524d\u7f00\u4e0d\u5b58\u5728, \u8bf7\u68c0\u67e5\u914d\u7f6e: easy-spring.file.object-name-prefix");
        }
        return objectNamePrefix;
    }
}

