/*
 * Decompiled with CFR 0.152.
 */
package io.easyspring.service.file.impl;

import io.easyspring.service.file.FilePathGenerator;
import io.easyspring.service.file.FileProcessor;
import io.easyspring.service.file.support.SimpleUserFile;
import java.io.File;
import java.io.InputStream;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;

@Validated
public abstract class AbstractFileProcessor
implements FileProcessor {
    private static final Logger log = LoggerFactory.getLogger(AbstractFileProcessor.class);
    @Autowired
    private FilePathGenerator filePathGenerator;

    @Override
    public SimpleUserFile upload(String fileTypeCode, File uploadFile) {
        String bucketName = this.filePathGenerator.getBucketName(fileTypeCode);
        String objectName = this.filePathGenerator.generatorNewObjectName(fileTypeCode, uploadFile.getName());
        return this.putObject(bucketName, objectName, uploadFile);
    }

    @Override
    public SimpleUserFile upload(String fileTypeCode, String fileName, InputStream fileInputStream) {
        String bucketName = this.filePathGenerator.getBucketName(fileTypeCode);
        String objectName = this.filePathGenerator.generatorNewObjectName(fileTypeCode, fileName);
        return this.putObject(bucketName, objectName, fileInputStream);
    }

    protected abstract SimpleUserFile putObject(@NotBlank(message="\u6587\u4ef6\u5b58\u50a8\u533a\u7684\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u6587\u4ef6\u5b58\u50a8\u533a\u7684\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String var1, @NotBlank(message="\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String var2, @NotNull(message="\u4e0a\u4f20\u7684\u6587\u4ef6\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u4e0a\u4f20\u7684\u6587\u4ef6\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a") File var3);

    protected abstract SimpleUserFile putObject(@NotBlank(message="\u6587\u4ef6\u5b58\u50a8\u533a\u7684\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u6587\u4ef6\u5b58\u50a8\u533a\u7684\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String var1, @NotBlank(message="\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String var2, @NotNull(message="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41\u4e0d\u80fd\u4e3a\u7a7a") InputStream var3);

    @Override
    public String generatorUrl(SimpleUserFile simpleUserFile, Long expiration, String style) {
        return this.getUrl(simpleUserFile, expiration, style);
    }

    @Override
    public String generatorUrl(String bucketName, String objectName, Long expiration, String style) {
        SimpleUserFile simpleUserFile = new SimpleUserFile();
        simpleUserFile.setBucketName(bucketName);
        simpleUserFile.setObjectName(objectName);
        return this.getUrl(simpleUserFile, expiration, style);
    }

    protected abstract String getUrl(@NotNull(message="\u7b80\u5355\u7528\u6237\u6587\u4ef6\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a") @Valid @NotNull(message="\u7b80\u5355\u7528\u6237\u6587\u4ef6\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a") @Valid SimpleUserFile var1, Long var2, String var3);
}

