/*
 * Decompiled with CFR 0.152.
 */
package io.easyspring.security.social;

import io.easyspring.security.social.support.SocialUserInfo;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.web.ProviderSignInUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;

@RestController
public class SpringSocialController {
    private static final Logger log = LoggerFactory.getLogger(SpringSocialController.class);
    @Autowired
    private ProviderSignInUtils providerSignInUtils;

    @GetMapping(value={"/social/user"})
    public SocialUserInfo getSocialUserInfo(HttpServletRequest request) {
        Connection connection = this.providerSignInUtils.getConnectionFromSession((RequestAttributes)new ServletWebRequest(request));
        SocialUserInfo socialUserInfo = new SocialUserInfo();
        socialUserInfo.setProviderId(connection.getKey().getProviderId());
        socialUserInfo.setProviderUserId(connection.getKey().getProviderUserId());
        socialUserInfo.setNickname(connection.getDisplayName());
        socialUserInfo.setHeadImage(connection.getImageUrl());
        return socialUserInfo;
    }
}

