/*
 * Decompiled with CFR 0.152.
 */
package io.easyspring.security.social;

import io.easyspring.security.social.EasySpringSocialConfigurer;
import io.easyspring.security.social.SocialAuthenticationFilterPostProcessor;
import io.easyspring.security.social.properties.SocialProperties;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.encrypt.Encryptors;
import org.springframework.social.UserIdSource;
import org.springframework.social.config.annotation.EnableSocial;
import org.springframework.social.config.annotation.SocialConfigurerAdapter;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.ConnectionRepository;
import org.springframework.social.connect.ConnectionSignUp;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.connect.jdbc.JdbcUsersConnectionRepository;
import org.springframework.social.connect.web.ConnectController;
import org.springframework.social.connect.web.ProviderSignInUtils;
import org.springframework.social.security.AuthenticationNameUserIdSource;
import org.springframework.social.security.SpringSocialConfigurer;

@Configuration
@EnableSocial
@EnableConfigurationProperties(value={SocialProperties.class})
public class SocialConfig
extends SocialConfigurerAdapter {
    @Autowired
    private DataSource dataSource;
    @Autowired
    private SocialProperties socialProperties;
    @Autowired(required=false)
    private ConnectionSignUp connectionSignUp;
    @Autowired(required=false)
    private SocialAuthenticationFilterPostProcessor socialAuthenticationFilterPostProcessor;

    public UsersConnectionRepository getUsersConnectionRepository(ConnectionFactoryLocator connectionFactoryLocator) {
        JdbcUsersConnectionRepository repository = new JdbcUsersConnectionRepository(this.dataSource, connectionFactoryLocator, Encryptors.noOpText());
        if (this.connectionSignUp != null) {
            repository.setConnectionSignUp(this.connectionSignUp);
        }
        repository.setTablePrefix("EasySpring_");
        return repository;
    }

    @Bean
    public SpringSocialConfigurer easySpringSocialConfigurer() {
        String filterProcessUrl = this.socialProperties.getFilterProcessesUrl();
        EasySpringSocialConfigurer configurer = new EasySpringSocialConfigurer(filterProcessUrl);
        configurer.signupUrl(this.socialProperties.getSignUpUrl());
        configurer.setSocialAuthenticationFilterPostProcessor(this.socialAuthenticationFilterPostProcessor);
        return configurer;
    }

    public UserIdSource getUserIdSource() {
        return new AuthenticationNameUserIdSource();
    }

    @Bean
    public ProviderSignInUtils providerSignInUtils(ConnectionFactoryLocator connectionFactoryLocator) {
        return new ProviderSignInUtils(connectionFactoryLocator, this.getUsersConnectionRepository(connectionFactoryLocator)){};
    }

    @Bean
    public ConnectController connectController(ConnectionFactoryLocator connectionFactoryLocator, ConnectionRepository connectionRepository) {
        return new ConnectController(connectionFactoryLocator, connectionRepository);
    }
}

