/*
 * Decompiled with CFR 0.152.
 */
package io.easyspring.security.authorize.dynamic.impl;

import io.easyspring.security.authorize.dynamic.DynamicAuthorizePermissionService;
import io.easyspring.security.authorize.dynamic.DynamicAuthorizeService;
import io.easyspring.security.authorize.support.AuthorizePermission;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DynamicAuthorizePermissionServiceImpl
implements DynamicAuthorizePermissionService {
    private static final Logger log = LoggerFactory.getLogger(DynamicAuthorizePermissionServiceImpl.class);
    private AntPathMatcher antPathMatcher = new AntPathMatcher();
    private DynamicAuthorizeService dynamicAuthorizeService;

    @Override
    public boolean hasPermission(HttpServletRequest request, Authentication authentication) {
        log.warn("DynamicAuthorize verify hasPermission, requestURI: {}, requestUrl: {}, requestMethod: {}", new Object[]{request.getRequestURI(), request.getRequestURL(), request.getMethod()});
        Object principal = authentication.getPrincipal();
        String username = null;
        if (principal instanceof UserDetails) {
            username = ((UserDetails)principal).getUsername();
        } else if (principal instanceof String) {
            username = (String)principal;
        }
        Set<AuthorizePermission> authorizePermissionSet = null;
        if (this.dynamicAuthorizeService == null || StringUtils.isEmpty((Object)username)) {
            return false;
        }
        authorizePermissionSet = this.dynamicAuthorizeService.getAuthorizePermission(username);
        return this.hasPermission(request, authorizePermissionSet);
    }

    private boolean hasPermission(HttpServletRequest request, Set<AuthorizePermission> authorizePermissionSet) {
        if (request == null || CollectionUtils.isEmpty(authorizePermissionSet)) {
            return false;
        }
        boolean hasPermission = false;
        for (AuthorizePermission authorizePermission : authorizePermissionSet) {
            if (authorizePermission == null) continue;
            String authorizePermissionUrl = authorizePermission.getUrl();
            HttpMethod authorizePermissionMethod = authorizePermission.getMethod();
            log.info("DynamicAuthorize authorizePermissionUrl: {}, authorizePermissionMethod: {}", (Object)authorizePermissionUrl, (Object)authorizePermissionMethod);
            log.info("DynamicAuthorize request.getRequestURI: {}, request.getMethod: {}", (Object)request.getRequestURI(), (Object)request.getMethod());
            if (StringUtils.isEmpty((Object)authorizePermissionUrl) || authorizePermissionMethod == null) continue;
            boolean urlMatch = this.antPathMatcher.match(authorizePermissionUrl, request.getRequestURI());
            boolean methodMatch = request.getMethod().equalsIgnoreCase(authorizePermissionMethod.toString());
            log.info("DynamicAuthorize urlMatch: {}, methodMatch: {}", (Object)urlMatch, (Object)methodMatch);
            if (!urlMatch || !methodMatch) continue;
            hasPermission = true;
            break;
        }
        return hasPermission;
    }

    public AntPathMatcher getAntPathMatcher() {
        return this.antPathMatcher;
    }

    public DynamicAuthorizeService getDynamicAuthorizeService() {
        return this.dynamicAuthorizeService;
    }

    public void setAntPathMatcher(AntPathMatcher antPathMatcher) {
        this.antPathMatcher = antPathMatcher;
    }

    public void setDynamicAuthorizeService(DynamicAuthorizeService dynamicAuthorizeService) {
        this.dynamicAuthorizeService = dynamicAuthorizeService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicAuthorizePermissionServiceImpl)) {
            return false;
        }
        DynamicAuthorizePermissionServiceImpl other = (DynamicAuthorizePermissionServiceImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AntPathMatcher this$antPathMatcher = this.getAntPathMatcher();
        AntPathMatcher other$antPathMatcher = other.getAntPathMatcher();
        if (this$antPathMatcher == null ? other$antPathMatcher != null : !this$antPathMatcher.equals(other$antPathMatcher)) {
            return false;
        }
        DynamicAuthorizeService this$dynamicAuthorizeService = this.getDynamicAuthorizeService();
        DynamicAuthorizeService other$dynamicAuthorizeService = other.getDynamicAuthorizeService();
        return !(this$dynamicAuthorizeService == null ? other$dynamicAuthorizeService != null : !this$dynamicAuthorizeService.equals(other$dynamicAuthorizeService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamicAuthorizePermissionServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AntPathMatcher $antPathMatcher = this.getAntPathMatcher();
        result = result * 59 + ($antPathMatcher == null ? 43 : $antPathMatcher.hashCode());
        DynamicAuthorizeService $dynamicAuthorizeService = this.getDynamicAuthorizeService();
        result = result * 59 + ($dynamicAuthorizeService == null ? 43 : $dynamicAuthorizeService.hashCode());
        return result;
    }

    public String toString() {
        return "DynamicAuthorizePermissionServiceImpl(antPathMatcher=" + this.getAntPathMatcher() + ", dynamicAuthorizeService=" + this.getDynamicAuthorizeService() + ")";
    }
}

