/*
 * Decompiled with CFR 0.152.
 */
package io.easyspring.security.authorize;

import io.easyspring.security.authorize.AuthorizeConfigProvider;
import io.easyspring.security.authorize.properties.DynamicAuthorizeProperties;
import io.easyspring.security.authorize.support.AuthorizePermission;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
@Order(value=30)
public class DynamicAuthorizeConfigProvider
implements AuthorizeConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(DynamicAuthorizeConfigProvider.class);
    @Autowired
    private DynamicAuthorizeProperties dynamicAuthorizeProperties;

    public void config(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry config) {
        List<AuthorizePermission> ignoreAuthorizeUrls = this.dynamicAuthorizeProperties.getIgnoreAuthorizeUrls();
        if (!CollectionUtils.isEmpty(ignoreAuthorizeUrls)) {
            for (AuthorizePermission authorizePermission : ignoreAuthorizeUrls) {
                if (authorizePermission == null || authorizePermission.getMethod() == null || StringUtils.isEmpty((Object)authorizePermission.getUrl())) continue;
                ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)config.antMatchers(authorizePermission.getMethod(), new String[]{authorizePermission.getUrl()})).permitAll();
            }
            log.info("SocialAuthorizeConfigProvider ignoreAuthorizes: {}", (Object)ignoreAuthorizeUrls.toString());
        }
    }
}

