/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.site.search.offline;

import io.earcam.unexceptional.Exceptional;
import io.earcam.utilitarian.site.search.offline.ConfigurationModel;
import io.earcam.utilitarian.site.search.offline.Indexer;
import io.earcam.utilitarian.site.search.offline.Resources;
import io.earcam.utilitarian.site.search.offline.jsonb.JsonBind;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class Search {
    public static void main(String[] args) {
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "trace");
        if (args.length < 2) {
            throw new IllegalArgumentException("Expected first arg to be json-output-dir, then at least a further argument of the form 'baseDir@baseUri'");
        }
        String jsonDir = args[0];
        Indexer indexer = null;
        for (int i = 1; i < args.length; ++i) {
            int index = args[i].indexOf(64);
            if (index == -1) {
                throw new IllegalArgumentException("Only arguments expected are 'baseDir@baseUri', recieved '" + args[i] + "' at index " + i);
            }
            Path baseDir = Paths.get(args[i].substring(0, index), new String[0]);
            URI baseUri = Exceptional.uri((CharSequence)args[i].substring(index + 1));
            Map<String, String> searchReplace = Search.searchReplaceMap(jsonDir, baseDir, baseUri);
            String crawlerJson = Resources.getResource("META-INF/configuration/default-crawler-maven.json", StandardCharsets.UTF_8, searchReplace);
            ConfigurationModel.Crawling crawler = JsonBind.readJson(crawlerJson, ConfigurationModel.Crawling.class);
            if (indexer == null) {
                String indexerJson = Resources.getResource("META-INF/configuration/default-indexer-maven.json", StandardCharsets.UTF_8, searchReplace);
                indexer = JsonBind.readJson(indexerJson, ConfigurationModel.Indexing.class).build();
            }
            indexer.add(crawler.build().documents());
        }
        indexer.writeJson();
    }

    private static Map<String, String> searchReplaceMap(String jsonDir, Path baseDir, URI baseUri) {
        HashMap<String, String> searchReplace = new HashMap<String, String>();
        searchReplace.put("${outputCharset}", StandardCharsets.UTF_8.name());
        searchReplace.put("${jsonDir}", jsonDir);
        searchReplace.put("${baseDir}", baseDir.toAbsolutePath().toString());
        searchReplace.put("${baseUri}", baseUri.toString());
        return searchReplace;
    }
}

