/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.site.search.offline;

import io.earcam.utilitarian.site.search.offline.Component;
import io.earcam.utilitarian.site.search.offline.Document;
import io.earcam.utilitarian.site.search.offline.Filter;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(RegexFilter.class);
    public static final String INCLUDE = "include";
    public static final String EXCLUDE = "exclude";
    public final String id = this.id();
    private Predicate<String> predicate;

    @Override
    public void configure(Map<String, String> configuration) {
        String include = Component.mandatory(configuration, INCLUDE);
        String exclude = Component.mandatory(configuration, EXCLUDE);
        this.predicate = Pattern.compile(include).asPredicate().and(Pattern.compile(exclude).asPredicate().negate());
        LOG.debug("{} include pattern: {}", (Object)this.id, (Object)include);
        LOG.debug("{} exclude pattern: {}", (Object)this.id, (Object)exclude);
    }

    @Override
    public boolean test(Document document) {
        String path = document.file().toAbsolutePath().toString();
        boolean include = this.predicate.test(path);
        LOG.debug("{} {}cluding {}", new Object[]{this.id, include ? "in" : "ex", path});
        return include;
    }
}

