/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.site.search.offline;

import io.earcam.unexceptional.Closing;
import io.earcam.utilitarian.site.search.offline.Document;
import io.earcam.utilitarian.site.search.offline.Processor;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.text.PDFTextStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfContentProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(PdfContentProcessor.class);

    @Override
    public void process(Document document) {
        if (this.isPdf(document) && !document.hasRaw()) {
            try {
                Closing.closeAfterAccepting(PDDocument::load, (Object)document.file().toFile(), (Object)document, this::consume);
            }
            catch (UncheckedIOException e) {
                LOG.warn("Failed to process PDF {} due to: {}", (Object)document.file(), (Object)e.getMessage());
                LOG.debug("Failed to process PDF", (Throwable)e.getCause());
            }
        }
    }

    private void consume(PDDocument pdf, Document document) throws IOException {
        PDDocumentInformation information = pdf.getDocumentInformation();
        document.field("title", information.getTitle());
        PDFTextStripper stripper = new PDFTextStripper();
        String text = stripper.getText(pdf);
        document.field("raw", text);
    }

    private boolean isPdf(Document document) {
        return "application/pdf".equals(document.contentType());
    }

    static {
        System.setProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.KcmsServiceProvider");
    }
}

